/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.app.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.mobile.push.app.dao.AppMapper;
import com.jxdinfo.hussar.mobile.push.app.dto.AppDto;
import com.jxdinfo.hussar.mobile.push.app.model.App;
import com.jxdinfo.hussar.mobile.push.app.service.AppService;
import com.jxdinfo.hussar.mobile.push.app.vo.AppVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppServiceImpl
extends HussarServiceImpl<AppMapper, App>
implements AppService {
    @Resource
    private AppMapper appMapper;
    @Resource
    private SysAuthClientModelService sysAuthClientModelService;

    public ApiResponse<Boolean> addApp(AppDto appDTO) {
        String accessId = RandomUtil.randomNumbers((int)10);
        String secretKey = IdUtil.randomUUID().replace("-", "");
        appDTO.setAccessId(accessId);
        appDTO.setSecretKey(secretKey);
        SysAuthClientModel sysAuthClientModel = new SysAuthClientModel();
        sysAuthClientModel.setClientId(accessId);
        sysAuthClientModel.setClientSecret(secretKey);
        sysAuthClientModel.setAllowUrl("*");
        sysAuthClientModel.setContractScope("push_server");
        sysAuthClientModel.setAuthorizedGrantType("client_credentials");
        sysAuthClientModel.setAccessTokenValidTime(1800L);
        sysAuthClientModel.setRefreshTokenValidTime(86400L);
        try {
            this.sysAuthClientModelService.saveAuthClientModel(sysAuthClientModel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ApiResponse.success((Object)this.save((BaseEntity)appDTO));
    }

    public ApiResponse<Boolean> updateApp(AppDto appDTO) {
        return ApiResponse.success((Object)this.updateById((BaseEntity)appDTO));
    }

    public ApiResponse<Boolean> deleteApp(Long appId) {
        return ApiResponse.success((Object)this.removeById(appId));
    }

    public ApiResponse<Page<AppVO>> getAppList(PageInfo pageInfo, AppDto appDTO) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        Long creator = BaseSecurityUtil.getUser().getId();
        String today = DateUtil.formatDate((Date)new Date());
        return ApiResponse.success(this.appMapper.getAppList((Page<AppVO>)page, creator, today));
    }

    public List<String> getAppIdList(Long userId) {
        return this.appMapper.getAppIdList(userId);
    }

    public ApiResponse<App> getAppById(Long appId) {
        return ApiResponse.success((Object)this.getById(appId));
    }
}

