/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.mobile.push.app.dao.TokenMapper;
import com.jxdinfo.hussar.mobile.push.app.dto.DeviceTokenDto;
import com.jxdinfo.hussar.mobile.push.app.model.DeviceToken;
import com.jxdinfo.hussar.mobile.push.app.model.TagToken;
import com.jxdinfo.hussar.mobile.push.app.service.TagService;
import com.jxdinfo.hussar.mobile.push.app.service.TokenService;
import com.jxdinfo.hussar.mobile.push.app.vo.DeviceTokenVo;
import com.jxdinfo.hussar.mobile.push.publish.enums.ProTypeEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TokenServiceImpl
extends HussarServiceImpl<TokenMapper, DeviceToken>
implements TokenService {
    @Resource
    private TokenMapper tokenMapper;
    @Resource
    private TagService tagService;

    public ApiResponse<Page<DeviceTokenVo>> getDeviceTokenVo(PageInfo pageInfo, String appId, String proType, String device) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        if (HussarUtils.isNotEmpty((Object)appId)) {
            return ApiResponse.success(this.tokenMapper.getDeviceTokenVo((Page<DeviceTokenVo>)page, appId, null, proType, device));
        }
        return ApiResponse.success(this.tokenMapper.getDeviceTokenVo((Page<DeviceTokenVo>)page, null, null, proType, device));
    }

    public ApiResponse<String> saveToken(DeviceTokenDto tokenDto) {
        if (HussarUtils.isEmpty((Object)tokenDto.getProToken())) {
            return ApiResponse.fail((String)"\u5382\u5546token\u7f3a\u5931\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(DeviceToken::getProToken, (Object)tokenDto.getProToken())).eq(DeviceToken::getAppId, (Object)tokenDto.getAppId());
        tokenDto.setDeviceToken(ProTypeEnum.values()[tokenDto.getProType()].encodeToken(tokenDto.getProToken()));
        if (HussarUtils.isEmpty((Object)this.list((Wrapper)queryWrapper))) {
            this.save((BaseEntity)tokenDto);
        }
        return ApiResponse.success((Object)tokenDto.getDeviceToken(), (String)"");
    }

    public ApiResponse<Boolean> removeToken(DeviceTokenDto tokenDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(DeviceToken::getAppId, (Object)tokenDto.getAppId())).eq(DeviceToken::getDeviceToken, (Object)tokenDto.getDeviceToken());
        DeviceToken tokenDO2 = (DeviceToken)this.getOne((Wrapper)queryWrapper);
        if (tokenDO2 != null) {
            boolean flag = this.removeById(tokenDO2.getId());
            if (flag) {
                LambdaQueryWrapper queryTagWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryTagWrapper.eq(TagToken::getAppId, (Object)tokenDto.getAppId())).eq(TagToken::getToken, (Object)tokenDto.getDeviceToken());
                this.tagService.remove((Wrapper)queryTagWrapper);
                return ApiResponse.success((Object)true);
            }
            return ApiResponse.fail((String)"\u5220\u9664token\u5931\u8d25");
        }
        return ApiResponse.fail((String)"\u8bbe\u5907token\u65e0\u6548");
    }

    public ApiResponse<Page<DeviceTokenVo>> getDeviceTokenList(PageInfo pageInfo, String appId, String proType, String device) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        if (HussarUtils.isNotEmpty((Object)appId)) {
            return ApiResponse.success(this.tokenMapper.getDeviceTokenVo((Page<DeviceTokenVo>)page, appId, null, proType, device));
        }
        Long creator = BaseSecurityUtil.getUser().getId();
        return ApiResponse.success(this.tokenMapper.getDeviceTokenVo((Page<DeviceTokenVo>)page, null, creator, proType, device));
    }
}

