/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.mobile.push.app.dao.TagTokenMapper;
import com.jxdinfo.hussar.mobile.push.app.dto.TagDto;
import com.jxdinfo.hussar.mobile.push.app.model.DeviceToken;
import com.jxdinfo.hussar.mobile.push.app.model.TagToken;
import com.jxdinfo.hussar.mobile.push.app.service.TagService;
import com.jxdinfo.hussar.mobile.push.app.service.TokenService;
import com.jxdinfo.hussar.mobile.push.app.vo.TagTokenVo;
import com.jxdinfo.hussar.mobile.push.app.vo.TagTypeVo;
import com.jxdinfo.hussar.mobile.push.publish.enums.CodeEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TagServiceImpl
extends HussarServiceImpl<TagTokenMapper, TagToken>
implements TagService {
    @Resource
    private TokenService tokenService;
    @Resource
    private TagTokenMapper tagTokenMapper;

    public ApiResponse<Boolean> bindingTag(TagDto tagDto) {
        boolean invalid;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(DeviceToken::getAppId, (Object)tagDto.getAppId())).eq(DeviceToken::getDeviceToken, (Object)tagDto.getToken());
        DeviceToken deviceTokenDO = (DeviceToken)this.tokenService.getOne((Wrapper)queryWrapper);
        if (deviceTokenDO == null) {
            return ApiResponse.fail((int)CodeEnum.INVALID_TOKEN.getCode(), (String)CodeEnum.INVALID_TOKEN.getName());
        }
        boolean bl = invalid = (tagDto.getOperatorType() == null || tagDto.getOperatorType() == 0 || tagDto.getOperatorType() == 1) && tagDto.getTagList().size() > 100;
        if (invalid) {
            return ApiResponse.fail((String)"\u6bcf\u4e2a\u8bbe\u5907\u6700\u591a\u7ed1\u5b9a100\u4e2a\u6807\u7b7e");
        }
        if (tagDto.getOperatorType() != null && tagDto.getOperatorType() != 0) {
            return this.coverOrDeleteTagToken(tagDto);
        }
        boolean result = this.addTagToken(tagDto);
        return ApiResponse.success((Object)result);
    }

    public boolean addTagToken(TagDto tagDTO) {
        ArrayList entityList = new ArrayList();
        List tagList = tagDTO.getTagList();
        tagList.forEach(m -> {
            TagToken tagToken = new TagToken();
            tagToken.setTag(m);
            tagToken.setAppId(tagDTO.getAppId());
            tagToken.setToken(tagDTO.getToken());
            tagToken.setTagCode(tagDTO.getTagCode());
            entityList.add(tagToken);
        });
        return this.saveOrUpdateBatch(entityList);
    }

    public ApiResponse<Boolean> coverOrDeleteTagToken(TagDto tagDTO) {
        boolean result = false;
        ArrayList<TagToken> entityList = new ArrayList<TagToken>();
        int operatorType = tagDTO.getOperatorType();
        List tagList = tagDTO.getTagList();
        tagList.forEach(tag -> {
            TagToken tagToken = new TagToken();
            tagToken.setTagCode(tagDTO.getTagCode());
            tagToken.setToken(tagDTO.getToken());
            tagToken.setAppId(tagDTO.getAppId());
            tagToken.setTag(tag);
            entityList.add(tagToken);
        });
        int count = 0;
        if (operatorType == 1) {
            this.tagTokenMapper.deleteByToken(tagDTO.getToken(), tagDTO.getAppId());
            result = this.saveOrUpdateBatch(entityList);
            return ApiResponse.success((Object)result);
        }
        count = this.tagTokenMapper.deleteBatchByTokenAndCodeAndTag(entityList);
        result = count > 0;
        return result ? ApiResponse.success((Object)result) : ApiResponse.fail((int)CodeEnum.INVOKE_SERVICE_ERROR.getCode(), (Object)result, (String)"\u6807\u7b7e\u4e0d\u5b58\u5728");
    }

    public ApiResponse<List<TagTokenVo>> getTagByToken(String token) {
        return ApiResponse.success(this.tagTokenMapper.getTagByToken(token));
    }

    public ApiResponse<List<String>> getTagsByTagCode(Long appId, String tagCode) {
        return ApiResponse.success(this.tagTokenMapper.getTagsByTagCode(appId, tagCode));
    }

    public ApiResponse<List<TagTypeVo>> getTagCodeByAppId() {
        return ApiResponse.success(this.tagTokenMapper.getTagCodeByAppId());
    }

    public ApiResponse<Page<TagTokenVo>> getTagVo(PageInfo pageInfo, TagToken tagToken) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        if (HussarUtils.isNotEmpty((Object)tagToken.getAppId())) {
            return ApiResponse.success(this.tagTokenMapper.getTagVo((Page<TagTokenVo>)page, tagToken.getAppId(), null, tagToken.getTagCode()));
        }
        return ApiResponse.success(this.tagTokenMapper.getTagVo((Page<TagTokenVo>)page, null, BaseSecurityUtil.getUser().getId(), tagToken.getTagCode()));
    }
}

