/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.publish.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.mail.core.util.StrUtil;
import com.jxdinfo.hussar.mobile.push.annotation.MethodHandler;
import com.jxdinfo.hussar.mobile.push.annotation.ProType;
import com.jxdinfo.hussar.mobile.push.app.dto.ProducerConfiguration;
import com.jxdinfo.hussar.mobile.push.message.Action;
import com.jxdinfo.hussar.mobile.push.message.Message;
import com.jxdinfo.hussar.mobile.push.message.MzMessage;
import com.jxdinfo.hussar.mobile.push.publish.enums.ProTypeEnum;
import com.jxdinfo.hussar.mobile.push.publish.service.PushMessage;
import com.jxdinfo.hussar.mobile.push.publish.vo.PushResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.meizu.push.sdk.constant.CallBackType;
import com.meizu.push.sdk.constant.ExtraParam;
import com.meizu.push.sdk.server.IFlymePush;
import com.meizu.push.sdk.server.constant.PushResponseCode;
import com.meizu.push.sdk.server.constant.ResultPack;
import com.meizu.push.sdk.server.model.push.VarnishedMessage;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MethodHandler
public class MeiZuServiceImpl
implements PushMessage {
    private static Logger log = LoggerFactory.getLogger(MeiZuServiceImpl.class);
    @Value(value="${push.callbackURL.meizu}")
    private static String mzCallbackUrl;

    @ProType(value={ProTypeEnum.MEIZU})
    public PushResult pushMessage(ProducerConfiguration configuration) {
        PushResult resResult = new PushResult();
        Message xlxMessage = configuration.getMessage();
        String title = xlxMessage.getTitle();
        if (StrUtil.length((CharSequence)title) > 32) {
            title = StrUtil.sub((CharSequence)title, (int)0, (int)26);
            title = StrUtil.addSuffixIfNot((CharSequence)title, (CharSequence)"......");
        }
        xlxMessage.setTitle(title);
        String description = xlxMessage.getContent();
        if (StrUtil.length((CharSequence)description) > 100) {
            description = StrUtil.sub((CharSequence)description, (int)0, (int)94);
            description = StrUtil.addSuffixIfNot((CharSequence)description, (CharSequence)"......");
        }
        xlxMessage.setContent(description);
        ArrayList<String> decodeTokenList = new ArrayList<String>(configuration.getTokenSet());
        try {
            IFlymePush push = new IFlymePush(configuration.getProAppSecretKey());
            VarnishedMessage message = this.buildVarnishedMessage(configuration);
            ResultPack result = push.pushMessage(message, decodeTokenList);
            if (result.isSucceed()) {
                resResult = this.addPushRecord((ResultPack<com.meizu.push.sdk.server.model.push.PushResult>)result, decodeTokenList);
            } else {
                MeiZuServiceImpl.writeErrorLog((ResultPack<com.meizu.push.sdk.server.model.push.PushResult>)result);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        return resResult;
    }

    private VarnishedMessage buildVarnishedMessage(ProducerConfiguration configuration) {
        MzMessage mzMessage = configuration.getMessage().getMzMessage() == null ? new MzMessage() : configuration.getMessage().getMzMessage();
        Action action = configuration.getMessage().getAction() == null ? new Action() : configuration.getMessage().getAction();
        Message pushMessage = configuration.getMessage();
        try {
            VarnishedMessage message = new VarnishedMessage.Builder().appId(Long.valueOf(Long.parseLong(configuration.getProAppId()))).title(pushMessage.getTitle()).content(pushMessage.getContent()).sound(MeiZuServiceImpl.getBooleanValue(pushMessage.getRing())).vibrate(MeiZuServiceImpl.getBooleanValue(pushMessage.getVibrate())).lights(MeiZuServiceImpl.getBooleanValue(pushMessage.getLights())).clearNoticeBar(MeiZuServiceImpl.getBooleanValue(pushMessage.getClearable())).clickType(MeiZuServiceImpl.getActionType(action.getType())).url(MeiZuServiceImpl.getUrl(action)).activity(action.getActivity()).customAttribute(pushMessage.getCustomContent()).validTime(MeiZuServiceImpl.getValidTime(pushMessage.getExpireTime())).pushTimeType(MeiZuServiceImpl.getPushTimeType(pushMessage.getSendTime())).startTime(MeiZuServiceImpl.getSendTime(pushMessage.getSendTime())).notifyKey(pushMessage.getCollapseId() == null ? "" : pushMessage.getCollapseId().toString()).parameters(JSONObject.parseObject((String)(pushMessage.getParameters() == null ? "" : pushMessage.getParameters().toString()))).noticeBarType(mzMessage.getNoticeBarType().intValue()).noticeExpandType(mzMessage.getNoticeExpandType().intValue()).noticeExpandContent(mzMessage.getNoticeExpandContent()).isFixDisplay(mzMessage.getIsFixDisplay().booleanValue()).fixSpeed(mzMessage.getIsFixSpeed().booleanValue()).fixSpeedRate(mzMessage.getFixSpeedRate()).suspend(mzMessage.getIsSuspend().booleanValue()).fixDisplayTime(mzMessage.getFixDisplayStartTime(), mzMessage.getFixDisplayEndTime()).extra(ExtraParam.CALLBACK.getKey(), mzCallbackUrl).extra(ExtraParam.CALLBACK_PARAM.getKey(), configuration.getPushId()).extra(ExtraParam.CALLBACK_TYPE.getKey(), CallBackType.RECEIVE_CLICK.getKey()).build();
            return message;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return null;
        }
    }

    private static boolean getBooleanValue(Integer number) {
        return number == null || number == 1;
    }

    private static int getActionType(Integer activeType) {
        if (activeType != null && activeType == 3) {
            return 2;
        }
        return activeType == null ? 0 : activeType;
    }

    private static String getUrl(Action action) {
        if (action.getType() != null && action.getType() == 2) {
            return action.getUrl();
        }
        if (action.getType() != null && action.getType() == 3) {
            return action.getIntent();
        }
        return null;
    }

    private static int getValidTime(Integer expireTime) {
        if (expireTime == null) {
            expireTime = 0;
        }
        return expireTime > 0 ? 24 : (expireTime < 3600 ? 1 : expireTime / 60 / 60);
    }

    private static int getPushTimeType(String sendTime) {
        if (HussarUtils.isEmpty((Object)sendTime)) {
            return 0;
        }
        try {
            Date sendDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(sendTime);
            Date nowDate = new Date();
            if (sendDate.getTime() > nowDate.getTime()) {
                return 1;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static Date getSendTime(String sendTime) throws ParseException {
        if (HussarUtils.isNotEmpty((Object)sendTime)) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(sendTime);
        }
        return new Date();
    }

    private PushResult addPushRecord(ResultPack<com.meizu.push.sdk.server.model.push.PushResult> result, List<String> tokenList) {
        PushResult respResult = new PushResult();
        Map respTarget = ((com.meizu.push.sdk.server.model.push.PushResult)result.value()).getRespTarget();
        if (respTarget == null || respTarget.isEmpty()) {
            log.info("\u5168\u90e8\u63a8\u9001\u6210\u529f");
            respResult.setSuccessTokens(tokenList);
        } else {
            ArrayList failToken = new ArrayList();
            if (respTarget.containsKey(PushResponseCode.RSP_OK.getValue())) {
                log.info("\u63a8\u9001\u90e8\u5206\u6210\u529f");
                List successToken = (List)respTarget.get(PushResponseCode.RSP_OK.getValue());
                respResult.setSuccessTokens(successToken);
            }
            if (respTarget.containsKey(PushResponseCode.RSP_NO_AUT.getValue())) {
                log.error("\u6ca1\u6709\u6743\u9650\uff0c\u670d\u52a1\u5668\u4e3b\u52a8\u62d2\u7edd");
                failToken.addAll((Collection)respTarget.get(PushResponseCode.RSP_NO_AUT.getValue()));
            }
            if (respTarget.containsKey(PushResponseCode.RSP_DB_ERROR.getValue())) {
                log.error("\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff08db_error\uff09");
                failToken.addAll((Collection)respTarget.get(PushResponseCode.RSP_DB_ERROR.getValue()));
            }
            if (respTarget.containsKey(PushResponseCode.RSP_INTERNAL_ERROR.getValue())) {
                log.error("\u63a8\u9001\u6d88\u606f\u5931\u8d25");
                failToken.addAll((Collection)respTarget.get(PushResponseCode.RSP_INTERNAL_ERROR.getValue()));
            }
            if (respTarget.containsKey(PushResponseCode.RSP_SPEED_LIMIT.getValue())) {
                log.error("\u63a8\u9001\u8d85\u8fc7\u914d\u7f6e\u7684\u901f\u7387");
                failToken.addAll((Collection)respTarget.get(PushResponseCode.RSP_SPEED_LIMIT.getValue()));
            }
            if (respTarget.containsKey(PushResponseCode.RSP_OVERFLOW.getValue())) {
                log.error("\u63a8\u9001\u6d88\u606f\u5931\u8d25\u670d\u52a1\u8fc7\u8f7d");
                failToken.addAll((Collection)respTarget.get(PushResponseCode.RSP_OVERFLOW.getValue()));
            }
            if (respTarget.containsKey(PushResponseCode.RSP_UNSUBSCRIBE_PUSHID.getValue())) {
                log.error("pushId\u672a\u8ba2\u9605(un subscribe pushId)");
                failToken.addAll((Collection)respTarget.get(PushResponseCode.RSP_UNSUBSCRIBE_PUSHID.getValue()));
            }
            if (respTarget.containsKey(PushResponseCode.RSP_INVALID_PUSHID.getValue())) {
                log.error("pushId\u975e\u6cd5(invalid pushId)");
                failToken.addAll((Collection)respTarget.get(PushResponseCode.RSP_INVALID_PUSHID.getValue()));
            }
            if (respTarget.containsKey(PushResponseCode.RSP_OFF_PUSHID.getValue())) {
                log.error("pushId\u5931\u6548(\u6d88\u606f\u5f00\u5173\u5173\u95ed)");
                failToken.addAll((Collection)respTarget.get(PushResponseCode.RSP_OFF_PUSHID.getValue()));
            }
            respResult.setFailedTokens(failToken);
        }
        return respResult;
    }

    private static void writeErrorLog(ResultPack<com.meizu.push.sdk.server.model.push.PushResult> result) {
        System.out.println(result.code() + ":" + result.comment());
        log.error(result.code() + ":" + result.comment());
    }
}

