/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.consumer;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.mobile.push.app.dto.ProducerConfiguration;
import com.jxdinfo.hussar.mobile.push.handler.DetectMethodAnnotation;
import com.jxdinfo.hussar.mobile.push.publish.enums.ProTypeEnum;
import com.jxdinfo.hussar.mobile.push.publish.model.PushRecordDetailDO;
import com.jxdinfo.hussar.mobile.push.publish.vo.PushResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class MessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(MessageConsumer.class);
    @Resource
    private DetectMethodAnnotation detectMethodAnnotation;
    @Resource
    private MongoTemplate mongoTemplate;

    @RabbitListener(queues={"message"})
    public void pushMessage(String context) {
        ProducerConfiguration producerConfiguration = (ProducerConfiguration)JSON.parseObject((String)context, ProducerConfiguration.class);
        ProTypeEnum[] proTypeEnums = ProTypeEnum.values();
        ArrayList list = new ArrayList();
        producerConfiguration.getTokenSet().forEach(i -> {
            PushRecordDetailDO pushRecordDetailDO = new PushRecordDetailDO();
            pushRecordDetailDO.setObjId(IdUtil.randomUUID());
            pushRecordDetailDO.setPushId(producerConfiguration.getPushId());
            pushRecordDetailDO.setAssistInfo(JSON.toJSONString((Object)producerConfiguration.getMessage()));
            pushRecordDetailDO.setPushId(producerConfiguration.getPushId());
            pushRecordDetailDO.setProToken(i);
            pushRecordDetailDO.setProType(Integer.valueOf(producerConfiguration.getProType()));
            pushRecordDetailDO.setToken(proTypeEnums[Integer.valueOf(producerConfiguration.getProType())].encodeToken(i));
            pushRecordDetailDO.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            pushRecordDetailDO.setModifyTime(Long.valueOf(System.currentTimeMillis()));
            pushRecordDetailDO.setDataStatus(Integer.valueOf(1));
            list.add(pushRecordDetailDO);
        });
        this.mongoTemplate.insert(list, PushRecordDetailDO.class);
        try {
            PushResult pushResult = this.detectMethodAnnotation.execute(proTypeEnums[Integer.valueOf(producerConfiguration.getProType())], producerConfiguration);
            if (HussarUtils.isNotEmpty((Object)pushResult.getFailedTokens())) {
                this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)Criteria.where((String)"proToken").in((Collection)pushResult.getFailedTokens()).and("pushId").is((Object)producerConfiguration.getPushId())), Update.update((String)"dataStatus", (Object)0), PushRecordDetailDO.class);
            }
            log.info(proTypeEnums[Integer.valueOf(producerConfiguration.getProType())].name() + " \u63a8\u9001\u5b8c\u6210");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(proTypeEnums[Integer.valueOf(producerConfiguration.getProType())].name() + "\u63a8\u9001\u9519\u8bef" + e.getMessage());
        }
    }
}

