/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.publish.manage;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.mobile.publish.config.MobilePublishConfigProperty;
import com.jxdinfo.hussar.mobile.publish.manage.AbstractAppInfos;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.dongliu.apk.parser.ApkFile;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.Icon;
import net.dongliu.apk.parser.bean.IconFace;
import org.apache.commons.codec.binary.Base64;

public class AndroidsAppInfos
extends AbstractAppInfos {
    private ApkMeta apkMeta;

    @Override
    protected String getAppName() {
        return this.getApkMeta().getName();
    }

    @Override
    protected String getVersionName() {
        return this.getApkMeta().getVersionName();
    }

    @Override
    protected String getVersionCode() {
        return this.getApkMeta().getVersionCode().toString();
    }

    @Override
    protected String getPackageName() {
        return this.getApkMeta().getPackageName();
    }

    @Override
    protected String getSDKVersion() {
        return this.getApkMeta().getCompileSdkVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getAppIMG() {
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            int[] densityArr;
            zipFile = new ZipFile(this.appFile);
            List pathList = this.getApkFile().getAllIcons();
            String path = "";
            for (int density : densityArr = new int[]{65534, 213, 480, 320, 640, 0, 240, 160, 120}) {
                List filterList = pathList.stream().filter(iconFace -> iconFace instanceof Icon).filter(icon -> ((Icon)icon).getDensity() == density).collect(Collectors.toList());
                if (filterList.size() <= 0) continue;
                path = ((IconFace)filterList.get(0)).getPath();
                break;
            }
            ZipEntry zipEntry = zipFile.getEntry(path);
            zipEntry.getComment();
            zipEntry.getCompressedSize();
            zipEntry.getCrc();
            zipEntry.isDirectory();
            zipEntry.getSize();
            zipEntry.getMethod();
            inputStream = zipFile.getInputStream(zipEntry);
            String outPath = ((MobilePublishConfigProperty)SpringContextHolder.getBean(MobilePublishConfigProperty.class)).getAppImgPath();
            try {
                File appImgPlaceHolder = new File(outPath);
                if (!appImgPlaceHolder.exists()) {
                    appImgPlaceHolder.createNewFile();
                }
                this.writeInStream(inputStream, outPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            inputStream = new FileInputStream(outPath);
            byte[] data = new byte[inputStream.available()];
            inputStream.read(data);
            inputStream.close();
            String string = Base64.encodeBase64String((byte[])data);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    private ApkMeta getApkMeta() {
        if (this.apkMeta != null) {
            return this.apkMeta;
        }
        try {
            this.apkMeta = this.getApkFile().getApkMeta();
            return this.apkMeta;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ApkMeta.newBuilder().build();
        }
    }

    private ApkFile getApkFile() {
        ApkFile apkFile = null;
        try {
            apkFile = new ApkFile(this.appFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return apkFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInStream(InputStream is, String outputPath) throws Exception {
        try (FilterOutputStream bos = null;){
            File file = new File(outputPath);
            bos = new BufferedOutputStream(new FileOutputStream(file), 1024);
            byte[] b = new byte[1024];
            BufferedInputStream bis = new BufferedInputStream(is, 1024);
            while (bis.read(b) != -1) {
                bos.write(b);
            }
            ((BufferedOutputStream)bos).flush();
            is.close();
            bis.close();
        }
    }
}

