/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.HussarDelflagEntity;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.mobile.publish.config.MobilePublishConfigProperty;
import com.jxdinfo.hussar.mobile.publish.dao.PublishAppMapper;
import com.jxdinfo.hussar.mobile.publish.dao.PublishAppVersionMapper;
import com.jxdinfo.hussar.mobile.publish.dao.PublishBindingMapper;
import com.jxdinfo.hussar.mobile.publish.dao.PublishDownloadRecordMapper;
import com.jxdinfo.hussar.mobile.publish.dao.PublishDownloadScreenshotsMapper;
import com.jxdinfo.hussar.mobile.publish.dao.PublishUserAppMapper;
import com.jxdinfo.hussar.mobile.publish.dto.BindingDto;
import com.jxdinfo.hussar.mobile.publish.dto.PublishAppDto;
import com.jxdinfo.hussar.mobile.publish.dto.PublishVersionDto;
import com.jxdinfo.hussar.mobile.publish.model.PublishApp;
import com.jxdinfo.hussar.mobile.publish.model.PublishBinding;
import com.jxdinfo.hussar.mobile.publish.model.PublishRecord;
import com.jxdinfo.hussar.mobile.publish.model.PublishScreenshots;
import com.jxdinfo.hussar.mobile.publish.model.PublishUserApp;
import com.jxdinfo.hussar.mobile.publish.model.PublishVersion;
import com.jxdinfo.hussar.mobile.publish.service.PublishAppRecordService;
import com.jxdinfo.hussar.mobile.publish.service.PublishAppService;
import com.jxdinfo.hussar.mobile.publish.service.PublishBindingService;
import com.jxdinfo.hussar.mobile.publish.service.PublishUserAppService;
import com.jxdinfo.hussar.mobile.publish.service.PublishVersionService;
import com.jxdinfo.hussar.mobile.publish.util.AppFileUtil;
import com.jxdinfo.hussar.mobile.publish.util.CommonUtills;
import com.jxdinfo.hussar.mobile.publish.util.DateUtils;
import com.jxdinfo.hussar.mobile.publish.util.StringUtils;
import com.jxdinfo.hussar.mobile.publish.vo.PublishAppStatisticVo;
import com.jxdinfo.hussar.mobile.publish.vo.PublishAppVo;
import com.jxdinfo.hussar.mobile.publish.vo.PublishVersionVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.platform.core.utils.date.DateUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="com.jxdinfo.hussar.mobile.publish.service.impl.publishAppServiceImpl")
public class PublishAppServiceImpl
extends HussarServiceImpl<PublishAppMapper, PublishApp>
implements PublishAppService {
    @Resource
    private PublishAppMapper publishAppMapper;
    @Resource
    private PublishBindingMapper publishBindingMapper;
    @Resource
    private PublishUserAppMapper publishUserAppMapper;
    @Resource
    private PublishAppVersionMapper publishAppVersionMapper;
    @Resource
    private PublishDownloadRecordMapper downloadRecordMapper;
    @Resource
    private PublishDownloadScreenshotsMapper downloadScreenshotsMapper;
    @Resource
    private PublishVersionService versionService;
    @Resource
    private PublishBindingService bindingService;
    @Autowired
    private MobilePublishConfigProperty mobilePublishConfigProperty;
    @Resource
    private PublishUserAppService userAppService;
    @Resource
    private PublishAppRecordService publishAppRecordService;
    @Resource
    private AttachmentManagerService attachmentManagerService;

    public ApiResponse<Page<PublishAppVo>> getAppVoList(String searchKey, String platForm, String shortLink, PageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        String rscSearchKey = "";
        Long creator = BaseSecurityUtil.getUser().getId();
        if (StringUtil.isNotEmpty((Object)searchKey)) {
            rscSearchKey = this.replaceSpeciaChar(searchKey);
        }
        Page<PublishAppVo> appVoPage = this.publishAppMapper.getAppVo(page, searchKey, rscSearchKey, platForm, shortLink, creator);
        try {
            if (appVoPage.getSize() > 0L) {
                Long groupId = 0L;
                for (PublishAppVo publishAppVo : appVoPage.getRecords()) {
                    List<String> appIds;
                    if (StringUtil.isNotEmpty((Object)publishAppVo.getSecretCode())) {
                        publishAppVo.setSecret(true);
                        publishAppVo.setSecretCode("");
                    }
                    if ((appIds = this.publishBindingMapper.getAppIds(groupId = this.publishBindingMapper.getGroupId(publishAppVo.getId()))) == null || appIds.size() <= 0) continue;
                    Page page1 = new Page();
                    page1.setCurrent(1L);
                    page1.setSize(10L);
                    publishAppVo.setBindList(this.publishAppMapper.getPreAppVo(page1, appIds).getRecords());
                }
            }
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u56fe\u6807\u5931\u8d25");
        }
        return ApiResponse.success(appVoPage);
    }

    public ApiResponse<Boolean> updateApp(PublishAppDto appDto) {
        if (StringUtil.isNotEmpty((Object)appDto.getShortLink())) {
            LambdaUpdateWrapper qw = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)qw.eq(PublishApp::getShortLink, (Object)appDto.getShortLink())).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).ne(PublishApp::getId, (Object)appDto.getId());
            if (appDto.getShortLink().length() > 5) {
                return ApiResponse.fail((String)"\u77ed\u94fe\u63a5\u4e0d\u80fd\u8d85\u8fc75\u4f4d");
            }
            if (this.list((Wrapper)qw).size() > 0) {
                return ApiResponse.fail((String)"\u5df2\u5b58\u5728\u8be5\u94fe\u63a5");
            }
        }
        if (this.updateById((BaseEntity)appDto)) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.fail((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteApp(Long appId) {
        try {
            PublishAppDto publishAppDto = new PublishAppDto();
            publishAppDto.setId(appId);
            this.removeById((BaseEntity)publishAppDto);
            PublishUserApp publishUserApp = new PublishUserApp();
            publishUserApp.setAppId(appId);
            this.publishUserAppMapper.deleteById(publishUserApp);
            PublishRecord record = new PublishRecord();
            record.setAppId(appId);
            this.downloadRecordMapper.deleteById(record);
            PublishVersion appVersion = new PublishVersion();
            appVersion.setId(appId);
            this.publishAppVersionMapper.deleteById(appVersion);
            PublishBinding binding = new PublishBinding();
            binding.setAppId(appId);
            this.publishBindingMapper.deleteById(binding);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u5e94\u7528\u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.success((Object)true);
    }

    public PublishAppVo getAppDetail(Long userId, String appId) {
        PublishAppVo publishAppVo = this.publishAppMapper.getAppVoDetail(appId);
        publishAppVo.setDownLoadNum(Integer.valueOf(this.publishAppRecordService.getNum(Arrays.asList(publishAppVo.getId()))));
        if (StringUtil.isEmpty((Object)userId)) {
            publishAppVo.setPermitType(Integer.valueOf(2));
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(PublishUserApp::getAppId, (Object)appId);
            queryWrapper.eq(PublishUserApp::getUserId, (Object)userId);
            PublishUserApp appUser = (PublishUserApp)this.publishUserAppMapper.selectOne((Wrapper)queryWrapper);
            if (appUser != null) {
                publishAppVo.setPermitType(appUser.getPermitType());
            } else {
                publishAppVo.setPermitType(Integer.valueOf(2));
            }
        }
        LambdaQueryWrapper screenshotsWrapper = new LambdaQueryWrapper();
        screenshotsWrapper.eq(PublishScreenshots::getAppId, (Object)appId);
        screenshotsWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"1");
        publishAppVo.setDownloadScreenshots(this.downloadScreenshotsMapper.selectList((Wrapper)screenshotsWrapper));
        return publishAppVo;
    }

    public ApiResponse<List<PublishAppVo>> getCombineAppVoList(Long appId) {
        HashMap map = new HashMap();
        PublishBinding binding = this.publishBindingMapper.getBinding(appId);
        if (StringUtil.isNotEmpty((Object)binding)) {
            ArrayList<Long> appIdList = new ArrayList<Long>();
            List<PublishBinding> bindings = this.publishBindingMapper.getApps(binding.getGroupId());
            for (PublishBinding bind : bindings) {
                appIdList.add(bind.getAppId());
            }
            List<PublishAppVo> appVoList = this.publishAppMapper.getPublishAppVo(appId, appIdList);
            return ApiResponse.success(appVoList);
        }
        return ApiResponse.success(new ArrayList());
    }

    public ApiResponse<List<PublishAppVo>> getUnCombineAppVoList(Long appId, String appName, String plat, Long reAppId) {
        ArrayList map = new ArrayList();
        PublishApp publishApp = (PublishApp)this.publishAppMapper.selectById(appId);
        if (publishApp == null) {
            return ApiResponse.success(map);
        }
        String platform = publishApp.getPlatform();
        appName = this.replaceSpeciaChar(appName);
        List<PublishAppVo> appVoList = this.publishAppMapper.getUnBoundApp(appId, platform, appName, plat, reAppId, BaseSecurityUtil.getUser().getUserId());
        return ApiResponse.success(appVoList);
    }

    public ApiResponse<Boolean> combineApp(BindingDto bindingDto) {
        Long appID = bindingDto.getAppId();
        Long oldGroupId = this.publishBindingMapper.getGroupId(appID);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PublishBinding::getGroupId, (Object)oldGroupId);
        this.bindingService.remove((Wrapper)queryWrapper);
        List bindingList = bindingDto.getBindingList();
        PublishApp app = (PublishApp)this.getById(appID);
        Long groupId = CommonUtills.generateAssignId();
        for (PublishAppDto appDto : bindingList) {
            PublishBinding binding = new PublishBinding();
            binding.setGroupId(groupId);
            binding.setAppId(appDto.getId());
            binding.setPlatform(appDto.getPlatform());
            this.publishBindingMapper.insert(binding);
        }
        PublishBinding binding = new PublishBinding();
        binding.setAppId(appID);
        binding.setGroupId(groupId);
        binding.setPlatform(app.getPlatform());
        this.publishBindingMapper.insert(binding);
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<PublishVersionVo> editAppVersion(PublishVersionDto appVersionDto) {
        PublishVersion version = new PublishVersion();
        BeanUtil.copyProperties((Object)appVersionDto, (Object)version);
        PublishVersionVo versionVo = new PublishVersionVo();
        if (appVersionDto.getDelFlag() != null && "1".equals(appVersionDto.getDelFlag()) && "1".equals(((PublishVersion)this.versionService.getById((Serializable)appVersionDto.getId())).getCurrentVersion())) {
            return ApiResponse.fail((String)"\u5f53\u524d\u7248\u672c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        if (appVersionDto.getDelFlag() != null && "1".equals(appVersionDto.getDelFlag()) && "0".equals(((PublishVersion)this.versionService.getById((Serializable)appVersionDto.getId())).getCurrentVersion())) {
            if (this.versionService.removeById((Object)version)) {
                BeanUtil.copyProperties((Object)version, (Object)versionVo);
                return ApiResponse.success((Object)versionVo);
            }
            return ApiResponse.fail((String)"\u5220\u9664app\u7248\u672c\u5931\u8d25");
        }
        if (StringUtil.isNotEmpty((Object)version.getCurrentVersion()) && "1".equals(version.getCurrentVersion().toString())) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(PublishVersion::getCurrentVersion, (Object)"0");
            wrapper.eq(PublishVersion::getAppId, (Object)appVersionDto.getAppId());
            this.versionService.update((Wrapper)wrapper);
        }
        if (this.versionService.updateById((Object)version)) {
            BeanUtil.copyProperties((Object)version, (Object)versionVo);
            return ApiResponse.success((Object)versionVo);
        }
        return ApiResponse.fail((String)"\u7f16\u8f91app\u7248\u672c\u5931\u8d25");
    }

    public ApiResponse<PublishAppStatisticVo> getAppStatistic(Long appId, int type, boolean isAll) {
        String aId = appId.toString();
        StringBuffer appID = new StringBuffer();
        appID.append(aId);
        if (isAll) {
            Long groupId;
            PublishApp publishApp = (PublishApp)this.getById(appId);
            if (this.publishBindingMapper.getBinding(appId) != null && (groupId = this.publishBindingMapper.getBinding(appId).getGroupId()) != null) {
                List<Long> allAppId = this.downloadRecordMapper.getAllAppId(appId);
                for (Long id : allAppId) {
                    appID.append(",");
                    appID.append(id);
                }
            }
        }
        String id = appID.toString();
        List<String> appIds = Arrays.asList(id.split(","));
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime endDate = LocalDateTime.parse(DateUtils.endOfDay(), df);
        ArrayList<Map<Object, Object>> list = new ArrayList<Map<Object, Object>>();
        Long avgNum = 0L;
        Map<Object, Object> map = new HashMap();
        if (type == 0) {
            map = this.queryWeek(id);
            avgNum = (Long)map.get("avgNum");
            list.add(map);
        } else if (type == 1) {
            map = this.queryMonth(id);
            avgNum = (Long)map.get("avgNum");
            list.add(map);
        } else if (type == 2) {
            map = this.queryYear(id);
            avgNum = (Long)map.get("avgNum");
            list.add(map);
        }
        PublishAppStatisticVo appStatisticVo = new PublishAppStatisticVo();
        if (list == null) {
            appStatisticVo.setAvgNum(Integer.valueOf(0));
            appStatisticVo.setTotalNUm(Integer.valueOf(0));
            appStatisticVo.setHighestNum(Integer.valueOf(0));
        } else {
            list.forEach(stringObjectMap -> {
                if (appStatisticVo.getTotalNUm() == null) {
                    appStatisticVo.setTotalNUm(Integer.valueOf(0));
                }
                appStatisticVo.setTotalNUm(Integer.valueOf(appStatisticVo.getTotalNUm() + (Integer)stringObjectMap.get("sum")));
                if (appStatisticVo.getHighestNum() == null || appStatisticVo.getHighestNum() < (Integer)stringObjectMap.get("max")) {
                    appStatisticVo.setHighestNum((Integer)stringObjectMap.get("max"));
                }
            });
        }
        if (avgNum == 0L) {
            appStatisticVo.setAvgNum(appStatisticVo.getTotalNUm());
        } else {
            appStatisticVo.setAvgNum(Integer.valueOf((int)((long)appStatisticVo.getTotalNUm().intValue() / avgNum)));
        }
        appStatisticVo.setNum(list);
        appStatisticVo.setType(Integer.valueOf(type));
        return ApiResponse.success((Object)appStatisticVo);
    }

    @HussarTransactional
    public ApiResponse<PublishAppVo> uploadApp(MultipartHttpServletRequest multipartRequest, HttpServletRequest request, Long appId) {
        PublishAppVo appInfo;
        AttachmentManagerModelVo attachmentManagerModelVo = null;
        try {
            ApiResponse apiResponse = this.attachmentManagerService.uploadFileWithDrag(multipartRequest, null);
            attachmentManagerModelVo = (AttachmentManagerModelVo)apiResponse.getData();
            File file = new File(attachmentManagerModelVo.getPath());
            appInfo = this.getAppInfo(file, attachmentManagerModelVo, request, appId, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)appInfo);
    }

    @HussarTransactional
    public ApiResponse<PublishAppVo> uploadAppByFileId(Long fileId, HttpServletRequest request, Long appId, Long userId, String uploadLog) {
        AttachmentManagerModelVo attachmentManagerModelVo = this.attachmentManagerService.getByFileId(fileId);
        if (attachmentManagerModelVo == null) {
            throw new HussarException("\u6587\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        assert (false);
        File file = new File(attachmentManagerModelVo.getPath());
        if (!file.exists()) {
            throw new HussarException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        return ApiResponse.success((Object)this.getAppInfo(file, attachmentManagerModelVo, request, appId, userId, uploadLog));
    }

    private String replaceSpeciaChar(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("\\", "\\\\");
        str = str.replace("%", "\\%");
        str = str.replace("_", "\\_");
        return str;
    }

    private String getBind(String preBindStr, Long otherAppID) {
        preBindStr = preBindStr.contains(",") ? (preBindStr.endsWith(otherAppID + "") ? preBindStr.replace("," + otherAppID, "") : preBindStr.replace(otherAppID + ",", "")) : preBindStr.replace(otherAppID + "", "");
        return preBindStr;
    }

    public Integer getDetail(String agentStr) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)agentStr);
        OperatingSystem operatingSystem = userAgent.getOperatingSystem();
        DeviceType deviceType = operatingSystem.getDeviceType();
        switch (deviceType) {
            case COMPUTER: {
                return 2;
            }
            case TABLET: {
                if (agentStr.contains("Android")) {
                    return 1;
                }
                if (agentStr.contains("iOS")) {
                    return 0;
                }
            }
            case MOBILE: {
                if (agentStr.contains("Android")) {
                    return 1;
                }
                if (!agentStr.contains("iOS") && !agentStr.contains("iPhone") && !agentStr.contains("iPad")) break;
                return 0;
            }
        }
        return 2;
    }

    public PublishAppVo getAppVoByVersionId(Long appVersionId) {
        PublishAppVo appVO = this.publishAppMapper.getAppVoByVersionId(appVersionId);
        appVO.setDownLoadNum(Integer.valueOf(this.publishAppRecordService.getNum(Arrays.asList(appVO.getId()))));
        return appVO;
    }

    public List<PublishAppVo> getPreAppVoList(String platForm, String shortLink) {
        List<PublishAppVo> publishAppInfoList;
        Long appIdByShotLink = this.publishAppMapper.getAppIdByShotLink(shortLink);
        List<Long> allBindingAppId = this.publishAppMapper.getAllBindingAppByAppId(appIdByShotLink);
        if (HussarUtils.isEmpty(allBindingAppId)) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(appIdByShotLink);
            publishAppInfoList = this.publishAppMapper.getPublishAppInfoByIds((List<Long>)list);
        } else {
            publishAppInfoList = this.publishAppMapper.getPublishAppInfoByIds(allBindingAppId);
        }
        for (PublishAppVo publishAppInfoById : publishAppInfoList) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(publishAppInfoById.getId());
            publishAppInfoById.setDownLoadNum(Integer.valueOf(this.publishAppRecordService.getNum(list)));
        }
        for (int i = 0; i < publishAppInfoList.size(); ++i) {
            if (!publishAppInfoList.get(i).getPlatform().equals(platForm)) continue;
            Collections.swap(publishAppInfoList, 0, i);
            break;
        }
        return publishAppInfoList;
    }

    public Page<PublishAppVo> getAppCollect(Long userId, String appName, PageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        appName = this.replaceSpeciaChar(appName);
        Page<PublishAppVo> apps = this.publishAppMapper.getAppCollect(page, userId, appName);
        return apps;
    }

    public ApiResponse<List<HashMap<String, Object>>> queryUserList(String userName) {
        userName = this.replaceSpeciaChar(userName);
        List<PublishAppVo> appList = this.publishAppMapper.getAppCreator(userName);
        ArrayList list = new ArrayList();
        appList.forEach(app -> {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("label", app.getUserName());
            resultMap.put("value", app.getCreator());
            list.add(resultMap);
        });
        return ApiResponse.success(list);
    }

    public ApiResponse<Boolean> checkPassword(Long appID, String password) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"APP_ID", (Object)appID)).eq((Object)"SECRET_CODE", (Object)password);
        if (this.count((Wrapper)queryWrapper) > 0L) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.fail((String)"\u5bc6\u7801\u9519\u8bef");
    }

    private PublishAppVo getAppInfo(File file, AttachmentManagerModelVo attachmentManagerModelVo, HttpServletRequest request, Long appId, Long userId, String uploadLog) {
        PublishAppVo appVO = AppFileUtil.getAppInfo(file);
        PublishVersion appVersion = new PublishVersion();
        if (userId == null) {
            userId = BaseSecurityUtil.getUser().getId();
        }
        if (HussarUtils.isNotEmpty((Object)appId)) {
            appVersion.setAppId(appId);
        } else {
            List userAppIdList = this.publishUserAppMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PublishUserApp::getUserId, (Object)userId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).stream().map(PublishUserApp::getAppId).collect(Collectors.toList());
            List publishApps = new ArrayList();
            if (HussarUtils.isNotEmpty(userAppIdList)) {
                publishApps = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PublishApp::getPackageName, (Object)appVO.getPackageName())).eq(PublishApp::getPlatform, (Object)appVO.getPlatform())).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).in(PublishApp::getId, userAppIdList));
            }
            if (HussarUtils.isEmpty(publishApps)) {
                PublishApp publishApp = new PublishApp();
                BeanUtils.copyProperties((Object)appVO, (Object)publishApp);
                publishApp.setUserId(userId);
                publishApp.setShortLink(StringUtils.randomLink(4));
                this.save((BaseEntity)publishApp);
                PublishUserApp userApp = new PublishUserApp();
                userApp.setAppId(publishApp.getId());
                userApp.setUserId(publishApp.getUserId());
                userApp.setPermitType(Integer.valueOf(0));
                this.userAppService.save((Object)userApp);
                appVersion.setAppId(publishApp.getId());
                appVO.setShortLink(publishApp.getShortLink());
            } else {
                appVersion.setAppId(((PublishApp)publishApps.get(0)).getId());
                appVO.setShortLink(((PublishApp)publishApps.get(0)).getShortLink());
            }
        }
        this.versionService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PublishVersion::getAppId, (Object)appVersion.getAppId())).set(PublishVersion::getCurrentVersion, (Object)0));
        appVersion.setUserId(userId);
        appVersion.setAppLogo(appVO.getAppImg());
        appVersion.setBuildCode(appVO.getVersionCode());
        appVersion.setBuildName(appVO.getVersionName());
        appVersion.setFileSize(Float.valueOf((float)Long.parseLong(attachmentManagerModelVo.getBytes()) / 1024.0f));
        appVersion.setFileId(attachmentManagerModelVo.getId());
        appVersion.setFileName(attachmentManagerModelVo.getFileName());
        appVersion.setAppName(appVO.getAppName());
        appVersion.setCurrentVersion(Integer.valueOf(1));
        appVersion.setIsShow(Integer.valueOf(1));
        appVersion.setMustUpdate(Integer.valueOf(0));
        appVersion.setUpdateLog(uploadLog);
        if ("0".equals(appVO.getPlatform())) {
            String localAddr = request.getLocalAddr();
            int serverPort = request.getServerPort();
            String scheme = request.getScheme();
            String plistFile = AppFileUtil.generatePlistFile(this.mobilePublishConfigProperty.getDownloadUrl() + "fileDownload", appVersion.getFileId(), appVersion, appVO.getPackageName());
            appVersion.setPlistFile(plistFile);
        }
        this.versionService.save((Object)appVersion);
        appVO.setId(appVersion.getAppId());
        ArrayList<PublishVersionVo> list = new ArrayList<PublishVersionVo>();
        PublishVersionVo appVersionVO = new PublishVersionVo();
        BeanUtils.copyProperties((Object)appVersion, (Object)appVersionVO);
        list.add(appVersionVO);
        appVO.setAppVersionList(list);
        return appVO;
    }

    private Map<String, Object> queryWeek(String id) {
        int beginDay;
        Long avgNum = 0L;
        List<String> appIds = Arrays.asList(id.split(","));
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime endDate = LocalDateTime.parse(DateUtils.endOfDay(), df);
        LocalDateTime beginDate = LocalDateTime.parse(DateUtils.beginOfCurrentWeek(), df);
        LambdaQueryWrapper recordLambdaQueryWrapper = new LambdaQueryWrapper();
        List<String> ids = Arrays.asList(id.split(","));
        HashMap<String, Integer> weekMap = new HashMap<String, Integer>();
        for (int i = 0; i < ids.size(); ++i) {
            Long appid = Long.valueOf(ids.get(i));
            ((LambdaQueryWrapper)((LambdaQueryWrapper)recordLambdaQueryWrapper.eq(PublishRecord::getAppId, (Object)appid)).gt(HussarBaseEntity::getCreateTime, (Object)beginDate)).lt(HussarBaseEntity::getCreateTime, (Object)endDate);
            recordLambdaQueryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
            List publishRecords = this.downloadRecordMapper.selectList((Wrapper)recordLambdaQueryWrapper);
            HashMap monthMap = new HashMap();
            for (PublishRecord publishRecord : publishRecords) {
                String date = publishRecord.getCreateTime().toString().substring(0, 10);
                if (weekMap.containsKey(date)) {
                    weekMap.put(date, (Integer)weekMap.get(date) + 1);
                    continue;
                }
                weekMap.put(date, new Integer(1));
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String currentMonth = DateUtil.beginOfWeek((Date)DateUtil.date()).toDateStr().substring(0, 7);
        ArrayList<Integer> number = new ArrayList<Integer>();
        ArrayList<String> day = new ArrayList<String>();
        int maxNum = 0;
        int sumNum = 0;
        for (int i = beginDay = Integer.parseInt(DateUtil.beginOfWeek((Date)DateUtil.date()).toDateStr().substring(8, 10)); i <= beginDay + 6; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(currentMonth);
            if (i <= 9) {
                sb.append("-0").append(i);
            } else {
                sb.append("-").append(i);
            }
            String str = sb.toString();
            day.add(i + "");
            int count = weekMap.get(str) == null ? 0 : (Integer)weekMap.get(str);
            maxNum = count > maxNum ? count : maxNum;
            sumNum += count;
            number.add(count);
        }
        avgNum = 7L;
        map.put("num", number);
        map.put("month", day);
        map.put("max", maxNum);
        map.put("sum", sumNum);
        map.put("avgNum", avgNum);
        return map;
    }

    private Map<String, Object> queryMonth(String id) {
        Long avgNum = 0L;
        List<String> appIds = Arrays.asList(id.split(","));
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime endDate = LocalDateTime.parse(DateUtils.endOfDay(), df);
        LocalDateTime beginDate = LocalDateTime.parse(DateUtils.beginOfCurrentWeek(), df);
        String endDateMonth = DateUtils.endOfCurrentMonth();
        int days = Integer.parseInt(endDateMonth.substring(8, 10));
        List<String> ids = Arrays.asList(id.split(","));
        HashMap<String, Integer> monthMap = new HashMap<String, Integer>();
        for (int i = 0; i < ids.size(); ++i) {
            Long appid = Long.valueOf(ids.get(i));
            LambdaQueryWrapper recordLambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)recordLambdaQueryWrapper.eq(PublishRecord::getAppId, (Object)appid)).gt(HussarBaseEntity::getCreateTime, (Object)beginDate)).lt(HussarBaseEntity::getCreateTime, (Object)endDate);
            List publishRecords = this.downloadRecordMapper.selectList((Wrapper)recordLambdaQueryWrapper);
            for (PublishRecord publishRecord : publishRecords) {
                String date = publishRecord.getCreateTime().toString().substring(0, 10);
                if (monthMap.containsKey(date)) {
                    monthMap.put(date, (Integer)monthMap.get(date) + 1);
                    continue;
                }
                monthMap.put(date, new Integer(1));
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String currentMonth = DateUtil.beginOfMonth((Date)DateUtil.date()).toDateStr().substring(0, 7);
        ArrayList<Integer> number = new ArrayList<Integer>();
        ArrayList<String> day = new ArrayList<String>();
        int maxNum = 0;
        int sumNum = 0;
        avgNum = Integer.parseInt(days + "");
        for (int i = 1; i <= days; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(currentMonth);
            if (i <= 9) {
                sb.append("-0").append(i);
            } else {
                sb.append("-").append(i);
            }
            String str = sb.toString();
            day.add(i + "");
            int count = monthMap.get(str) == null ? 0 : (Integer)monthMap.get(str);
            maxNum = count > maxNum ? count : maxNum;
            sumNum += count;
            number.add(count);
        }
        map.put("num", number);
        map.put("day", day);
        map.put("max", maxNum);
        map.put("sum", sumNum);
        map.put("avgNum", avgNum);
        return map;
    }

    private Map<String, Object> queryYear(String id) {
        List<String> appIds = Arrays.asList(id.split(","));
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime beginDate = LocalDateTime.parse(DateUtils.beginOfCurrentWeek(), df);
        LocalDateTime endDate = LocalDateTime.parse(DateUtils.endOfDay(), df);
        LambdaQueryWrapper recordLambdaQueryWrapper = new LambdaQueryWrapper();
        List<String> ids = Arrays.asList(id.split(","));
        ArrayList month = new ArrayList();
        HashMap<String, Integer> monthMap = new HashMap<String, Integer>();
        int maxNum = 0;
        int sumNum = 0;
        for (int i = 0; i < ids.size(); ++i) {
            Long appid = Long.valueOf(ids.get(i));
            ((LambdaQueryWrapper)((LambdaQueryWrapper)recordLambdaQueryWrapper.eq(PublishRecord::getAppId, (Object)appid)).gt(HussarBaseEntity::getCreateTime, (Object)beginDate)).lt(HussarBaseEntity::getCreateTime, (Object)endDate);
            List publishRecords = this.downloadRecordMapper.selectList((Wrapper)recordLambdaQueryWrapper);
            for (PublishRecord publishRecord : publishRecords) {
                String date = publishRecord.getCreateTime().toString().substring(0, 7);
                if (monthMap.containsKey(date)) {
                    monthMap.put(date, (Integer)monthMap.get(date) + 1);
                    continue;
                }
                monthMap.put(date, new Integer(1));
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String currentYear = DateUtil.beginOfYear((Date)DateUtil.date()).toDateStr().substring(0, 4);
        ArrayList<Integer> number = new ArrayList<Integer>();
        ArrayList<String> mon = new ArrayList<String>();
        Long avgNum = 12L;
        for (int i = 1; i <= 12; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(currentYear);
            if (i <= 9) {
                sb.append("-0").append(i);
            } else {
                sb.append("-").append(i);
            }
            String str = sb.toString();
            mon.add(i + "");
            int count = monthMap.get(str) == null ? 0 : (Integer)monthMap.get(str);
            maxNum = count > maxNum ? count : maxNum;
            sumNum += count;
            number.add(count);
        }
        map.put("num", number);
        map.put("month", mon);
        map.put("max", maxNum);
        map.put("sum", sumNum);
        map.put("avgNum", avgNum);
        return map;
    }
}

