/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.application.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.base.mobile.application.dao.SysMobileApplicationMapper;
import com.jxdinfo.hussar.base.mobile.application.dto.SysMobileApplicationDto;
import com.jxdinfo.hussar.base.mobile.application.model.SysMobileApplication;
import com.jxdinfo.hussar.base.mobile.application.service.ISysMobileApplicationService;
import com.jxdinfo.hussar.base.mobile.permission.model.SysMobileApplicationPermission;
import com.jxdinfo.hussar.base.mobile.permission.service.ISysMobileApplicationPermissionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysMobileApplicationServiceImpl
extends HussarServiceImpl<SysMobileApplicationMapper, SysMobileApplication>
implements ISysMobileApplicationService {
    @Resource
    private ISysMobileApplicationPermissionService permissionService;

    @HussarTransactional
    public ApiResponse<Boolean> addApp(SysMobileApplicationDto sysMobileApplicationDto) {
        this.save((BaseEntity)sysMobileApplicationDto);
        if (HussarUtils.isNotEmpty((Object)sysMobileApplicationDto.getPermissionList())) {
            ArrayList permissionList = new ArrayList(sysMobileApplicationDto.getPermissionList());
            for (SysMobileApplicationPermission sysMobileApplicationPermission : permissionList) {
                sysMobileApplicationPermission.setAppId(sysMobileApplicationDto.getId());
            }
            this.permissionService.saveBatch(permissionList, permissionList.size());
        }
        return ApiResponse.success();
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteApp(Long appId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMobileApplicationPermission::getAppId, (Object)appId);
        this.permissionService.remove((Wrapper)queryWrapper);
        this.removeById(appId);
        return ApiResponse.success();
    }

    public ApiResponse<Boolean> deleteApp(String appId) {
        return this.deleteApp(Long.parseLong(appId));
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateApp(SysMobileApplicationDto sysMobileApplicationDto) {
        List permissionList;
        this.updateById((BaseEntity)sysMobileApplicationDto);
        List oldList = sysMobileApplicationDto.getOldPermissionList();
        if (HussarUtils.isNotEmpty((Object)oldList)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysMobileApplicationPermission::getAppId, (Object)sysMobileApplicationDto.getId());
            this.permissionService.remove((Wrapper)queryWrapper);
        }
        if (HussarUtils.isEmpty((Object)(permissionList = sysMobileApplicationDto.getPermissionList()))) {
            return ApiResponse.success();
        }
        for (SysMobileApplicationPermission sysMobileApplicationPermission : permissionList) {
            sysMobileApplicationPermission.setAppId(sysMobileApplicationDto.getId());
        }
        this.permissionService.saveBatch((Collection)permissionList, permissionList.size());
        return ApiResponse.success();
    }
}

