/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.external.weChatWork;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.base.mobile.config.MobileConfigProperty;
import com.jxdinfo.hussar.base.mobile.external.integration.dto.QueryConfigDto;
import com.jxdinfo.hussar.base.mobile.external.integration.enums.SsoConstantsEnum;
import com.jxdinfo.hussar.base.mobile.external.integration.model.MobileExternalConfig;
import com.jxdinfo.hussar.base.mobile.external.integration.service.IMobileExternalConfigService;
import com.jxdinfo.hussar.base.mobile.util.HttpUtil;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeChatWorkLoginValidateServiceImpl
implements HussarLoginValidateService {
    private static final String CACHE_NAME = "mobile:weChatWork";
    @Resource
    private IMobileExternalConfigService mobileExternalConfigService;
    @Autowired
    private MobileConfigProperty mobileConfigProperty;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Autowired(required=false)
    private Encrypt defEncrypt;

    public String getLoginType() {
        return "weChatWork";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        QueryConfigDto configDto;
        MobileExternalConfig config;
        String accessToken = (String)HussarCacheUtil.get((String)CACHE_NAME, (Object)CACHE_NAME);
        String appType = request.getHeader("appType");
        if (HussarUtils.isBlank((CharSequence)appType)) {
            String parameter = request.getParameter("appType");
            String string = appType = HussarUtils.isBlank((CharSequence)parameter) ? "1" : parameter;
        }
        if (HussarUtils.isEmpty((Object)(config = this.mobileExternalConfigService.getConfigByPlatformAndType(configDto = new QueryConfigDto("weChatWork", appType))))) {
            throw new ExtendLoginException(TranslateUtil.getTranslateName((String)SsoConstantsEnum.WECOM_SSO_CONFIG_NOT_FOUND.getMessage()));
        }
        if (HussarUtils.isEmpty((Object)accessToken)) {
            accessToken = this.getWeChatWorkToken(config);
        }
        String userId = this.getWeChatWorkUserId(accessToken, loginCode);
        JSONObject result = this.getWeChatWorkUserInfo(accessToken, userId);
        Object userValue = WeChatWorkLoginValidateServiceImpl.getWeCharWorkMachValue(config, result);
        return this.getHussarUserAccount(config, userValue);
    }

    private String getHussarUserAccount(MobileExternalConfig config, Object userValue) {
        String hussarMatch = config.getAppHussarMatch();
        if (HussarUtils.isEmpty((Object)hussarMatch)) {
            hussarMatch = "USER_ACCOUNT";
        }
        switch (hussarMatch) {
            case "USER_ACCOUNT": {
                return String.valueOf(userValue);
            }
            case "E_MAIL": 
            case "MOBILE": {
                return this.getUserAccountByField(userValue, hussarMatch);
            }
        }
        throw new ExtendLoginException(TranslateUtil.getTranslateName((String)SsoConstantsEnum.UNSUPPORTED_MATCHING_FIELD.getMessage()) + hussarMatch);
    }

    private String getUserAccountByField(Object userValue, String hussarMatch) {
        List users;
        String value = String.valueOf(userValue);
        if (HussarUtils.equals((Object)"MOBILE", (Object)hussarMatch) && HussarUtils.isNotEmpty((Object)this.defEncrypt)) {
            value = this.defEncrypt.encrypt(value);
        }
        if (HussarUtils.isEmpty((Object)(users = this.hussarBaseUserBoService.getUsersByField(hussarMatch, value)))) {
            throw new ExtendLoginException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        }
        if (users.size() > 1) {
            throw new ExtendLoginException(TranslateUtil.getTranslateName((String)SsoConstantsEnum.DUPLICATE_DATA_FOUND.getMessage()));
        }
        return ((SysUsers)users.get(0)).getUserAccount();
    }

    private static Object getWeCharWorkMachValue(MobileExternalConfig config, JSONObject result) {
        Object userValue;
        String appSsoMatch = config.getAppSsoMatch();
        if (HussarUtils.isEmpty((Object)appSsoMatch)) {
            appSsoMatch = "name";
        }
        if (HussarUtils.isEmpty((Object)(userValue = result.get((Object)appSsoMatch)))) {
            throw new ExtendLoginException(TranslateUtil.getTranslateName((String)SsoConstantsEnum.FIELD_VALUE_EMPTY.getMessage()));
        }
        return userValue;
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    private String getWeChatWorkToken(MobileExternalConfig config) {
        HttpUtil httpUtil = new HttpUtil();
        ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
        paramList.add(new BasicNameValuePair("corpid", config.getAppKey()));
        paramList.add(new BasicNameValuePair("corpsecret", config.getAppSecret()));
        JSONObject jsonObject = httpUtil.sendHttpGet(this.mobileConfigProperty.getWeChatWorkTokenUrl(), paramList);
        if (!"0".equals(jsonObject.get((Object)"errcode").toString())) {
            throw new ExtendLoginException(jsonObject.get((Object)"errmsg").toString());
        }
        String accessToken = jsonObject.get((Object)"access_token").toString();
        HussarCacheUtil.put((String)CACHE_NAME, (Object)CACHE_NAME, (Object)accessToken, (long)7000L);
        return accessToken;
    }

    private String getWeChatWorkUserId(String accessToken, String code) {
        HttpUtil httpUtil = new HttpUtil();
        ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
        paramList.add(new BasicNameValuePair("access_token", accessToken));
        paramList.add(new BasicNameValuePair("code", code));
        JSONObject jsonObject = httpUtil.sendHttpGet(this.mobileConfigProperty.getWeChatWorkUserIdUrl(), paramList);
        if (!"0".equals(jsonObject.get((Object)"errcode").toString())) {
            throw new ExtendLoginException(jsonObject.get((Object)"errmsg").toString());
        }
        return jsonObject.get((Object)"userid").toString();
    }

    private JSONObject getWeChatWorkUserInfo(String accessToken, String userId) {
        HttpUtil httpUtil = new HttpUtil();
        ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
        paramList.add(new BasicNameValuePair("access_token", accessToken));
        paramList.add(new BasicNameValuePair("userid", userId));
        JSONObject jsonObject = httpUtil.sendHttpGet(this.mobileConfigProperty.getWeChatWorkUserInfoUrl(), paramList);
        if (!"0".equals(jsonObject.get((Object)"errcode").toString())) {
            throw new ExtendLoginException(jsonObject.get((Object)"errmsg").toString());
        }
        return jsonObject;
    }
}

