/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.external.dingtalk.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiUserGetuserinfoRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiUserGetuserinfoResponse;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.base.mobile.config.MobileConfigProperty;
import com.jxdinfo.hussar.base.mobile.external.integration.dto.QueryConfigDto;
import com.jxdinfo.hussar.base.mobile.external.integration.enums.SsoConstantsEnum;
import com.jxdinfo.hussar.base.mobile.external.integration.model.MobileExternalConfig;
import com.jxdinfo.hussar.base.mobile.external.integration.service.MobileExternalConfigServiceImpl;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DingTalkLoginValidateServiceImpl
implements HussarLoginValidateService {
    @Resource
    private MobileExternalConfigServiceImpl mobileExternalConfigService;
    @Autowired
    private MobileConfigProperty mobileConfigProperty;
    @Autowired(required=false)
    private Encrypt defEncrypt;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    private static final String CACHE_NAME = "mobile:dingTalk";

    public String getLoginType() {
        return "dingTalk";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        QueryConfigDto configDto;
        MobileExternalConfig config;
        String accessToken = (String)HussarCacheUtil.get((String)CACHE_NAME, (Object)CACHE_NAME);
        String appType = request.getHeader("appType");
        if (HussarUtils.isBlank((CharSequence)appType)) {
            String parameter = request.getParameter("appType");
            String string = appType = HussarUtils.isBlank((CharSequence)parameter) ? "1" : parameter;
        }
        if (HussarUtils.isEmpty((Object)(config = this.mobileExternalConfigService.getConfigByPlatformAndType(configDto = new QueryConfigDto("dingTalk", appType))))) {
            throw new ExtendLoginException(TranslateUtil.getTranslateName((String)SsoConstantsEnum.DINGTALK_SSO_CONFIG_NOT_FOUND.getMessage()));
        }
        if (HussarUtils.isEmpty((Object)accessToken)) {
            accessToken = this.getAccessTokenByConfig(config);
        }
        JSONObject result = this.getUserInfoByDingTalkToken(accessToken, loginCode);
        Object userValue = DingTalkLoginValidateServiceImpl.getDingTalkWorkMachValue(config, result);
        return this.getHussarUserAccount(config, userValue);
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    private String getAccessTokenByConfig(MobileExternalConfig config) {
        try {
            DefaultDingTalkClient getTokenClient = new DefaultDingTalkClient(this.mobileConfigProperty.getDingTalkTokenUrl());
            OapiGettokenRequest tokenRequest = new OapiGettokenRequest();
            tokenRequest.setAppkey(config.getAppKey());
            tokenRequest.setAppsecret(config.getAppSecret());
            tokenRequest.setHttpMethod("GET");
            OapiGettokenResponse tokenResponse = (OapiGettokenResponse)getTokenClient.execute((TaobaoRequest)tokenRequest);
            if (HussarUtils.isEmpty((Object)tokenResponse) || tokenResponse.getErrcode() != 0L) {
                throw new ExtendLoginException("\u9489\u9489token\u83b7\u53d6\u5931\u8d25");
            }
            HussarCacheUtil.put((String)CACHE_NAME, (Object)CACHE_NAME, (Object)tokenResponse.getAccessToken(), (long)7000L);
            return tokenResponse.getAccessToken();
        }
        catch (ApiException e) {
            throw new ExtendLoginException(e.getMessage());
        }
    }

    private JSONObject getUserInfoByDingTalkToken(String accessToken, String loginCode) {
        OapiUserGetuserinfoResponse getInfoResponse;
        try {
            DefaultDingTalkClient getInfoClient = new DefaultDingTalkClient(this.mobileConfigProperty.getDingTalkUserIdUrl());
            OapiUserGetuserinfoRequest getInfoRequest = new OapiUserGetuserinfoRequest();
            getInfoRequest.setCode(loginCode);
            getInfoRequest.setHttpMethod("GET");
            getInfoResponse = (OapiUserGetuserinfoResponse)getInfoClient.execute((TaobaoRequest)getInfoRequest, accessToken);
        }
        catch (ApiException e) {
            throw new ExtendLoginException(e.getMessage());
        }
        if (HussarUtils.isEmpty((Object)getInfoResponse)) {
            throw new ExtendLoginException("\u9489\u9489\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        return JSON.parseObject((String)getInfoResponse.getBody());
    }

    private static Object getDingTalkWorkMachValue(MobileExternalConfig config, JSONObject result) {
        Object userValue;
        String appSsoMatch = config.getAppSsoMatch();
        if (HussarUtils.isEmpty((Object)appSsoMatch)) {
            appSsoMatch = "name";
        }
        if (HussarUtils.isEmpty((Object)(userValue = result.get((Object)appSsoMatch)))) {
            throw new ExtendLoginException(TranslateUtil.getTranslateName((String)SsoConstantsEnum.FIELD_VALUE_EMPTY.getMessage()));
        }
        return userValue;
    }

    private String getHussarUserAccount(MobileExternalConfig config, Object userValue) {
        String hussarMatch = config.getAppHussarMatch();
        if (HussarUtils.isEmpty((Object)hussarMatch)) {
            hussarMatch = "USER_ACCOUNT";
        }
        switch (hussarMatch) {
            case "USER_ACCOUNT": {
                return String.valueOf(userValue);
            }
            case "USER_ID": {
                return this.getUserAccountByField(userValue, hussarMatch);
            }
        }
        throw new ExtendLoginException(TranslateUtil.getTranslateName((String)SsoConstantsEnum.UNSUPPORTED_MATCHING_FIELD.getMessage()) + hussarMatch);
    }

    private String getUserAccountByField(Object userValue, String hussarMatch) {
        String value = String.valueOf(userValue);
        List users = this.hussarBaseUserBoService.getUsersByField(hussarMatch, value);
        if (HussarUtils.isEmpty((Object)users)) {
            throw new ExtendLoginException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        }
        if (users.size() > 1) {
            throw new ExtendLoginException(TranslateUtil.getTranslateName((String)SsoConstantsEnum.DUPLICATE_DATA_FOUND.getMessage()));
        }
        return ((SysUsers)users.get(0)).getUserAccount();
    }
}

