/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.external.weChatWork;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.base.mobile.config.MobileConfigProperty;
import com.jxdinfo.hussar.base.mobile.external.integration.model.MobileExternalConfig;
import com.jxdinfo.hussar.base.mobile.external.integration.service.IMobileExternalConfigService;
import com.jxdinfo.hussar.base.mobile.util.HttpUtil;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeChatWorkLoginValidateServiceImpl
implements HussarLoginValidateService {
    private static final String CACHE_NAME = "mobile:weChatWork";
    @Resource
    private IMobileExternalConfigService mobileExternalConfigService;
    @Autowired
    private MobileConfigProperty mobileConfigProperty;

    public String getLoginType() {
        return "weChatWork";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        String accessToken = (String)HussarCacheUtil.get((String)CACHE_NAME, (Object)CACHE_NAME);
        if (HussarUtils.isEmpty((Object)accessToken)) {
            accessToken = this.getWeChatWorkToken();
        }
        String userId = this.getWeChatWorkUserId(accessToken, loginCode);
        return this.getWeChatWorkUserInfo(accessToken, userId);
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    private String getWeChatWorkToken() {
        HttpUtil httpUtil = new HttpUtil();
        MobileExternalConfig config = this.mobileExternalConfigService.getConfigByPlatform("weChatWork");
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        paramList.add((NameValuePair)new BasicNameValuePair("corpid", config.getAppKey()));
        paramList.add((NameValuePair)new BasicNameValuePair("corpsecret", config.getAppSecret()));
        JSONObject jsonObject = httpUtil.sendHttpGet(this.mobileConfigProperty.getWeChatWorkTokenUrl(), paramList);
        if (!"0".equals(jsonObject.get((Object)"errcode").toString())) {
            throw new ExtendLoginException(jsonObject.get((Object)"errmsg").toString());
        }
        String accessToken = jsonObject.get((Object)"access_token").toString();
        HussarCacheUtil.put((String)CACHE_NAME, (Object)CACHE_NAME, (Object)accessToken, (long)7000L);
        return accessToken;
    }

    private String getWeChatWorkUserId(String accessToken, String code) {
        HttpUtil httpUtil = new HttpUtil();
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        paramList.add((NameValuePair)new BasicNameValuePair("access_token", accessToken));
        paramList.add((NameValuePair)new BasicNameValuePair("code", code));
        JSONObject jsonObject = httpUtil.sendHttpGet(this.mobileConfigProperty.getWeChatWorkUserIdUrl(), paramList);
        if (!"0".equals(jsonObject.get((Object)"errcode").toString())) {
            throw new ExtendLoginException(jsonObject.get((Object)"errmsg").toString());
        }
        return jsonObject.get((Object)"userid").toString();
    }

    private String getWeChatWorkUserInfo(String accessToken, String userId) {
        HttpUtil httpUtil = new HttpUtil();
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        paramList.add((NameValuePair)new BasicNameValuePair("access_token", accessToken));
        paramList.add((NameValuePair)new BasicNameValuePair("userid", userId));
        JSONObject jsonObject = httpUtil.sendHttpGet(this.mobileConfigProperty.getWeChatWorkUserInfoUrl(), paramList);
        if (!"0".equals(jsonObject.get((Object)"errcode").toString())) {
            throw new ExtendLoginException(jsonObject.get((Object)"errmsg").toString());
        }
        return jsonObject.get((Object)"userid").toString();
    }
}

