/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.external.qingtui.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.base.mobile.external.integration.model.MobileExternalConfig;
import com.jxdinfo.hussar.base.mobile.external.integration.service.IMobileExternalConfigService;
import com.jxdinfo.hussar.base.mobile.external.qingtui.config.QingTuiConfig;
import com.jxdinfo.hussar.base.mobile.external.qingtui.service.QingTuiService;
import com.jxdinfo.hussar.base.mobile.external.qingtui.utils.Sha1Utils;
import com.jxdinfo.hussar.base.mobile.external.qingtui.vo.SignatureVo;
import com.jxdinfo.hussar.base.mobile.util.HttpUtil;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.id.UUID;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.stereotype.Service;

@Service
public class QingTuiServiceImpl
implements QingTuiService {
    private static final String TOKEN_CACHE_NAME = "mobile:qingtui";
    private static final String TICKET_CACHE_NAME = "qingtui:ticket";
    @Resource
    private IMobileExternalConfigService mobileExternalConfigService;
    @Resource
    private QingTuiConfig qingTuiConfig;

    public SignatureVo getQingTuiSignature(String originUrl) {
        SignatureVo signatureVo = new SignatureVo();
        MobileExternalConfig config = this.mobileExternalConfigService.getConfigByPlatform("qingtui");
        long timestamp = System.currentTimeMillis();
        String nonceStr = UUID.randomUUID().toString();
        String url = originUrl.split("#")[0];
        String jsapi_ticket = this.getTicket();
        String temp = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + url;
        String signature = Sha1Utils.getSha1(temp);
        signatureVo.setSignature(signature);
        signatureVo.setAppId(config.getAppKey());
        signatureVo.setNonceStr(nonceStr);
        signatureVo.setTimestamp(Long.valueOf(timestamp));
        return signatureVo;
    }

    public String getAccessToken(String appId, String secret) {
        MobileExternalConfig config = this.mobileExternalConfigService.getConfigByPlatform("qingtui");
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = config.getAppKey();
            secret = config.getAppSecret();
        }
        HttpUtil httpUtil = new HttpUtil();
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        paramList.add((NameValuePair)new BasicNameValuePair("appid", appId));
        String tokenUrl = this.qingTuiConfig.getNewTokenURL();
        JSONObject jsonObject = httpUtil.sendHttpGet(tokenUrl, paramList);
        String accessToken = jsonObject.getString("access_token");
        if (HussarUtils.isNotEmpty((Object)accessToken)) {
            return accessToken;
        }
        throw new BaseException("\u83b7\u53d6access_token\u5931\u8d25 " + jsonObject.toJSONString());
    }

    public String getBaseUrl() {
        return this.qingTuiConfig.getBaseURL();
    }

    private String getTicket() {
        String ticket = (String)HussarCacheUtil.get((String)TICKET_CACHE_NAME, (Object)TICKET_CACHE_NAME);
        if (HussarUtils.isNotEmpty((Object)ticket)) {
            return ticket;
        }
        String accessToken = this.getAccessToken(null, null);
        String ticketURL = this.qingTuiConfig.getTicketURL();
        HttpUtil httpUtil = new HttpUtil();
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        paramList.add((NameValuePair)new BasicNameValuePair("access_token", accessToken));
        JSONObject jsonObject = httpUtil.sendHttpGet(ticketURL, paramList);
        if (HussarUtils.isNotEmpty((Object)jsonObject.getString("ticket"))) {
            ticket = jsonObject.getString("ticket");
            HussarCacheUtil.put((String)TICKET_CACHE_NAME, (Object)TICKET_CACHE_NAME, (Object)ticket, (long)7000L);
            return ticket;
        }
        throw new BaseException("ticket\u83b7\u53d6\u5931\u8d25 " + jsonObject.getString("errmsg"));
    }
}

