/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.external.dingtalk.service;

import com.alibaba.fastjson.JSON;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiUserGetuserinfoRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiUserGetuserinfoResponse;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.base.mobile.config.MobileConfigProperty;
import com.jxdinfo.hussar.base.mobile.external.integration.model.MobileExternalConfig;
import com.jxdinfo.hussar.base.mobile.external.integration.service.IMobileExternalConfigService;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DingTalkLoginValidateServiceImpl
implements HussarLoginValidateService {
    @Resource
    private IMobileExternalConfigService mobileExternalConfigService;
    @Autowired
    private MobileConfigProperty mobileConfigProperty;
    private static final String CACHE_NAME = "mobile:dingTalk";

    public String getLoginType() {
        return "dingTalk";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        String accessToken = (String)HussarCacheUtil.get((String)CACHE_NAME, (Object)CACHE_NAME);
        if (HussarUtils.isEmpty((Object)accessToken)) {
            accessToken = this.getAccessTokenByConfig();
        }
        return this.getUserNameByDingTalkToken(accessToken, loginCode);
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    private String getAccessTokenByConfig() {
        try {
            MobileExternalConfig config = this.mobileExternalConfigService.getConfigByPlatform("dingTalk");
            if (HussarUtils.isEmpty((Object)config)) {
                throw new ExtendLoginException("\u65e0\u6548\u7684AppSecret\u4e0eAppKey");
            }
            DefaultDingTalkClient getTokenClient = new DefaultDingTalkClient(this.mobileConfigProperty.getDingTalkTokenUrl());
            OapiGettokenRequest tokenRequest = new OapiGettokenRequest();
            tokenRequest.setAppkey(config.getAppKey());
            tokenRequest.setAppsecret(config.getAppSecret());
            tokenRequest.setHttpMethod("GET");
            OapiGettokenResponse tokenResponse = (OapiGettokenResponse)getTokenClient.execute((TaobaoRequest)tokenRequest);
            if (HussarUtils.isEmpty((Object)tokenResponse) || tokenResponse.getErrcode() != 0L) {
                throw new ExtendLoginException("\u9489\u9489token\u83b7\u53d6\u5931\u8d25");
            }
            HussarCacheUtil.put((String)CACHE_NAME, (Object)CACHE_NAME, (Object)tokenResponse.getAccessToken(), (long)7000L);
            return tokenResponse.getAccessToken();
        }
        catch (ApiException e) {
            throw new ExtendLoginException(e.getMessage());
        }
    }

    private String getUserNameByDingTalkToken(String accessToken, String loginCode) {
        OapiUserGetuserinfoResponse getInfoResponse;
        try {
            DefaultDingTalkClient getInfoClient = new DefaultDingTalkClient(this.mobileConfigProperty.getDingTalkUserIdUrl());
            OapiUserGetuserinfoRequest getInfoRequest = new OapiUserGetuserinfoRequest();
            getInfoRequest.setCode(loginCode);
            getInfoRequest.setHttpMethod("GET");
            getInfoResponse = (OapiUserGetuserinfoResponse)getInfoClient.execute((TaobaoRequest)getInfoRequest, accessToken);
        }
        catch (ApiException e) {
            throw new ExtendLoginException(e.getMessage());
        }
        if (HussarUtils.isEmpty((Object)getInfoResponse)) {
            throw new ExtendLoginException("\u9489\u9489\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        return JSON.parseObject((String)getInfoResponse.getBody()).getString("name");
    }
}

