/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.permission.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.mobile.permission.dao.SysMobileApplicationPermissionMapper;
import com.jxdinfo.hussar.base.mobile.permission.dto.SysMobileApplicationPermissionDto;
import com.jxdinfo.hussar.base.mobile.permission.model.SysMobileApplicationPermission;
import com.jxdinfo.hussar.base.mobile.permission.service.ISysMobileApplicationPermissionService;
import com.jxdinfo.hussar.base.mobile.permission.vo.SysApplicationUser;
import com.jxdinfo.hussar.base.mobile.permission.vo.SysMobileApplicationPermissionVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysMobileApplicationPermissionServiceImpl
extends HussarServiceImpl<SysMobileApplicationPermissionMapper, SysMobileApplicationPermission>
implements ISysMobileApplicationPermissionService {
    @Resource
    SysMobileApplicationPermissionMapper sysMobileApplicationPermissionMapper;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    ISysOrganService sysOrganService;
    @Resource
    ISysRolesService sysRolesService;

    public ApiResponse<Page<List<SysApplicationUser>>> queryUserList(Page<SysApplicationUser> page, SysMobileApplicationPermissionDto sysMobileApplicationPermissionDto) {
        return ApiResponse.success(this.sysMobileApplicationPermissionMapper.queryUserList(page, sysMobileApplicationPermissionDto));
    }

    public ApiResponse<List<SysMobileApplicationPermissionVo>> getPermissionByAppId(Long appId) {
        SysMobileApplicationPermissionVo permissionVo;
        ArrayList<Long> userIdList = new ArrayList<Long>();
        ArrayList<Long> organIdList = new ArrayList<Long>();
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMobileApplicationPermission::getAppId, (Object)appId);
        List permissionList = this.list((Wrapper)queryWrapper);
        for (SysMobileApplicationPermission sysMobileApplicationPermission : permissionList) {
            if ("0".equals(sysMobileApplicationPermission.getType())) {
                userIdList.add(sysMobileApplicationPermission.getRelationId());
            }
            if ("1".equals(sysMobileApplicationPermission.getType())) {
                organIdList.add(sysMobileApplicationPermission.getRelationId());
            }
            if (!"2".equals(sysMobileApplicationPermission.getType())) continue;
            roleIdList.add(sysMobileApplicationPermission.getRelationId());
        }
        List sysUsers = new ArrayList();
        List sysOrgans = new ArrayList();
        List sysRoles = new ArrayList();
        if (HussarUtils.isNotEmpty(userIdList)) {
            sysUsers = this.sysUsersService.listByIds(userIdList);
        }
        if (HussarUtils.isNotEmpty(organIdList)) {
            sysOrgans = this.sysOrganService.listByIds(organIdList);
        }
        if (HussarUtils.isNotEmpty(roleIdList)) {
            sysRoles = this.sysRolesService.listByIds(roleIdList);
        }
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString((Object)permissionList), SysMobileApplicationPermissionVo.class).stream().collect(Collectors.toMap(SysMobileApplicationPermission::getRelationId, Function.identity()));
        for (SysUsers user : sysUsers) {
            permissionVo = (SysMobileApplicationPermissionVo)resultCollect.get(user.getId());
            if (!HussarUtils.isNotEmpty((Object)permissionVo)) continue;
            permissionVo.setBidName(user.getUserName());
            permissionVo.setDepartmentId(user.getDepartmentId());
        }
        for (SysOrgan sysOrgan : sysOrgans) {
            permissionVo = (SysMobileApplicationPermissionVo)resultCollect.get(sysOrgan.getId());
            if (!HussarUtils.isNotEmpty((Object)permissionVo)) continue;
            permissionVo.setBidName(sysOrgan.getOrganName());
        }
        for (SysRoles roles : sysRoles) {
            permissionVo = (SysMobileApplicationPermissionVo)resultCollect.get(roles.getId());
            if (!HussarUtils.isNotEmpty((Object)permissionVo)) continue;
            permissionVo.setBidName(roles.getRoleName());
            permissionVo.setGroupId(roles.getGroupId());
        }
        return ApiResponse.success(new ArrayList(resultCollect.values()));
    }

    public ApiResponse<List<SysMobileApplicationPermissionVo>> getPermissionByAppId(String appId) {
        return this.getPermissionByAppId(Long.parseLong(appId));
    }
}

