/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.group.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.base.mobile.application.model.SysMobileApplication;
import com.jxdinfo.hussar.base.mobile.application.service.ISysMobileApplicationService;
import com.jxdinfo.hussar.base.mobile.group.dao.SysMobileApplicationGroupMapper;
import com.jxdinfo.hussar.base.mobile.group.model.SysMobileApplicationGroup;
import com.jxdinfo.hussar.base.mobile.group.service.ISysMobileApplicationGroupService;
import com.jxdinfo.hussar.base.mobile.group.vo.SysMobileApplicationGroupVo;
import com.jxdinfo.hussar.base.mobile.permission.model.SysMobileApplicationPermission;
import com.jxdinfo.hussar.base.mobile.permission.service.ISysMobileApplicationPermissionService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysMobileApplicationGroupServiceImpl
extends HussarServiceImpl<SysMobileApplicationGroupMapper, SysMobileApplicationGroup>
implements ISysMobileApplicationGroupService {
    @Resource
    private ISysMobileApplicationService sysMobileApplicationService;
    @Resource
    private ISysMobileApplicationPermissionService permissionService;
    @Resource
    private ISysStruService sysStruService;

    public ApiResponse<Boolean> insertOrUpdateGroup(SysMobileApplicationGroup sysMobileApplicationGroup) {
        this.saveOrUpdate((BaseEntity)sysMobileApplicationGroup);
        return ApiResponse.success();
    }

    public ApiResponse<Boolean> deleteGroup(String groupId) {
        this.removeById(Long.valueOf(Long.parseLong(groupId)));
        return ApiResponse.success();
    }

    public ApiResponse<List<SysMobileApplicationGroupVo>> queryGroupAndAppList() {
        List appList = this.sysMobileApplicationService.list();
        List groupList = this.list();
        return ApiResponse.success(this.combinedData(appList, groupList));
    }

    public ApiResponse<List<SysMobileApplicationGroupVo>> queryListByPermission() {
        List<SysMobileApplication> appListByPermission = this.getAppListByPermission();
        HashSet<SysMobileApplication> set = new HashSet<SysMobileApplication>(appListByPermission);
        set.addAll(this.getDefaultApp());
        appListByPermission = new ArrayList<SysMobileApplication>(set);
        List groupList = this.list();
        if (HussarUtils.isEmpty(appListByPermission)) {
            return ApiResponse.success();
        }
        List<SysMobileApplicationGroupVo> resultList = this.combinedData(appListByPermission, groupList);
        for (int i = 0; i < resultList.size(); ++i) {
            if (!HussarUtils.isEmpty((Object)resultList.get(i).getApplicationList())) continue;
            resultList.remove(i);
            --i;
        }
        return ApiResponse.success(resultList);
    }

    private List<SysMobileApplication> getAppListByPermission() {
        ArrayList<Long> relationIdList = new ArrayList<Long>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)securityUser)) {
            List rolesList = securityUser.getRolesList();
            Long deptId = securityUser.getDeptId();
            if (HussarUtils.isNotEmpty((Object)deptId)) {
                SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)deptId);
                relationIdList.add(sysStru.getOrganId());
            }
            relationIdList.add(securityUser.getUserId());
            relationIdList.addAll(rolesList);
        }
        LambdaQueryWrapper getAppByRoleWrapper = new LambdaQueryWrapper();
        getAppByRoleWrapper.in(SysMobileApplicationPermission::getRelationId, relationIdList);
        List permissionList = this.permissionService.list((Wrapper)getAppByRoleWrapper);
        ArrayList<Long> appIdList = new ArrayList<Long>();
        for (SysMobileApplicationPermission sysMobileApplicationPermission : permissionList) {
            appIdList.add(sysMobileApplicationPermission.getAppId());
        }
        if (HussarUtils.isNotEmpty(appIdList)) {
            return this.sysMobileApplicationService.listByIds(appIdList);
        }
        return new ArrayList<SysMobileApplication>();
    }

    private List<SysMobileApplicationGroupVo> combinedData(List<SysMobileApplication> appList, List<SysMobileApplicationGroup> groupList) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(groupList), SysMobileApplicationGroupVo.class).stream().collect(Collectors.toMap(SysMobileApplicationGroup::getId, Function.identity()));
        for (SysMobileApplication sysMobileApplication : appList) {
            SysMobileApplicationGroupVo sysMobileApplicationGroupVo = (SysMobileApplicationGroupVo)resultCollect.get(sysMobileApplication.getGroupId());
            if (HussarUtils.isEmpty((Object)sysMobileApplicationGroupVo)) continue;
            if (HussarUtils.isNotEmpty((Object)sysMobileApplicationGroupVo.getApplicationList())) {
                sysMobileApplicationGroupVo.getApplicationList().add(sysMobileApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysMobileApplicationGroupVo.getApplicationList())) continue;
            ArrayList<SysMobileApplication> sysMobileApplications = new ArrayList<SysMobileApplication>();
            sysMobileApplications.add(sysMobileApplication);
            sysMobileApplicationGroupVo.setApplicationList(sysMobileApplications);
        }
        return new ArrayList<SysMobileApplicationGroupVo>(resultCollect.values());
    }

    private List<SysMobileApplication> getDefaultApp() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMobileApplication::getDefaultApp, (Object)"1");
        return this.sysMobileApplicationService.list((Wrapper)queryWrapper);
    }
}

