/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.external.qingtui.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.mobile.config.MobileConfigProperty;
import com.jxdinfo.hussar.base.mobile.external.integration.model.MobileExternalConfig;
import com.jxdinfo.hussar.base.mobile.external.integration.service.IMobileExternalConfigService;
import com.jxdinfo.hussar.base.mobile.external.qingtui.config.QingTuiConfig;
import com.jxdinfo.hussar.base.mobile.external.qingtui.model.SysUserQingtui;
import com.jxdinfo.hussar.base.mobile.external.qingtui.service.QingTuiService;
import com.jxdinfo.hussar.base.mobile.external.qingtui.service.SysUserQingtuiService;
import com.jxdinfo.hussar.base.mobile.util.HttpUtil;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QingTuiLoginValidataServiceImpl
implements HussarLoginValidateService {
    private static Logger LOGGER = LoggerFactory.getLogger(QingTuiLoginValidataServiceImpl.class);
    @Resource
    private IMobileExternalConfigService mobileExternalConfigService;
    @Autowired
    private MobileConfigProperty mobileConfigProperty;
    @Resource
    private QingTuiService qingTuiService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private SysUserQingtuiService sysUserQingtuiService;
    @Resource
    private QingTuiConfig qingTuiConfig;

    public String getLoginType() {
        return "qingtui";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        String alreadyLoginAccount = (String)HussarCacheUtil.get((String)"qtCode", (Object)loginCode);
        if (HussarUtils.isNotEmpty((Object)alreadyLoginAccount)) {
            return alreadyLoginAccount;
        }
        MobileExternalConfig config = this.mobileExternalConfigService.getConfigByPlatform("qingtui");
        HttpUtil httpUtil = new HttpUtil();
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        LOGGER.info("time:" + dateTime.format(formatter) + ",qt_code: " + loginCode);
        paramList.add((NameValuePair)new BasicNameValuePair("qt_code", loginCode));
        paramList.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credential"));
        paramList.add((NameValuePair)new BasicNameValuePair("appid", config.getAppKey()));
        paramList.add((NameValuePair)new BasicNameValuePair("secret", config.getAppSecret()));
        JSONObject jsonObject = httpUtil.sendHttpGet(this.mobileConfigProperty.getQingtuiUserInfoUrl(), paramList);
        if (HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"errcode"))) {
            throw new ExtendLoginException(jsonObject.get((Object)"errmsg").toString());
        }
        String account = jsonObject.getString("employee_id");
        if (HussarUtils.isEmpty((Object)account)) {
            LOGGER.error("\u672a\u83b7\u53d6\u5230\u7528\u6237employee_id,\u6b64\u65f6qtcode\u4e3a\uff1a" + loginCode + ",\u6b64\u65f6\u8fd4\u56de\u503c\u4e3a\uff1a" + jsonObject);
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u7528\u6237employee_id");
        }
        String accessToken = this.qingTuiService.getAccessToken(null, null);
        SysUsers sysUser = this.sysUsersService.getUserByAccountAndStatus(authcDto.getDsName(), account, (List)Lists.newArrayList((Object[])new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()}));
        if (HussarUtils.isEmpty((Object)sysUser)) {
            throw new BaseException("\u8be5\u7528\u6237\u5728\u4f4e\u7801\u5e73\u53f0\u4e2d\u5df2\u88ab\u5220\u9664\u6216\u4e0d\u5b58\u5728");
        }
        String openId = jsonObject.getString("openid");
        SysUserQingtui sysUserQingtui = (SysUserQingtui)this.sysUserQingtuiService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserQingtui::getUserId, (Object)sysUser.getId())).eq(SysUserQingtui::getAgentId, (Object)config.getAppKey())).eq(SysUserQingtui::getOpenId, (Object)openId));
        if (HussarUtils.isEmpty((Object)sysUserQingtui)) {
            sysUserQingtui = new SysUserQingtui();
            String phone = this.getPhone(openId, accessToken);
            sysUserQingtui.setUserId(sysUser.getId());
            sysUserQingtui.setAgentId(config.getAppKey());
            sysUserQingtui.setOpenId(openId);
            sysUserQingtui.setPhone(phone);
            sysUserQingtui.setEmployeeId(jsonObject.getString("employee_id"));
            this.sysUserQingtuiService.save((Object)sysUserQingtui);
        }
        HussarCacheUtil.put((String)"qtCode", (Object)loginCode, (Object)sysUser.getUserAccount(), (long)60L);
        return sysUser.getUserAccount();
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    private String getPhone(String openId, String accessToken) {
        HttpUtil httpUtil = new HttpUtil();
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        paramList.add((NameValuePair)new BasicNameValuePair("access_token", accessToken));
        paramList.add((NameValuePair)new BasicNameValuePair("open_id", openId));
        String qingtuiUserDetailURL = this.qingTuiConfig.getTeamURL() + "/member/openid/detail";
        JSONObject jsonObject = httpUtil.sendHttpGet(qingtuiUserDetailURL, paramList);
        return jsonObject.getString("mobile");
    }
}

