/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.external.qingtui.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.mobile.external.qingtui.model.SysUserQingtui;
import com.jxdinfo.hussar.base.mobile.external.qingtui.service.MobileQtService;
import com.jxdinfo.hussar.base.mobile.external.qingtui.service.QingTuiService;
import com.jxdinfo.hussar.base.mobile.external.qingtui.service.SysUserQingtuiService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MobileQtServiceImpl
implements MobileQtService {
    private static Logger logger = LoggerFactory.getLogger(MobileQtServiceImpl.class);
    @Resource
    private QingTuiService qingTuiService;
    @Resource
    private SysUserQingtuiService userQingtuiService;
    @Resource
    private ISysUsersService sysUsersService;

    public String getBaseUrl() {
        return this.qingTuiService.getBaseUrl();
    }

    public String getToken(String appId, String secret) {
        return this.qingTuiService.getAccessToken(appId, secret);
    }

    public List<String> getQtOpenIdList(List<String> receiver) {
        List qingTuiUsers = this.userQingtuiService.list((Wrapper)new LambdaQueryWrapper().in(SysUserQingtui::getUserId, receiver));
        ArrayList<String> openIdList = new ArrayList<String>();
        for (SysUserQingtui qingtuiUser : qingTuiUsers) {
            openIdList.add(qingtuiUser.getOpenId());
        }
        if (receiver.size() != openIdList.size()) {
            List userIds = qingTuiUsers.stream().map(SysUserQingtui::getUserId).collect(Collectors.toList());
            List noOpenIdUsers = receiver.stream().map(Long::parseLong).filter(element -> !userIds.contains(element)).collect(Collectors.toList());
            List noOpenIdUserList = this.sysUsersService.listByIds(noOpenIdUsers);
            String names = "";
            for (SysUsers sysUser : noOpenIdUserList) {
                names = names + sysUser.getUserName() + " " + sysUser.getUserAccount() + ", ";
            }
            logger.warn("\u4e0b\u5217\u7528\u6237\u6ca1\u6709openid\uff1a" + names);
        }
        return openIdList;
    }
}

