/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.base.mobile.config.MobileConfigProperty;
import com.jxdinfo.hussar.base.mobile.external.integration.dto.QueryConfigDto;
import com.jxdinfo.hussar.base.mobile.external.integration.model.MobileExternalConfig;
import com.jxdinfo.hussar.base.mobile.external.integration.service.IMobileExternalConfigService;
import com.jxdinfo.hussar.base.mobile.util.HttpUtil;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class TokenUtil {
    private static final String CACHE_NAME = "mobile:weChatWork";
    private static final String LOGIN_TYPE_WECHATWORK = "weChatWork";
    private static final String CORP_ID = "corpid";
    private static final String CORP_SECRET = "corpsecret";
    private static final String ERR_CODE = "errcode";
    private static final String ERR_MSG = "errmsg";
    private static final String ACCESS_TOKEN = "access_token";
    private static final Integer EFFECT_SECOND = 7000;

    public static String getWeChatWorkToken(String appType) {
        String accessToken = (String)HussarCacheUtil.get((String)CACHE_NAME, (Object)CACHE_NAME);
        if (HussarUtils.isEmpty((Object)accessToken)) {
            accessToken = TokenUtil.initWeChatWorkToken(appType);
        }
        return accessToken;
    }

    private static String initWeChatWorkToken(String appType) {
        HttpUtil httpUtil = new HttpUtil();
        IMobileExternalConfigService mobileExternalConfigService = (IMobileExternalConfigService)SpringContextHolder.getBean(IMobileExternalConfigService.class);
        MobileConfigProperty mobileConfigProperty = (MobileConfigProperty)SpringContextHolder.getBean(MobileConfigProperty.class);
        QueryConfigDto configDto = new QueryConfigDto(LOGIN_TYPE_WECHATWORK, appType);
        MobileExternalConfig config = mobileExternalConfigService.getConfigByPlatformAndType(configDto);
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        paramList.add((NameValuePair)new BasicNameValuePair(CORP_ID, config.getAppKey()));
        paramList.add((NameValuePair)new BasicNameValuePair(CORP_SECRET, config.getAppSecret()));
        JSONObject jsonObject = httpUtil.sendHttpGet(mobileConfigProperty.getWeChatWorkTokenUrl(), paramList);
        if (!"0".equals(jsonObject.get((Object)ERR_CODE).toString())) {
            throw new ExtendLoginException(jsonObject.get((Object)ERR_MSG).toString());
        }
        String accessToken = jsonObject.get((Object)ACCESS_TOKEN).toString();
        HussarCacheUtil.put((String)CACHE_NAME, (Object)CACHE_NAME, (Object)accessToken, (long)EFFECT_SECOND.intValue());
        return accessToken;
    }
}

