/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.mobile.pack.build.model.PackageBuild;
import com.jxdinfo.hussar.mobile.pack.build.model.PackageBuildLog;
import com.jxdinfo.hussar.mobile.pack.manager.FileManager;
import com.jxdinfo.hussar.mobile.pack.manager.JenkinsManager;
import com.jxdinfo.hussar.mobile.pack.setting.service.PackageSettingService;
import com.jxdinfo.hussar.mobile.pack.utils.CommonUtills;
import com.jxdinfo.hussar.mobile.pack.utils.HttpUtil;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class JenkinsManagerImpl
implements JenkinsManager {
    @Resource
    private PackageSettingService packageSettingService;
    @Resource
    private FileManager fileManager;

    public void executeJenkinsBuild(Map<String, Object> params) {
        Map settingMap = this.packageSettingService.getSettingMap();
        if (settingMap == null) {
            throw new HussarException("\u83b7\u53d6\u4e0d\u5230\u6784\u5efa\u914d\u7f6e");
        }
        String addrUrl = settingMap.get("JENKINS_SERVER_IP") + ":" + settingMap.get("JENKINS_SERVER_PORT");
        String path = "/buildByToken/buildWithParameters";
        params.put("token", settingMap.get("JENKINS_SERVER_TOKEN"));
        try {
            HttpUtil.doPost((String)addrUrl, (String)path, null, params, null);
        }
        catch (Exception e) {
            throw new HussarException("\u8c03\u7528jenkins\u6784\u5efa\u5931\u8d25\uff01");
        }
    }

    public String getBuildId(String jobName, String buildId) {
        Map settingMap = this.packageSettingService.getSettingMap();
        if (settingMap == null) {
            throw new HussarException("\u83b7\u53d6\u4e0d\u5230\u6784\u5efa\u914d\u7f6e");
        }
        String addrUrl = settingMap.get("JENKINS_SERVER_IP") + ":" + settingMap.get("JENKINS_SERVER_PORT");
        String path = "/job/" + jobName + "/api/json";
        HashMap hashMap = null;
        try {
            HttpResponse response = HttpUtil.doGet((String)addrUrl, (String)path, null, null);
            hashMap = (HashMap)JSONObject.parseObject((String)HttpUtil.toString((HttpResponse)response), HashMap.class);
        }
        catch (IOException e) {
            throw new HussarException("\u8c03\u7528jenkins\u83b7\u53d6\u6784\u5efaid\u5931\u8d25");
        }
        JSONArray builds = (JSONArray)hashMap.get("builds");
        int number = 0;
        if (builds != null && builds.size() != 0) {
            for (Object build : builds) {
                number = (Integer)((JSONObject)build).get((Object)"number");
                String buildAddrUrl = settingMap.get("JENKINS_SERVER_IP") + ":" + settingMap.get("JENKINS_SERVER_PORT");
                String buildPath = "/job/" + jobName + "/" + number + "/api/json";
                HttpResponse buildResponse = HttpUtil.doGet((String)buildAddrUrl, (String)buildPath, null, null);
                HashMap detailMap = null;
                try {
                    detailMap = (HashMap)JSONObject.parseObject((String)HttpUtil.toString((HttpResponse)buildResponse), HashMap.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (detailMap == null || detailMap.get("actions") == null && ((JSONArray)detailMap.get("actions")).size() == 0) continue;
                JSONArray parameters = (JSONArray)((JSONObject)((JSONArray)detailMap.get("actions")).get(0)).get((Object)"parameters");
                for (Object parameter : parameters) {
                    if (!((JSONObject)parameter).get((Object)"name").equals("buildId") || !buildId.equals(((JSONObject)parameter).get((Object)"value"))) continue;
                    return String.valueOf(number);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageBuildLog getJenkinsBuildLog(PackageBuild build) {
        Map settingMap = this.packageSettingService.getSettingMap();
        if (settingMap == null) {
            throw new HussarException("\u83b7\u53d6\u4e0d\u5230\u6784\u5efa\u914d\u7f6e");
        }
        String jobName = null;
        if ("1".equals(build.getBuildType())) {
            jobName = (String)settingMap.get("JENKINS_ANDROID_JOB_NAME");
        } else if ("0".equals(build.getBuildType())) {
            jobName = (String)settingMap.get("JENKINS_IOS_JOB_NAME");
        }
        InputStream in = null;
        try {
            String addrUrl = "http://" + settingMap.get("JENKINS_SERVER_IP") + ":" + settingMap.get("JENKINS_SERVER_PORT");
            String path = "/job/" + jobName + "/" + build.getJenkinsBuildId() + "/consoleText";
            URL url = new URL(addrUrl + path);
            in = url.openStream();
            byte[] totalData = IOUtils.toByteArray((InputStream)in);
            AttachmentManagerModelVo attachmentManagerModelVo = this.uploadFile(totalData);
            if (attachmentManagerModelVo != null) {
                PackageBuildLog buildLog = new PackageBuildLog();
                buildLog.setFileId(attachmentManagerModelVo.getId());
                buildLog.setBuildId(build.getId());
                buildLog.setFileName(attachmentManagerModelVo.getFileName());
                buildLog.setFileSize(String.valueOf(Math.toIntExact(totalData.length)));
                PackageBuildLog packageBuildLog = buildLog;
                return packageBuildLog;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Boolean getBuildResult(String jobName, String jenkinsBuildId) {
        Object result;
        Map settingMap = this.packageSettingService.getSettingMap();
        if (settingMap == null) {
            throw new HussarException("\u83b7\u53d6\u4e0d\u5230\u6784\u5efa\u914d\u7f6e");
        }
        String addrUrl = settingMap.get("JENKINS_SERVER_IP") + ":" + settingMap.get("JENKINS_SERVER_PORT");
        String path = "job/" + jobName + "/" + jenkinsBuildId + "/api/json";
        HashMap detailMap = null;
        try {
            HttpResponse response = HttpUtil.doGet((String)addrUrl, (String)path, null, null);
            detailMap = (HashMap)JSONObject.parseObject((String)HttpUtil.toString((HttpResponse)response), HashMap.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object object = result = detailMap != null ? (Object)detailMap.get("result") : null;
        if (result == null || "FAILURE".equals(result.toString())) {
            return false;
        }
        return true;
    }

    private AttachmentManagerModelVo uploadFile(byte[] fileByte) {
        Long fileId = CommonUtills.generateAssignId();
        String fileName = fileId + ".log";
        HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(fileName, fileName, "application/octet-stream", fileByte);
        return this.fileManager.uploadFile((MultipartFile)multipartFile);
    }
}

