/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.setting.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.mobile.pack.setting.dao.PackageSettingMapper;
import com.jxdinfo.hussar.mobile.pack.setting.dto.PackageSettingDto;
import com.jxdinfo.hussar.mobile.pack.setting.model.PackageSetting;
import com.jxdinfo.hussar.mobile.pack.setting.service.PackageSettingService;
import com.jxdinfo.hussar.mobile.pack.setting.vo.PackageSettingVo;
import com.jxdinfo.hussar.mobile.pack.user.vo.SysUsersVo;
import com.jxdinfo.hussar.mobile.pack.utils.CommonUtills;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.mobile.pack.setting.service.impl.packageSettingServiceImpl")
public class PackageSettingServiceImpl
extends HussarServiceImpl<PackageSettingMapper, PackageSetting>
implements PackageSettingService {
    @Resource
    private PackageSettingMapper settingMapper;

    public ApiResponse<IPage<PackageSettingVo>> getSettingList(String name, String code, PageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        try {
            name = CommonUtills.replaceSpeciaChar((String)name);
            code = CommonUtills.replaceSpeciaChar((String)code);
            List<PackageSettingVo> list = this.settingMapper.getSettingList((Page<PackageSettingVo>)page, name, code);
            page.setRecords(list);
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u8bbe\u7f6e\u5217\u8868\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Boolean> addSetting(PackageSettingDto settingDto) {
        PackageSetting setting = new PackageSetting();
        BeanUtils.copyProperties((Object)settingDto, (Object)setting);
        try {
            this.save((BaseEntity)setting);
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> updateSetting(PackageSettingDto settingDto) {
        PackageSetting packageSetting = (PackageSetting)this.getById(settingDto.getId());
        packageSetting.setSettingValue(settingDto.getSettingValue());
        packageSetting.setSettingCode(settingDto.getSettingCode());
        packageSetting.setSettingName(settingDto.getSettingName());
        packageSetting.setRemark(settingDto.getRemark());
        try {
            this.updateById((BaseEntity)packageSetting);
        }
        catch (Exception e) {
            throw new HussarException("\u4fee\u6539\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> deleteSetting(Long settingId) {
        try {
            this.removeById(settingId);
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<HashMap<String, PackageSettingVo>> getJenkinsConfigList() {
        HashMap hashMap = new HashMap();
        this.list().forEach(packSysConfig -> {
            PackageSettingVo sysConfigVo = new PackageSettingVo();
            BeanUtils.copyProperties((Object)packSysConfig, (Object)sysConfigVo);
            hashMap.put(sysConfigVo.getSettingCode(), sysConfigVo);
        });
        return ApiResponse.success(hashMap);
    }

    public IPage<SysUsersVo> getUsersList(String userName, PageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        try {
            userName = CommonUtills.replaceSpeciaChar((String)userName);
            List<SysUsersVo> list = this.settingMapper.getUsersList((Page<SysUsersVo>)page, userName);
            page.setRecords(list);
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u7528\u6237\u5217\u8868\u5931\u8d25\uff01");
        }
        return page;
    }

    public Map<String, Object> getSettingMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = this.list();
        if (list != null && list.size() > 0) {
            for (PackageSetting setting : list) {
                map.put(setting.getSettingCode(), setting.getSettingValue());
            }
        }
        return map;
    }
}

