/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.setting.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.mobile.pack.setting.dto.PackageSettingDto;
import com.jxdinfo.hussar.mobile.pack.setting.service.PackageSettingService;
import com.jxdinfo.hussar.mobile.pack.setting.vo.PackageSettingVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7cfb\u7edf\u914d\u7f6e\u540e\u53f0\u7ba1\u7406\u64cd\u4f5c\u7c7b"})
@RestController
@RequestMapping(value={"/hussarbase/package/setting"})
public class PackageSettingController {
    @Resource
    private PackageSettingService packageSettingService;

    @ApiOperation(value="\u540e\u53f0\u67e5\u770b\u914d\u7f6e", notes="\u540e\u53f0\u67e5\u770b\u914d\u7f6e")
    @GetMapping(value={"/getSettingList"})
    @AuditLog(moduleName="\u79fb\u52a8\u6253\u5305\u914d\u7f6e", eventDesc="\u540e\u53f0\u67e5\u770b\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<PackageSettingVo>> getSettingList(@RequestParam(value="name", required=false) @ApiParam(value="\u914d\u7f6e\u540d\u79f0") String name, @RequestParam(value="code", required=false) @ApiParam(value="\u7f16\u7801\u6807\u8bc6") String code, @ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo) {
        return this.packageSettingService.getSettingList(name, code, pageInfo);
    }

    @ApiOperation(value="\u65b0\u589e\u914d\u7f6e", notes="\u65b0\u589e\u914d\u7f6e")
    @PostMapping(value={"/addSetting"})
    @AuditLog(moduleName="\u79fb\u52a8\u6253\u5305\u914d\u7f6e", eventDesc="\u65b0\u589e\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> addSetting(@RequestBody @ApiParam(value="settingDto") PackageSettingDto settingDto) {
        return this.packageSettingService.addSetting(settingDto);
    }

    @ApiOperation(value="\u66f4\u65b0\u7cfb\u7edf\u914d\u7f6e", notes="\u66f4\u65b0\u7cfb\u7edf\u914d\u7f6e")
    @PostMapping(value={"/updateSetting"})
    @AuditLog(moduleName="\u79fb\u52a8\u6253\u5305\u914d\u7f6e", eventDesc="\u66f4\u65b0\u7cfb\u7edf\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateSetting(@RequestBody @ApiParam(value="settingDto") PackageSettingDto settingDto) {
        return this.packageSettingService.updateSetting(settingDto);
    }

    @ApiOperation(value="\u5220\u9664\u7cfb\u7edf\u914d\u7f6e", notes="\u5220\u9664\u7cfb\u7edf\u914d\u7f6e")
    @PostMapping(value={"/deleteSetting"})
    @AuditLog(moduleName="\u79fb\u52a8\u6253\u5305\u914d\u7f6e", eventDesc="\u5220\u9664\u7cfb\u7edf\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> deleteSetting(@RequestBody @ApiParam(value="\u5e94\u7528\u4e3b\u952e") Long configId) {
        return this.packageSettingService.deleteSetting(configId);
    }
}

