/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.jenkins.controller;

import com.jxdinfo.hussar.mobile.pack.app.service.PackageCodeVersionService;
import com.jxdinfo.hussar.mobile.pack.app.service.PackageConfigService;
import com.jxdinfo.hussar.mobile.pack.app.vo.PackageJenkinsConfigVo;
import com.jxdinfo.hussar.mobile.pack.build.model.PackageBuild;
import com.jxdinfo.hussar.mobile.pack.build.service.PackageBuildLogService;
import com.jxdinfo.hussar.mobile.pack.build.service.PackageBuildService;
import com.jxdinfo.hussar.mobile.pack.setting.service.PackageSettingService;
import com.jxdinfo.hussar.mobile.pack.setting.vo.PackageSettingVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u79fb\u52a8\u6253\u5305jenkins\u6784\u5efa\u64cd\u4f5c\u7c7b"})
@RestController
@RequestMapping(value={"/hussarbase/package/jenkins"})
public class PackageJenkinsController {
    @Resource
    private PackageConfigService packageConfigService;
    @Resource
    private PackageSettingService packageSettingService;
    @Resource
    private PackageBuildService buildService;
    @Resource
    private PackageBuildLogService buildLogService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private PackageCodeVersionService appCodeVersionService;

    @GetMapping(value={"/fileDownload"})
    @ApiOperation(value="\u79fb\u52a8\u6253\u5305\u6587\u4ef6\u4e0b\u8f7d", notes="\u79fb\u52a8\u6253\u5305\u6587\u4ef6\u4e0b\u8f7d")
    @AuditLog(moduleName="\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", eventDesc="\u79fb\u52a8\u6253\u5305\u6587\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void fileDownload(HttpServletResponse response, @ApiParam(value="\u6587\u4ef6id") @RequestParam String fileId) {
        AttachmentManagerModelVo managerModelVo = this.attachmentManagerService.getByFileId(Long.valueOf(fileId));
        response.setHeader("Content-Length", managerModelVo.getBytes());
        this.attachmentManagerService.fileDownload(response, Long.valueOf(fileId));
    }

    @GetMapping(value={"/config"})
    @ApiOperation(value="jenkins\u6839\u636e\u914d\u7f6eid\u83b7\u53d6app\u914d\u7f6e\u8be6\u60c5", notes="jenkins\u6839\u636e\u914d\u7f6eid\u83b7\u53d6app\u914d\u7f6e\u8be6\u60c5")
    @AuditLog(moduleName="\u79fb\u52a8\u6253\u5305\u914d\u7f6e", eventDesc="jenkins\u6839\u636e\u914d\u7f6eid\u83b7\u53d6app\u914d\u7f6e\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<PackageJenkinsConfigVo> getConfigJenkinsDetail(@RequestParam @ApiParam(value="\u914d\u7f6eid") Long configId) {
        return this.packageConfigService.getConfigJenkinsDetail(configId);
    }

    @ApiOperation(value="\u6253\u5305\u914d\u7f6ejenkins\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e", notes="jenkins\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e")
    @GetMapping(value={"/setting"})
    @AuditLog(moduleName="\u79fb\u52a8\u6253\u5305\u914d\u7f6e", eventDesc="\u6253\u5305\u914d\u7f6ejenkins\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<HashMap<String, PackageSettingVo>> getJenkinsList() {
        return this.packageSettingService.getJenkinsConfigList();
    }

    @PostMapping(value={"/build/upload"})
    @ApiOperation(value="jenkins\u7f16\u8bd1\u540e\uff0c\u4e0a\u4f20ios\u3001apk\u5305", notes="jenkins\u7f16\u8bd1\u540e\uff0c\u4e0a\u4f20ios\u3001apk\u5305")
    @AuditLog(moduleName="\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", eventDesc="jenkins\u7f16\u8bd1\u540e\uff0c\u4e0a\u4f20ios\u3001apk\u5305", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateCodePackage(@RequestPart @ApiParam(value="\u4e0a\u4f20\u6587\u4ef6") MultipartFile multipartFile, @RequestParam @ApiParam(value="\u6784\u5efaId") String buildId, @RequestParam(value="apiKey", required=false) @ApiParam(value="\u7528\u6237Id") Long apiKey, HttpServletRequest request) throws Exception {
        return this.buildService.updateCodePackage(multipartFile, Long.valueOf(buildId), request, apiKey);
    }

    @PostMapping(value={"/log/upload"})
    @ApiOperation(value="jenkins\u4e0a\u4f20\u6784\u5efa\u65e5\u5fd7", notes="jenkins\u4e0a\u4f20\u6784\u5efa\u65e5\u5fd7")
    @AuditLog(moduleName="\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", eventDesc="jenkins\u4e0a\u4f20\u6784\u5efa\u65e5\u5fd7", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> uploadLog(@RequestPart @ApiParam(value="\u4e0a\u4f20\u6587\u4ef6") MultipartFile multipartFile, @RequestParam @ApiParam(value="\u6784\u5efaid") String buildId, HttpServletRequest request) {
        return this.buildLogService.uploadBuildLog(multipartFile, Long.valueOf(buildId), request);
    }

    @PostMapping(value={"/build/after"})
    @ApiOperation(value="jenkis\u6784\u5efa\u5b8c\u6210\u540e\u8c03\u7528", notes="jenkis\u6784\u5efa\u5b8c\u6210\u540e\u8c03\u7528")
    @AuditLog(moduleName="\u79fb\u52a8\u5e94\u7528\u6253\u5305\u6784\u5efa", eventDesc="jenkis\u6784\u5efa\u5b8c\u6210\u540e\u8c03\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> afterBuild(@RequestParam @ApiParam(value="\u6784\u5efaId") String buildId) {
        PackageBuild build = (PackageBuild)this.buildService.getById((Serializable)Long.valueOf(buildId));
        this.buildService.dealAfterBuild(build);
        return ApiResponse.success((Object)true);
    }

    @ApiOperation(value="\u83b7\u53d6\u6700\u65b0\u7248\u672c(\u5373\u68c0\u67e5\u66f4\u65b0www\u5305)")
    @GetMapping(value={"/latest"})
    @AuditLog(moduleName="\u83b7\u53d6\u6700\u65b0\u7248\u672c(\u5373\u68c0\u67e5\u66f4\u65b0www\u5305)", eventDesc="\u83b7\u53d6\u6700\u65b0\u7248\u672c(\u5373\u68c0\u67e5\u66f4\u65b0www\u5305)", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public Object getLatestAppCodeVersion(@RequestParam(value="objID") @ApiParam(value="\u914d\u7f6e\u4e3b\u952e") String id, @RequestParam(value="type") @ApiParam(value="\u7c7b\u578b") int type) {
        return this.appCodeVersionService.getLatestAppCodeVersion(id, type);
    }
}

