/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.pack.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.mobile.pack.app.dao.PackageConfigMapper;
import com.jxdinfo.hussar.mobile.pack.app.dto.PackageConfigDto;
import com.jxdinfo.hussar.mobile.pack.app.dto.PackageConfigQueryReqDto;
import com.jxdinfo.hussar.mobile.pack.app.model.PackageConfig;
import com.jxdinfo.hussar.mobile.pack.app.model.PackageConfigProperty;
import com.jxdinfo.hussar.mobile.pack.app.service.PackageConfigPropertyService;
import com.jxdinfo.hussar.mobile.pack.app.service.PackageConfigService;
import com.jxdinfo.hussar.mobile.pack.app.vo.PackageConfigVo;
import com.jxdinfo.hussar.mobile.pack.app.vo.PackageJenkinsConfigVo;
import com.jxdinfo.hussar.mobile.pack.build.model.PackageBuild;
import com.jxdinfo.hussar.mobile.pack.build.service.PackageBuildService;
import com.jxdinfo.hussar.mobile.pack.utils.CommonUtills;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.mobile.pack.app.service.impl.packageAppConfigServiceImpl")
public class PackageConfigServiceImpl
extends HussarServiceImpl<PackageConfigMapper, PackageConfig>
implements PackageConfigService {
    @Resource
    private PackageConfigMapper packageConfigMapper;
    @Resource
    private PackageConfigPropertyService configPropertyService;
    @Resource
    private PackageBuildService packageBuildService;

    public ApiResponse<IPage<PackageConfigVo>> getAppConfigList(PageInfo pageInfo, PackageConfigQueryReqDto appConfigQueryReqDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        try {
            appConfigQueryReqDto.setConfigName(CommonUtills.replaceSpeciaChar((String)appConfigQueryReqDto.getConfigName()));
            List<PackageConfigVo> list = this.packageConfigMapper.getConfigList((Page<PackageConfigVo>)page, appConfigQueryReqDto);
            if (CollectionUtil.isNotEmpty(list)) {
                for (PackageConfigVo configVo : list) {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(PackageBuild::getAppId, (Object)configVo.getbId());
                    queryWrapper.eq(PackageBuild::getConfigId, (Object)configVo.getId());
                    queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
                    List buildList = this.packageBuildService.list((Wrapper)queryWrapper);
                    if (buildList.size() <= 0) continue;
                    configVo.setLastBuildTime(((PackageBuild)buildList.get(0)).getCreateTime());
                }
            }
            page.setRecords(list);
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u914d\u7f6e\u5217\u8868\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)page);
    }

    @HussarTransactional
    public ApiResponse<Long> addConfig(PackageConfigDto configDto) {
        PackageConfig packageConfig = new PackageConfig();
        BeanUtils.copyProperties((Object)configDto, (Object)packageConfig);
        try {
            this.save((BaseEntity)packageConfig);
            if (CollectionUtil.isNotEmpty((Collection)configDto.getPropertyList())) {
                configDto.getPropertyList().forEach(property -> property.setConfigId(packageConfig.getId()));
                this.configPropertyService.saveBatch((Collection)configDto.getPropertyList());
            }
        }
        catch (Exception e) {
            throw new HussarException("\u65b0\u589e\u6253\u5305\u914d\u7f6e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)packageConfig.getId());
    }

    public ApiResponse<PackageConfigVo> getConfigDetailById(Long configId) {
        PackageConfigVo configVo = null;
        try {
            configVo = this.packageConfigMapper.getConfigDetailById(configId);
        }
        catch (Exception e) {
            throw new HussarException("\u83b7\u53d6\u914d\u7f6e\u8be6\u60c5\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)configVo);
    }

    public ApiResponse<Boolean> updateConfigInfo(PackageConfigDto configDto) {
        PackageConfig packageConfig = (PackageConfig)this.getById(configDto.getId());
        packageConfig.setVersionId(configDto.getVersionId());
        try {
            this.updateById((BaseEntity)packageConfig);
        }
        catch (Exception e) {
            throw new HussarException("\u4fee\u6539\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true);
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateConfigAndProperty(PackageConfigDto configDto) {
        PackageConfig packageConfig = new PackageConfig();
        BeanUtils.copyProperties((Object)configDto, (Object)packageConfig);
        try {
            this.updateById((BaseEntity)packageConfig);
            this.configPropertyService.remove((Wrapper)new LambdaQueryWrapper().eq(PackageConfigProperty::getConfigId, (Object)packageConfig.getId()));
            if (CollectionUtil.isNotEmpty((Collection)configDto.getPropertyList())) {
                configDto.getPropertyList().forEach(property -> {
                    property.setId(null);
                    property.setConfigId(packageConfig.getId());
                });
                this.configPropertyService.saveBatch((Collection)configDto.getPropertyList());
            }
        }
        catch (Exception e) {
            throw new HussarException("\u4fee\u6539\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<PackageJenkinsConfigVo> getConfigJenkinsDetail(Long configId) {
        PackageJenkinsConfigVo jenkinsConfigVO = new PackageJenkinsConfigVo();
        PackageConfig packageConfig = (PackageConfig)this.getById(configId);
        BeanUtils.copyProperties((Object)packageConfig, (Object)jenkinsConfigVO);
        try {
            List propertyList = this.configPropertyService.list((Wrapper)new LambdaQueryWrapper().eq(PackageConfigProperty::getConfigId, (Object)configId));
            if (propertyList != null) {
                HashMap hashMap = new HashMap();
                propertyList.forEach(property -> hashMap.put(property.getConfigCode(), property));
                jenkinsConfigVO.setPropertyList(hashMap);
            }
        }
        catch (Exception e) {
            throw new HussarException("\u83b7\u53d6\u914d\u7f6e\u8be6\u60c5\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)jenkinsConfigVO);
    }
}

