/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.manager;

import com.jxdinfo.hussar.migration.exceptions.MigrationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public interface HussarBaseMigrationStorageManager {
    default public void download(String handle, OutputStream destination) {
        try {
            byte[] data = this.download(handle);
            IOUtils.write((byte[])data, (OutputStream)destination);
        }
        catch (IOException ex) {
            throw new MigrationException((Throwable)ex);
        }
    }

    default public void download(String handle, File destination) {
        try {
            byte[] data = this.download(handle);
            FileUtils.writeByteArrayToFile((File)destination, (byte[])data);
        }
        catch (IOException ex) {
            throw new MigrationException((Throwable)ex);
        }
    }

    public byte[] download(String var1);

    default public String upload(String filename, InputStream source) {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)source);
            return this.upload(filename, data);
        }
        catch (IOException ex) {
            throw new MigrationException((Throwable)ex);
        }
    }

    default public String upload(String filename, File source) {
        try {
            byte[] data = FileUtils.readFileToByteArray((File)source);
            return this.upload(filename, data);
        }
        catch (IOException ex) {
            throw new MigrationException((Throwable)ex);
        }
    }

    public String upload(String var1, byte[] var2);

    public String filename(String var1);

    public boolean exists(String var1);

    public boolean remove(String var1);
}

