/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.plugin.context;

import com.jxdinfo.hussar.migration.exceptions.MigrationException;
import com.jxdinfo.hussar.migration.manifest.MigrationArchiveItem;
import com.jxdinfo.hussar.migration.manifest.MigrationArchiveManifest;
import com.jxdinfo.hussar.migration.plugin.context.AbstractMigrationReadonlyContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationWritableContext;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public abstract class AbstractMigrationWritableContext
extends AbstractMigrationReadonlyContext
implements MigrationWritableContext {
    public AbstractMigrationWritableContext(MigrationArchiveManifest manifest, MigrationArchiveItem item, File workspace) {
        super(manifest, item, workspace);
    }

    public void setVersion(Long version) {
        this.item.setVersion(version);
    }

    public void setDescription(String description) {
        this.item.setDescription(description);
    }

    public void setAttribute(String key, Object value) {
        Map<String, Object> attributes = this.item.getAttributes();
        if (attributes == null) {
            attributes = new LinkedHashMap<String, Object>();
            this.item.setAttributes(attributes);
        }
        attributes.put(key, value);
    }

    public boolean removeAttribute(String key) {
        Map<String, Object> attributes = this.item.getAttributes();
        return attributes != null && attributes.remove(key) != null;
    }

    public void setPayloadOfByteArray(String name, byte[] bytes) {
        File file = new File(this.workspace, name);
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])bytes);
        }
        catch (IOException ex) {
            throw new MigrationException((Throwable)ex);
        }
    }

    public boolean removePayload(String name) {
        File file = new File(this.workspace, name);
        if (!file.isFile()) {
            return false;
        }
        try {
            FileUtils.forceDelete((File)file);
            return true;
        }
        catch (IOException ex) {
            throw new MigrationException((Throwable)ex);
        }
    }

    public void setArchiveTag(String tag, String value) {
        Map<String, String> tags = this.manifest.getTags();
        if (tags == null) {
            tags = new LinkedHashMap<String, String>();
            this.manifest.setTags(tags);
        }
        tags.put(tag, value);
    }

    public boolean removeArchiveTag(String tag) {
        Map<String, String> tags = this.manifest.getTags();
        return tags != null && tags.remove(tag) != null;
    }
}

