/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.manager.impl;

import com.jxdinfo.hussar.migration.exceptions.MigrationException;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationStorageManager;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;
import org.springframework.web.multipart.MultipartFile;

@Repository(value="com.jxdinfo.hussar.migration.manager.impl.hussarBaseMigrationStorageManagerImpl")
public class HussarBaseMigrationStorageManagerImpl
implements HussarBaseMigrationStorageManager {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseMigrationStorageManagerImpl.class);
    private static final String ERROR_MESSAGE_EMPTY_FILE_HANDLE = "\u6587\u4ef6\u53e5\u67c4\u4e3a\u7a7a";
    private static final String ERROR_MESSAGE_EMPTY_FILE_NAME = "\u6587\u4ef6\u540d\u4e3a\u7a7a";
    private static final String ERROR_MESSAGE_FILE_DOWNLOAD = "\u6587\u4ef6\u53e5\u67c4\u4e0b\u8f7d\u5931\u8d25: %s";
    private static final String ERROR_MESSAGE_FILE_UPLOAD = "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: %s";
    @Autowired
    private OssService ossService;

    @Override
    public byte[] download(String handle) {
        Handle parsedHandle = Handle.parse(handle);
        if (parsedHandle == null) {
            throw new MigrationException(ERROR_MESSAGE_EMPTY_FILE_HANDLE);
        }
        try {
            ApiResponse response = this.ossService.backgroundDownload(parsedHandle.getId());
            if (response == null || !response.isSuccess()) {
                throw new MigrationException(String.format(ERROR_MESSAGE_FILE_DOWNLOAD, handle));
            }
            return Optional.ofNullable(response.getData()).orElseGet(() -> new byte[0]);
        }
        catch (MigrationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MigrationException(String.format(ERROR_MESSAGE_FILE_DOWNLOAD, handle), (Throwable)ex);
        }
    }

    @Override
    public String upload(String filename, byte[] source) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            throw new MigrationException(ERROR_MESSAGE_EMPTY_FILE_NAME);
        }
        try {
            ByteArrayMultipartFile multipartFile = new ByteArrayMultipartFile(filename, source);
            ApiResponse response = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            if (response == null || !response.isSuccess() || response.getData() == null) {
                throw new MigrationException(String.format(ERROR_MESSAGE_FILE_UPLOAD, filename));
            }
            Long id = (Long)response.getData();
            return Handle.of(id, filename).toString();
        }
        catch (MigrationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MigrationException(String.format(ERROR_MESSAGE_FILE_UPLOAD, filename), (Throwable)ex);
        }
    }

    @Override
    public String filename(String handle) {
        return Optional.ofNullable(Handle.parse(handle)).map(Handle::getName).orElse(null);
    }

    @Override
    public boolean exists(String handle) {
        Handle parsedHandle = Handle.parse(handle);
        if (parsedHandle != null) {
            try {
                ApiResponse response = this.ossService.isExist(parsedHandle.getId());
                if (response == null || !response.isSuccess()) {
                    return false;
                }
                return (Boolean)Optional.ofNullable(response.getData()).orElse(false);
            }
            catch (Exception ex) {
                logger.error("failed to judge if file handle `{}` exists", (Object)handle, (Object)ex);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean remove(String handle) {
        Handle parsedHandle = Handle.parse(handle);
        if (parsedHandle != null) {
            try {
                ApiResponse response = this.ossService.deleteFile(parsedHandle.getId());
                return Optional.ofNullable(response).map(res -> res.isSuccess()).orElse(false);
            }
            catch (Exception ex) {
                logger.error("failed to remove file handle `{}`", (Object)handle, (Object)ex);
                return false;
            }
        }
        return false;
    }

    private static final class ByteArrayMultipartFile
    implements MultipartFile {
        private final String name;
        private final byte[] data;

        public ByteArrayMultipartFile(String name, byte[] data) {
            if (name == null || data == null) {
                throw new NullPointerException();
            }
            this.name = name;
            this.data = data;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        public String getOriginalFilename() {
            return this.name;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public boolean isEmpty() {
            return this.getSize() == 0L;
        }

        public long getSize() {
            return this.data.length;
        }

        @NonNull
        public byte[] getBytes() throws IOException {
            return this.data;
        }

        @NonNull
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public void transferTo(@NonNull File file) throws IOException {
            FileUtils.writeByteArrayToFile((File)file, (byte[])this.data);
        }
    }

    private static final class Handle {
        private final Long id;
        private final String name;
        private static final String ERROR_MESSAGE_BAD_FILE_HANDLE = "\u6587\u4ef6\u53e5\u67c4\u683c\u5f0f\u9519\u8bef: %s";

        private Handle(Long id, String name) {
            if (id == null || name == null) {
                throw new NullPointerException();
            }
            this.id = id;
            this.name = name;
        }

        public static Handle of(Long id, String name) {
            return new Handle(id, name);
        }

        public static Handle parse(String handle) {
            if (StringUtils.isEmpty((CharSequence)handle)) {
                return null;
            }
            String[] fields = handle.split(":", 2);
            if (fields.length != 2 || StringUtils.isEmpty((CharSequence)fields[0]) || StringUtils.isEmpty((CharSequence)fields[1])) {
                throw new MigrationException(String.format(ERROR_MESSAGE_BAD_FILE_HANDLE, handle));
            }
            try {
                long id = Long.parseLong(fields[0]);
                String name = fields[1];
                return Handle.of(id, name);
            }
            catch (NumberFormatException ignore) {
                throw new MigrationException(String.format(ERROR_MESSAGE_BAD_FILE_HANDLE, handle));
            }
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.id + ":" + this.name;
        }
    }
}

