/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.constants;

public class MigrationDumpStatus {
    public static final int PENDING = 1;
    public static final int RUNNING = 2;
    public static final int SUCCESS = 0;
    public static final int FAILED = -1;

    public static boolean isSuccess(Integer status) {
        return status != null && status == 0;
    }

    public static boolean isFailed(Integer status) {
        return status != null && status < 0;
    }

    public static boolean isTerminated(Integer status) {
        return MigrationDumpStatus.isSuccess(status) || MigrationDumpStatus.isFailed(status);
    }

    public static boolean isPendingOrRunning(Integer status) {
        return status != null && (status == 1 || status == 2);
    }

    public static boolean isReportQueryable(Integer status) {
        return status != null;
    }

    public static String display(Integer status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case 1: {
                return "PENDING";
            }
            case 2: {
                return "RUNNING";
            }
            case 0: {
                return "SUCCESS";
            }
            case -1: {
                return "FAILED";
            }
        }
        return null;
    }
}

