/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.constants;

public class MigrationLoadStatus {
    public static final int PRELOAD_READY = 1;
    public static final int PRELOAD_PENDING = 2;
    public static final int PRELOAD_RUNNING = 3;
    public static final int LOAD_READY = 4;
    public static final int LOAD_PENDING = 5;
    public static final int LOAD_RUNNING = 6;
    public static final int SUCCESS = 0;
    public static final int PRELOAD_FAILED = -1;
    public static final int LOAD_FAILED = -2;

    public static boolean isSuccess(Integer status) {
        return status != null && status == 0;
    }

    public static boolean isFailed(Integer status) {
        return status != null && status < 0;
    }

    public static boolean isTerminated(Integer status) {
        return MigrationLoadStatus.isSuccess(status) || MigrationLoadStatus.isFailed(status);
    }

    public static boolean isPendingOrRunning(Integer status) {
        return status != null && (status == 2 || status == 3 || status == 5 || status == 6);
    }

    public static boolean isPreloadReportQueryable(Integer status) {
        return status != null && (status == 2 || status == 3 || status == 4 || status == -1 || status == 5 || status == 6 || status == 0 || status == -2);
    }

    public static boolean isLoadReportQueryable(Integer status) {
        return status != null && (status == 5 || status == 6 || status == 0 || status == -2);
    }

    public static String display(Integer status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case 1: {
                return "PRELOAD_READY";
            }
            case 2: {
                return "PRELOAD_PENDING";
            }
            case 3: {
                return "PRELOAD_RUNNING";
            }
            case 4: {
                return "LOAD_READY";
            }
            case 5: {
                return "LOAD_PENDING";
            }
            case 6: {
                return "LOAD_RUNNING";
            }
            case 0: {
                return "SUCCESS";
            }
            case -1: {
                return "PRELOAD_FAILED";
            }
            case -2: {
                return "LOAD_FAILED";
            }
        }
        return null;
    }
}

