/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.micro.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.micro.app.dao.MicroApplicationConfMapper;
import com.jxdinfo.hussar.micro.app.dto.AddConfDto;
import com.jxdinfo.hussar.micro.app.dto.EditConfDto;
import com.jxdinfo.hussar.micro.app.model.MicroApplicationConf;
import com.jxdinfo.hussar.micro.app.service.IMicroApplicationConfService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.micro.app.service.impl.IMicroApplicationConfServiceImpl")
public class MicroApplicationConfServiceImpl
extends HussarServiceImpl<MicroApplicationConfMapper, MicroApplicationConf>
implements IMicroApplicationConfService {
    private static final String PARAMS_NOT_NULL = "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String NOT_REPEAT = "\u3011\u4e0d\u80fd\u91cd\u590d\uff01";
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    private static final String MA_STATUS_OPEN = "1";
    private static final String MA_STATUS_CLOSE = "0";
    @Resource
    private MicroApplicationConfMapper microApplicationConfMapper;

    public Long addConf(AddConfDto addConfDto) {
        boolean existRule;
        boolean existName;
        AssertUtil.isNotNull((Object)addConfDto, (String)PARAMS_NOT_NULL);
        String name = addConfDto.getName();
        if (!name.matches("^[a-zA-Z][a-zA-Z0-9-_]*$")) {
            throw new BaseException("\u540d\u79f0\u53ef\u4ee5\u4e3a\u82f1\u6587\u6570\u5b57\u4e0b\u5212\u7ebf\u4e2d\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u82f1\u6587\u5f00\u5934!");
        }
        boolean bl = existName = this.count((Wrapper)new LambdaUpdateWrapper().eq(MicroApplicationConf::getName, (Object)name)) > 0L;
        if (existName) {
            throw new BaseException("\u5fae\u5e94\u7528\u540d\u3010" + name + NOT_REPEAT);
        }
        boolean bl2 = existRule = this.count((Wrapper)new LambdaQueryWrapper().eq(MicroApplicationConf::getActiveRule, (Object)addConfDto.getActiveRule())) > 0L;
        if (existRule) {
            throw new BaseException("\u8def\u7531\u89c4\u5219\u3010" + addConfDto.getActiveRule() + NOT_REPEAT);
        }
        MicroApplicationConf microApplicationConf = new MicroApplicationConf();
        microApplicationConf.setName(addConfDto.getName());
        microApplicationConf.setAppId(addConfDto.getAppId());
        microApplicationConf.setEntry(addConfDto.getEntry());
        microApplicationConf.setContainer(addConfDto.getContainer());
        microApplicationConf.setActiveRule(addConfDto.getActiveRule());
        microApplicationConf.setPreload(addConfDto.getPreLoad());
        microApplicationConf.setNeedVfg(addConfDto.getNeedVfg());
        microApplicationConf.setStatus(MA_STATUS_OPEN);
        this.save((BaseEntity)microApplicationConf);
        this.addRecord(addConfDto.getAppId());
        return microApplicationConf.getId();
    }

    public void editConf(EditConfDto editConfDto) {
        AssertUtil.isNotNull((Object)editConfDto, (String)PARAMS_NOT_NULL);
        String activeRule = editConfDto.getActiveRule();
        String alreadyExitRule = ((MicroApplicationConf)this.getOne((Wrapper)new LambdaQueryWrapper().eq(MicroApplicationConf::getAppId, (Object)editConfDto.getAppId()))).getActiveRule();
        if (!alreadyExitRule.equals(activeRule)) {
            boolean existRule;
            boolean bl = existRule = this.count((Wrapper)new LambdaQueryWrapper().eq(MicroApplicationConf::getActiveRule, (Object)activeRule)) > 0L;
            if (existRule) {
                throw new BaseException("\u8def\u7531\u89c4\u5219\u3010" + activeRule + NOT_REPEAT);
            }
        }
        MicroApplicationConf microApplicationConf = new MicroApplicationConf();
        microApplicationConf.setAppId(editConfDto.getAppId());
        microApplicationConf.setEntry(editConfDto.getEntry());
        microApplicationConf.setContainer(editConfDto.getContainer());
        microApplicationConf.setActiveRule(editConfDto.getActiveRule());
        microApplicationConf.setPreload(editConfDto.getPreLoad());
        microApplicationConf.setNeedVfg(editConfDto.getNeedVfg());
        this.addRecord(editConfDto.getAppId());
        this.update((BaseEntity)microApplicationConf, (Wrapper)new LambdaQueryWrapper().eq(MicroApplicationConf::getAppId, (Object)editConfDto.getAppId()));
    }

    public List<MicroApplicationConf> getConfList() {
        return this.microApplicationConfMapper.getConfList();
    }

    public MicroApplicationConf viewConf(Long appId) {
        AssertUtil.isNotNull((Object)appId, (String)PARAMS_NOT_NULL);
        return (MicroApplicationConf)this.getOne((Wrapper)new LambdaUpdateWrapper().eq(MicroApplicationConf::getAppId, (Object)appId));
    }

    public void deleteConfForever(Long appId) {
        AssertUtil.isNotNull((Object)appId, (String)PARAMS_NOT_NULL);
        this.remove((Wrapper)new LambdaUpdateWrapper().eq(MicroApplicationConf::getAppId, (Object)appId));
    }

    public void addRecord(Long appId) {
        this.sysApplicationBoService.saveAppOperation(appId);
    }
}

