/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.micro.app.controller;

import com.jxdinfo.hussar.micro.app.dto.AddConfDto;
import com.jxdinfo.hussar.micro.app.dto.EditConfDto;
import com.jxdinfo.hussar.micro.app.model.MicroApplicationConf;
import com.jxdinfo.hussar.micro.app.service.IMicroApplicationConfService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u5e94\u7528\u914d\u7f6e\u76f8\u5173\u63a5\u53e3"})
@RestController(value="com.jxdinfo.hussar.micro.app.controller.MicroApplicationConfController")
@RequestMapping(value={"/hussarBase/application/micro"})
public class MicroApplicationConfController {
    @Resource
    private IMicroApplicationConfService microApplicationConfService;

    @PostMapping(value={"/addConf"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u5fae\u5e94\u7528\u914d\u7f6e", notes="\u65b0\u589e\u6216\u4fee\u6539\u5fae\u5e94\u7528\u914d\u7f6e")
    @CheckPermission(value={"hussarBase:application:micro:addConf"})
    @AuditLog(moduleName="\u5fae\u5e94\u7528\u914d\u7f6e\u7ba1\u7406", eventDesc="\u65b0\u589e\u6216\u4fee\u6539\u5fae\u5e94\u7528\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addOrEditConf(@RequestBody AddConfDto addConfDto) {
        Long maId = this.microApplicationConfService.addConf(addConfDto);
        return ApiResponse.success((Object)maId, (String)"\u5fae\u5e94\u7528\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/editConf"})
    @ApiOperation(value="\u4fee\u6539\u5fae\u5e94\u7528\u914d\u7f6e", notes="\u4fee\u6539\u5fae\u5e94\u7528\u914d\u7f6e")
    @CheckPermission(value={"hussarBase:application:micro:editConf"})
    @AuditLog(moduleName="\u5fae\u5e94\u7528\u914d\u7f6e", eventDesc="\u4fee\u6539\u5fae\u5e94\u7528\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse editConf(@RequestBody EditConfDto editConfDto) {
        this.microApplicationConfService.editConf(editConfDto);
        return ApiResponse.success((String)"\u5fae\u5e94\u7528\u4fe1\u606f\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/searchConf"})
    @ApiOperation(value="\u67e5\u8be2\u5fae\u5e94\u7528\u914d\u7f6e", notes="\u67e5\u8be2\u5fae\u5e94\u7528\u914d\u7f6e")
    @CheckPermission(value={"hussarBase:application:micro:searchConf"})
    @AuditLog(moduleName="\u5fae\u5e94\u7528\u914d\u7f6e\u7ba1\u7406", eventDesc="\u67e5\u8be2\u5fae\u5e94\u7528\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<MicroApplicationConf>> searchConf() {
        List list = this.microApplicationConfService.getConfList();
        return ApiResponse.success((Object)list, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @GetMapping(value={"/viewConf"})
    @ApiOperation(value="\u67e5\u770b\u5fae\u5e94\u7528\u914d\u7f6e", notes="\u67e5\u770b\u5fae\u5e94\u7528\u914d\u7f6e")
    @CheckPermission(value={"hussarBase:application:micro:viewConf"})
    @AuditLog(moduleName="\u5fae\u5e94\u7528\u914d\u7f6e\u7ba1\u7406", eventDesc="\u67e5\u770b\u5fae\u5e94\u7528\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<MicroApplicationConf> viewConf(Long appId) {
        MicroApplicationConf microApplicationConf = this.microApplicationConfService.viewConf(appId);
        return ApiResponse.success((Object)microApplicationConf, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @GetMapping(value={"/addRecord"})
    @ApiOperation(value="\u65b0\u589e\u64cd\u4f5c\u8bb0\u5f55", notes="\u65b0\u589e\u64cd\u4f5c\u8bb0\u5f55")
    @CheckPermission(value={"hussarBase:application:micro:addRecord"})
    @AuditLog(moduleName="\u5fae\u5e94\u7528\u914d\u7f6e\u7ba1\u7406", eventDesc="\u65b0\u589e\u64cd\u4f5c\u8bb0\u5f55", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse addRecord(Long appId) {
        this.microApplicationConfService.addRecord(appId);
        return ApiResponse.success((String)"\u65b0\u589e\u64cd\u4f5c\u8bb0\u5f55\u6210\u529f");
    }
}

