/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.intercept;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.intercept.HussarMessageProperties;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class HussarMessageRequestInterceptor
implements HandlerInterceptor {
    @Autowired(required=false)
    private HussarMessageProperties hussarMessageProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.hussarMessageProperties.isEnableMessageService()) {
            return true;
        }
        this.writeResponse((ServletResponse)response, this.errorResponse(10001, "\u6d88\u606f\u670d\u52a1\u672a\u5f00\u542f\uff0c\u8bf7\u5f00\u542f\u540e\u91cd\u8bd5\uff01"));
        return false;
    }

    private Map<String, Object> errorResponse(int code, String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", code);
        resultMap.put("msg", msg);
        return resultMap;
    }

    private void writeResponse(ServletResponse response, Map<String, Object> resultMap) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        PrintWriter out = response.getWriter();
        out.println(JSON.toJSONString(resultMap));
        out.flush();
        out.close();
    }
}

