/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.AppEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.model.SendRecordTenant;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.cp.dto.CpSendMsgCreateDto;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordDto;
import com.jxdinfo.hussar.msg.cp.model.MsgCpChannel;
import com.jxdinfo.hussar.msg.cp.model.MsgCpTemplate;
import com.jxdinfo.hussar.msg.cp.service.CpChannelService;
import com.jxdinfo.hussar.msg.cp.service.CpSendService;
import com.jxdinfo.hussar.msg.cp.service.MsgCpSendAsyncService;
import com.jxdinfo.hussar.msg.cp.service.MsgCpTemplateService;
import com.jxdinfo.hussar.msg.cp.third.service.MsgCpSendThirdService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@HussarTokenDs
public class CpSendServiceImpl
implements CpSendService {
    @Autowired
    private CpChannelService cpChannelService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired(required=false)
    private MsgCpSendThirdService cpSendThirdService;
    @Autowired
    private MsgCpSendAsyncService msgCpSendAsyncService;
    @Autowired
    private MsgCpTemplateService msgCpTemplateService;

    public boolean sendCpMsgMq(CpSendMsgCreateDto createDto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(createDto.getAppId(), createDto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(createDto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.CP.getCode());
        createDto.setChannelNo(configJsonData.getChannelNo());
        MsgCpChannel channel = this.getCpChannel(createDto.getChannelId(), createDto.getChannelNo());
        CpSendRecordDto record = new CpSendRecordDto();
        record.setChannelId(channel.getId().toString());
        record.setChannelNo(channel.getChannelNo());
        record.setChannelName(channel.getChannelName());
        record.setAgentSecret(channel.getAgentSecret());
        record.setAgentName(channel.getAgentName());
        record.setAgentId(channel.getAgentId());
        record.setCorpId(channel.getCorpID());
        record.setCorpName(channel.getCorpName());
        record.setToUser(createDto.getToUser());
        record.setContent(createDto.getData());
        record.setTim(createDto.getTim());
        record.setJobTime(createDto.getJobTime());
        record.setAppId(createDto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(createDto.getAppSecret());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setSceneCode(createDto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        record.setTitle(createDto.getTitle());
        record.setUrl(createDto.getUrl());
        record.setEnableDuplicateCheck(createDto.getEnableDuplicateCheck());
        record.setDuplicateCheckInterval(createDto.getDuplicateCheckInterval());
        record.setMessageType(createDto.getMessageType());
        TenantCodeUtils.fillTenantCode((SendRecordTenant)record);
        return this.msgCpSendAsyncService.sendCpAsyncMsg(record);
    }

    public boolean testSendCpMsg(CpSendMsgCreateDto createDto) {
        MsgCpChannel channel = this.cpChannelService.selectChannel(createDto.getChannelId(), createDto.getChannelNo());
        CpSendRecordDto cpSendRecordDto = new CpSendRecordDto();
        cpSendRecordDto.setChannelId(channel.getId().toString());
        cpSendRecordDto.setChannelNo(channel.getChannelNo());
        cpSendRecordDto.setChannelName(channel.getChannelName());
        cpSendRecordDto.setCorpId(channel.getCorpID());
        cpSendRecordDto.setAgentId(channel.getAgentId());
        cpSendRecordDto.setAgentName(channel.getAgentName());
        cpSendRecordDto.setCorpName(channel.getCorpName());
        cpSendRecordDto.setAgentSecret(channel.getAgentSecret());
        cpSendRecordDto.setToUser(createDto.getToUser());
        cpSendRecordDto.setContent(createDto.getData());
        cpSendRecordDto.setStatus(SendStatusEnum.SENDING.getCode());
        cpSendRecordDto.setTim(createDto.getTim());
        cpSendRecordDto.setJobTime(createDto.getJobTime());
        cpSendRecordDto.setTenantCode(createDto.getTenantCode());
        Long templateId = createDto.getTemplateId();
        if (HussarUtils.isNotEmpty((Object)templateId)) {
            Map cpParams = createDto.getCpParams();
            MsgCpTemplate msgCpTemplate = (MsgCpTemplate)this.msgCpTemplateService.getById((Serializable)templateId);
            HussarUtils.copy((Object)msgCpTemplate, (Object)cpSendRecordDto);
            cpSendRecordDto.setCpParams(cpParams);
            cpSendRecordDto.setTitle(TemplateUtils.replaceParams((String)cpSendRecordDto.getTitle(), (Map)cpParams));
            cpSendRecordDto.setUrl(TemplateUtils.replaceParams((String)cpSendRecordDto.getUrl(), (Map)cpParams));
            cpSendRecordDto.setContent(TemplateUtils.replaceParams((String)cpSendRecordDto.getContent(), (Map)cpParams));
        }
        cpSendRecordDto.setAppId(AppEnum.TEST.getAppId());
        cpSendRecordDto.setAppName(AppEnum.TEST.getAppName());
        cpSendRecordDto.setAppSecret(AppEnum.TEST.getAppSecret());
        cpSendRecordDto.setSceneCode(AppEnum.TEST.getSceneCode());
        cpSendRecordDto.setSceneName(AppEnum.TEST.getSceneName());
        return this.cpSendThirdService.sendCpTimMsg(cpSendRecordDto);
    }

    private MsgCpChannel getCpChannel(Long channelId, String channelNo) {
        MsgCpChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(MsgCpChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(MsgCpChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (MsgCpChannel)this.cpChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.nonexistent.channel.corr"));
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.not.enabled.channel"));
        }
        return channel;
    }
}

