/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.mail.dao.MsgMailReciverMapper;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailReciverCreateDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailReciverPageDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailReciverUpdateDto;
import com.jxdinfo.hussar.msg.mail.model.MsgMailReciver;
import com.jxdinfo.hussar.msg.mail.service.MsgMailReciverService;
import com.jxdinfo.hussar.msg.mail.vo.MsgMailReciverQueryVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MsgMailReciverImpl
extends HussarServiceImpl<MsgMailReciverMapper, MsgMailReciver>
implements MsgMailReciverService {
    public IPage<MsgMailReciver> listPage(Page page, MsgMailReciverPageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getReciverMail())) {
            pageDto.setReciverMail(SqlQueryUtil.transferSpecialChar((String)pageDto.getReciverMail().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getReciverName())) {
            pageDto.setReciverName(SqlQueryUtil.transferSpecialChar((String)pageDto.getReciverName().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getGroupName())) {
            pageDto.setGroupName(SqlQueryUtil.transferSpecialChar((String)pageDto.getGroupName().trim()));
        }
        IPage<MsgMailReciver> list = ((MsgMailReciverMapper)this.baseMapper).queryPage(page, pageDto);
        return list;
    }

    public List<MsgMailReciverQueryVo> getReciverList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgMailReciverMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public MsgMailReciverQueryVo findById(Long id) {
        MsgMailReciver entity = (MsgMailReciver)super.getById((Serializable)id);
        return this.entity2QueryVo(entity);
    }

    public boolean save(MsgMailReciverCreateDto createDto) {
        MsgMailReciver entity = new MsgMailReciver();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        if (HussarUtils.equals((Object)"1", (Object)this.checkReciverNameUnique(entity))) {
            throw new HussarException(entity.getReciverName() + " : " + TranslateUtil.getTranslateName((String)"msg.api.recipient.duplicated"));
        }
        if (HussarUtils.equals((Object)"1", (Object)this.checkReciverMailUnique(entity))) {
            throw new HussarException(entity.getReciverMail() + " : " + TranslateUtil.getTranslateName((String)"msg.api.email.addr.duplicated"));
        }
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(MsgMailReciverUpdateDto updateDto) {
        MsgMailReciver entity = new MsgMailReciver();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        if (HussarUtils.equals((Object)"1", (Object)this.checkReciverNameUnique(entity))) {
            throw new HussarException(entity.getReciverName() + " : " + TranslateUtil.getTranslateName((String)"msg.api.recipient.duplicated"));
        }
        if (HussarUtils.equals((Object)"1", (Object)this.checkReciverMailUnique(entity))) {
            throw new HussarException(entity.getReciverMail() + " : " + TranslateUtil.getTranslateName((String)"msg.api.email.addr.duplicated"));
        }
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        return super.removeById((Serializable)id);
    }

    public boolean deleteReciverByIds(Long[] ids) {
        return super.removeByIds(Arrays.asList(ids));
    }

    private MsgMailReciverQueryVo entity2QueryVo(MsgMailReciver entity) {
        MsgMailReciverQueryVo vo = new MsgMailReciverQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    private String checkReciverNameUnique(MsgMailReciver entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMailReciver::getGroupId, (Object)entity.getGroupId());
        qw.lambda().eq(MsgMailReciver::getReciverName, (Object)entity.getReciverName());
        MsgMailReciver info = (MsgMailReciver)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }

    private String checkReciverMailUnique(MsgMailReciver entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMailReciver::getGroupId, (Object)entity.getGroupId());
        qw.lambda().eq(MsgMailReciver::getReciverMail, (Object)entity.getReciverMail());
        MsgMailReciver info = (MsgMailReciver)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

