/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.app.service.MsgSceneContactService;
import com.jxdinfo.hussar.msg.common.properties.UnifiedMessageProperties;
import com.jxdinfo.hussar.msg.contact.dao.MsgContactInfoMapper;
import com.jxdinfo.hussar.msg.contact.dao.MsgContactServiceMapper;
import com.jxdinfo.hussar.msg.contact.dto.MsgContactDto;
import com.jxdinfo.hussar.msg.contact.dto.MsgContactIdAndTypeDto;
import com.jxdinfo.hussar.msg.contact.dto.MsgContactUpdateRestApiDto;
import com.jxdinfo.hussar.msg.contact.dto.MsgGetExtendReceiverResult;
import com.jxdinfo.hussar.msg.contact.dto.RegistrationInfo;
import com.jxdinfo.hussar.msg.contact.feign.RemoteGetExtendReceiverService;
import com.jxdinfo.hussar.msg.contact.model.MsgContact;
import com.jxdinfo.hussar.msg.contact.model.MsgContactInfo;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.contact.service.MsgContactService;
import com.jxdinfo.hussar.msg.contact.service.MsgReceiverIdProviderFactory;
import com.jxdinfo.hussar.msg.contact.service.MsgSupportedSendTypeService;
import com.jxdinfo.hussar.msg.contact.vo.ManualSyncBaseDataVo;
import com.jxdinfo.hussar.msg.contact.vo.MsgContactInfoVo;
import com.jxdinfo.hussar.msg.contact.vo.MsgSupportedSendTypeVo;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.config.HussarCoreProperties;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgContactInfoServiceImpl
extends HussarServiceImpl<MsgContactInfoMapper, MsgContactInfo>
implements MsgContactInfoService {
    private static Logger LOGGER = LoggerFactory.getLogger(MsgContactInfoServiceImpl.class);
    @Autowired
    private MsgContactInfoMapper msgContactInfoMapper;
    @Autowired
    private MsgContactService msgContactService;
    @Autowired
    private MsgSupportedSendTypeService supportedSendTypeService;
    @Autowired
    private IHussarBaseUserBoService sysUsersBoService;
    @Resource
    private MsgContactServiceMapper msgContactServiceMapper;
    @Autowired
    private MsgSceneContactService msgSceneContactService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private UnifiedMessageProperties messageProperties;
    @Autowired
    private HussarCoreProperties hussarCoreProperties;

    public ApiResponse<MsgContactInfoVo> listMsgContactInfo(Long msgContactId) {
        if (HussarUtils.isEmpty((Object)msgContactId)) {
            return ApiResponse.fail((String)"\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
        }
        MsgContact msgContact = (MsgContact)this.msgContactService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgContact::getId, (Object)msgContactId));
        if (HussarUtils.isEmpty((Object)msgContact)) {
            return ApiResponse.fail((String)"\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
        }
        HashMap registrationInfoMap = new HashMap();
        List contactInfos = this.list((Wrapper)new LambdaQueryWrapper().eq(MsgContactInfo::getContactIdAndType, (Object)msgContact.getContactIdAndType()));
        for (MsgContactInfo contactInfo : contactInfos) {
            List<Object> registrationInfos;
            if (registrationInfoMap.containsKey(contactInfo.getSendType())) {
                registrationInfos = (List)registrationInfoMap.get(contactInfo.getSendType());
            } else {
                registrationInfos = new ArrayList();
                registrationInfoMap.put(contactInfo.getSendType(), registrationInfos);
            }
            registrationInfos.add(HussarUtils.copy((Object)contactInfo, RegistrationInfo.class));
        }
        MsgContactInfoVo msgContactInfoVo = (MsgContactInfoVo)HussarUtils.copy((Object)msgContact, MsgContactInfoVo.class);
        msgContactInfoVo.setSendTypeStructure((List)this.supportedSendTypeService.getSendTypeStructure().getData());
        msgContactInfoVo.setRegistrationInfoMap(registrationInfoMap);
        return ApiResponse.success((Object)msgContactInfoVo);
    }

    @HussarTransactional
    public Boolean addMsgContactInfo(MsgContactDto msgContactDto) {
        Map registrationInfoMap = msgContactDto.getRegistrationInfoMap();
        if (HussarUtils.isEmpty((Object)registrationInfoMap)) {
            return Boolean.TRUE;
        }
        Integer maxOrder = this.msgContactInfoMapper.selectMaxOrder();
        AtomicInteger order = new AtomicInteger(maxOrder == null ? 0 : maxOrder);
        List msgContactInfoList = registrationInfoMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(registrationInfo -> {
            MsgContactInfo msgContactInfo = new MsgContactInfo();
            msgContactInfo.setContactId(msgContactDto.getContactId());
            msgContactInfo.setContactType(msgContactDto.getContactType());
            msgContactInfo.setContactName(msgContactDto.getContactName());
            msgContactInfo.setSendType((String)entry.getKey());
            msgContactInfo.setTagName(registrationInfo.getTagName());
            msgContactInfo.setReceiveAddress(registrationInfo.getReceiveAddress());
            msgContactInfo.setChannelNo(registrationInfo.getChannelNo());
            msgContactInfo.setMsgOrder(Integer.valueOf(order.incrementAndGet()));
            msgContactInfo.assembleIdAndType();
            return msgContactInfo;
        })).collect(Collectors.toList());
        return super.saveBatch(msgContactInfoList);
    }

    @HussarTransactional
    public Boolean updateMsgContactInfo(MsgContactDto msgContactDto) {
        super.remove((Wrapper)new LambdaQueryWrapper().eq(MsgContactInfo::getContactIdAndType, (Object)MsgContactInfo.assembleIdAndType((String)msgContactDto.getContactId(), (String)msgContactDto.getContactType())));
        return this.addMsgContactInfo(msgContactDto);
    }

    @HussarTransactional
    public Boolean deleteMsgContactInfo(String contactId, String contactType) {
        return super.remove((Wrapper)new LambdaQueryWrapper().eq(MsgContactInfo::getContactIdAndType, (Object)MsgContactInfo.assembleIdAndType((String)contactId, (String)contactType)));
    }

    @HussarTransactional
    public Boolean addMsgContactInfoRestApi(List<MsgContactDto> msgContactDtos) {
        List msgSupportedSendTypeVos = (List)this.supportedSendTypeService.getSendTypeStructure().getData();
        Map<String, String> channelNoMap = msgSupportedSendTypeVos.stream().filter(e -> HussarUtils.isNotEmpty((Object)e.getChannelNo())).collect(Collectors.toMap(MsgSupportedSendTypeVo::getSendTypeCode, MsgSupportedSendTypeVo::getChannelNo));
        for (MsgContactDto msgContactDto : msgContactDtos) {
            for (Map.Entry entry : msgContactDto.getRegistrationInfoMap().entrySet()) {
                if (!HussarUtils.isEmpty((Object)channelNoMap.get(entry.getKey()))) continue;
                ((List)entry.getValue()).forEach(e -> e.setChannelNo((String)channelNoMap.get(entry.getKey())));
            }
            this.addMsgContactInfo(msgContactDto);
        }
        return Boolean.TRUE;
    }

    @HussarTransactional
    public Boolean updateMsgContactInfoRestApi(List<MsgContactUpdateRestApiDto> updateRestApiDtos) {
        ArrayList<MsgContactInfo> updateList = new ArrayList<MsgContactInfo>();
        ArrayList<MsgContactInfo> addList = new ArrayList<MsgContactInfo>();
        HashSet delIdList = new HashSet();
        Set contactIdAndTypeSet = updateRestApiDtos.stream().map(e -> MsgContactInfo.assembleIdAndType((String)e.getContactId(), (String)e.getContactType())).collect(Collectors.toSet());
        List exitReceiverAddressList = this.list((Wrapper)new LambdaQueryWrapper().in(MsgContactInfo::getContactIdAndType, contactIdAndTypeSet));
        HashMap<String, Long> exitReceiverAddressMap = new HashMap<String, Long>();
        HashMap exitSendTypeMap = new HashMap();
        for (MsgContactInfo msgContactInfo : exitReceiverAddressList) {
            exitReceiverAddressMap.put(this.combineReceiverKey(msgContactInfo.getContactId(), msgContactInfo.getContactType(), msgContactInfo.getSendType(), msgContactInfo.getTagName()), msgContactInfo.getId());
            String sendTypeKey = this.combineSendTypeKey(msgContactInfo.getContactId(), msgContactInfo.getContactType(), msgContactInfo.getSendType());
            if (exitSendTypeMap.containsKey(sendTypeKey)) {
                ((List)exitSendTypeMap.get(sendTypeKey)).add(msgContactInfo.getId());
                continue;
            }
            ArrayList<Long> keys = new ArrayList<Long>();
            keys.add(msgContactInfo.getId());
            exitSendTypeMap.put(sendTypeKey, keys);
        }
        List msgSupportedSendTypeVos = (List)this.supportedSendTypeService.getSendTypeStructure().getData();
        Map<String, String> channelNoMap = msgSupportedSendTypeVos.stream().filter(e -> HussarUtils.isNotEmpty((Object)e.getChannelNo())).collect(Collectors.toMap(MsgSupportedSendTypeVo::getSendTypeCode, MsgSupportedSendTypeVo::getChannelNo));
        for (MsgContactUpdateRestApiDto updateRestApiDto : updateRestApiDtos) {
            if (HussarUtils.isNotEmpty((Object)updateRestApiDto.getDel())) {
                for (String string : updateRestApiDto.getDel()) {
                    String key = this.combineSendTypeKey(updateRestApiDto.getContactId(), updateRestApiDto.getContactType(), string);
                    if (!HussarUtils.isNotEmpty(exitSendTypeMap.get(key))) continue;
                    delIdList.addAll((Collection)exitSendTypeMap.get(key));
                }
            }
            if (!HussarUtils.isNotEmpty((Object)updateRestApiDto.getModify())) continue;
            for (Map.Entry entry : updateRestApiDto.getModify().entrySet()) {
                String sendType = (String)entry.getKey();
                for (RegistrationInfo registrationInfo : (List)entry.getValue()) {
                    String receiverAddressKey = this.combineReceiverKey(updateRestApiDto.getContactId(), updateRestApiDto.getContactType(), sendType, registrationInfo.getTagName());
                    MsgContactInfo msgContactInfo = new MsgContactInfo();
                    msgContactInfo.setReceiveAddress(registrationInfo.getReceiveAddress());
                    if (exitReceiverAddressMap.containsKey(receiverAddressKey) && !delIdList.contains(exitReceiverAddressMap.get(receiverAddressKey))) {
                        msgContactInfo.setId((Long)exitReceiverAddressMap.get(receiverAddressKey));
                        updateList.add(msgContactInfo);
                        continue;
                    }
                    msgContactInfo.setContactId(updateRestApiDto.getContactId());
                    msgContactInfo.setContactType(updateRestApiDto.getContactType());
                    msgContactInfo.setContactName(updateRestApiDto.getContactName());
                    msgContactInfo.setSendType(sendType);
                    msgContactInfo.setTagName(registrationInfo.getTagName());
                    msgContactInfo.setChannelNo(channelNoMap.get(sendType));
                    msgContactInfo.assembleIdAndType();
                    addList.add(msgContactInfo);
                }
            }
        }
        if (HussarUtils.isNotEmpty(delIdList)) {
            super.removeByIds(delIdList);
        }
        if (HussarUtils.isNotEmpty(addList)) {
            super.saveBatch(addList);
        }
        if (HussarUtils.isNotEmpty(updateList)) {
            super.updateBatchById(updateList);
        }
        return Boolean.TRUE;
    }

    private String combineReceiverKey(String contactId, String contactType, String sendType, String tagName) {
        return String.format("%s_%s_%s_%s", contactId, contactType, sendType, tagName);
    }

    private String combineSendTypeKey(String contactId, String contactType, String sendType) {
        return String.format("%s_%s_%s", contactId, contactType, sendType);
    }

    public Boolean delMsgContactInfoRestApi(List<MsgContactIdAndTypeDto> delRestApiDtos) {
        List list = delRestApiDtos.stream().map(dto -> MsgContactInfo.assembleIdAndType((String)dto.getContactId(), (String)dto.getContactType())).collect(Collectors.toList());
        return super.remove((Wrapper)new LambdaQueryWrapper().in(MsgContactInfo::getContactIdAndType, list));
    }

    public List<MsgContactInfo> getMsgContactInfoList(String tagCode) {
        List msgContactInfos = this.msgContactInfoMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(MsgContactInfo::getTagName, (Object)tagCode));
        return msgContactInfos;
    }

    @HussarTransactional
    public Boolean updateContactByTag(String tag) {
        List<Long> contactInfoIds = this.msgContactInfoMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{MsgContactInfo::getId}).eq(MsgContactInfo::getTagName, (Object)tag)).stream().map(MsgContactInfo::getId).collect(Collectors.toList());
        return this.msgContactInfoMapper.updateContactByTag(contactInfoIds);
    }

    public ApiResponse<ManualSyncBaseDataVo> CompareBaseAndContact() {
        List sysUsers = this.sysUsersBoService.list();
        List msgContacts = this.msgContactServiceMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{MsgContact::getContactId, MsgContact::getContactType}));
        ManualSyncBaseDataVo manualSyncBaseDataVo = new ManualSyncBaseDataVo();
        if (HussarUtils.isNotEmpty((Object)sysUsers)) {
            this.CompareDiffData(sysUsers, msgContacts, manualSyncBaseDataVo);
        }
        manualSyncBaseDataVo.setUserCount(Long.valueOf(sysUsers.size()));
        manualSyncBaseDataVo.setContractCount(Long.valueOf(msgContacts.size()));
        return ApiResponse.success((Object)manualSyncBaseDataVo);
    }

    public List<String> getReceiveAddress(MsgUnitySendDto msgUnitySendDto, String sendType, AppSceneConfig appSceneConfig, List<String> errorContactInfos) {
        MsgGetExtendReceiverResult providerResult = this.getExtendReceiverAddress(sendType, msgUnitySendDto);
        if (providerResult.isExitProvider()) {
            LOGGER.info("{}\u53d1\u9001\u65b9\u5f0f\uff0c\u63d0\u4f9b\u4e86\u6269\u5c55\u63a5\u6536\u4ebaid: {}", (Object)sendType, (Object)JSON.toJSONString((Object)providerResult.getReceiverAddress()));
            return providerResult.getReceiverAddress();
        }
        Map<String, String> receiveAddressAndName = this.getReceiveAddressAndName(msgUnitySendDto, sendType, appSceneConfig, errorContactInfos);
        if (HussarUtils.isNotEmpty(errorContactInfos)) {
            this.log.error("\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", errorContactInfos));
        }
        return new ArrayList<String>(receiveAddressAndName.keySet());
    }

    private MsgGetExtendReceiverResult getExtendReceiverAddress(String sendType, MsgUnitySendDto msgUnitySendDto) {
        MsgGetExtendReceiverResult result = new MsgGetExtendReceiverResult();
        if (this.hussarCoreProperties.isEnableMicroService()) {
            if (this.messageProperties.getMicroExtendReceiverSendType().contains(sendType)) {
                MsgUnitySendDto copy = (MsgUnitySendDto)BeanUtil.copyProperties((Object)msgUnitySendDto, MsgUnitySendDto.class);
                copy.setSendTypes(Collections.singletonList(sendType));
                copy.setTemplateParams(null);
                RemoteGetExtendReceiverService service = (RemoteGetExtendReceiverService)SpringContextUtil.getBean(RemoteGetExtendReceiverService.class);
                result = service.getReceiverAddress(copy);
            }
        } else if (MsgReceiverIdProviderFactory.exitExtendProvider((String)sendType)) {
            result.setExitProvider(true);
            List receiverAddress = Objects.requireNonNull(MsgReceiverIdProviderFactory.getMsgGetReceiverListener((String)sendType)).getReceiverAddress(msgUnitySendDto);
            result.setReceiverAddress(receiverAddress);
        }
        return result;
    }

    public Map<String, String> getReceiveAddressAndName(MsgUnitySendDto msgUnitySendDto, String sendType, AppSceneConfig appSceneConfig, List<String> errorContactInfos) {
        String receiveAddress;
        Map receiveAddressMap = msgUnitySendDto.getReceiveAddress();
        List contactIdAndTypeDtos = msgUnitySendDto.getContacts();
        String tagName = appSceneConfig.getTagName();
        String sceneCode = appSceneConfig.getSceneCode();
        HashMap<String, String> addressAndMap = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)receiveAddressMap) && HussarUtils.isNotEmpty((Object)(receiveAddress = (String)receiveAddressMap.get(sendType)))) {
            String[] list;
            for (String address : list = receiveAddress.split(",")) {
                if (!HussarUtils.isNotEmpty((Object)address)) continue;
                addressAndMap.put(address, null);
            }
        }
        if (HussarUtils.isEmpty(addressAndMap) && HussarUtils.isNotEmpty((Object)contactIdAndTypeDtos)) {
            addressAndMap.putAll(this.getReceiveFromContacts(contactIdAndTypeDtos, sendType, tagName, sceneCode, errorContactInfos));
        }
        if (HussarUtils.isEmpty((Object)receiveAddressMap) && HussarUtils.isEmpty((Object)contactIdAndTypeDtos)) {
            addressAndMap.putAll(this.getDefaultReceiveAddress(appSceneConfig, sendType, tagName, sceneCode, errorContactInfos));
        }
        return addressAndMap;
    }

    private Map<String, String> getReceiveFromContacts(List<MsgContactIdAndTypeDto> contactIdAndTypeDtos, String sendType, String tagName, String sceneCode, List<String> errorContactInfos) {
        HashMap<String, String> receiveAddressAndName = new HashMap<String, String>();
        String sendTypeCopy = sendType;
        if ("wx_account".equals(sendType)) {
            ConfigJsonData configData = this.appSceneConfigService.getConfigData(sceneCode, sendType);
            String channelNo = configData.getChannelNo();
            sendTypeCopy = sendType + ":" + channelNo;
        }
        for (MsgContactIdAndTypeDto contactIdAndTypeDto : contactIdAndTypeDtos) {
            String contactId = contactIdAndTypeDto.getContactId();
            String contactType = contactIdAndTypeDto.getContactType();
            String contactIdAndType = contactId + "_" + contactType;
            MsgContact msgContact = (MsgContact)this.msgContactService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgContact::getContactIdAndType, (Object)contactIdAndType));
            if (HussarUtils.isEmpty((Object)msgContact)) {
                LOGGER.error("contactId\u4e3a{}\uff0ccontactType\u4e3a{}\u7684\u8054\u7cfb\u4eba\u4e0d\u5b58\u5728", (Object)contactId, (Object)contactType);
                errorContactInfos.add(String.format("contactId\u4e3a%s\uff0ccontactType\u4e3a%s\u7684\u8054\u7cfb\u4eba\u4e0d\u5b58\u5728", contactId, contactType));
                continue;
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(MsgContactInfo::getContactIdAndType, (Object)contactIdAndType)).eq(MsgContactInfo::getSendType, (Object)sendTypeCopy);
            if (super.count((Wrapper)queryWrapper) == 0L) {
                LOGGER.error("\u6807\u8bc6\u4e3a{}\uff0c\u7c7b\u578b\u4e3a{}\u7684\u8054\u7cfb\u4eba\uff0c{}\u53d1\u9001\uff0c\u65e0\u901a\u8baf\u5730\u5740", new Object[]{contactId, contactType, sendTypeCopy});
                errorContactInfos.add(String.format("\u6807\u8bc6\u4e3a%s\uff0c\u7c7b\u578b\u4e3a%s\u8054\u7cfb\u4eba\uff0c\u65e0%s\u53d1\u9001\u901a\u8baf\u5730\u5740", contactId, contactType, sendTypeCopy));
                continue;
            }
            queryWrapper.eq(MsgContactInfo::getTagName, (Object)tagName);
            MsgContactInfo msgContactInfo = (MsgContactInfo)super.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isEmpty((Object)msgContactInfo)) {
                List list = super.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgContactInfo::getContactIdAndType, (Object)contactIdAndType)).eq(MsgContactInfo::getSendType, (Object)sendTypeCopy)).eq(MsgContactInfo::getTagName, (Object)"default"));
                if (HussarUtils.isEmpty((Object)list)) {
                    LOGGER.error("\u6807\u8bc6\u4e3a{}\uff0c\u7c7b\u578b\u4e3a{}\u7684\u8054\u7cfb\u4eba\uff0c{}\u53d1\u9001\uff0c\u65e0\u9ed8\u8ba4\u6807\u7b7e\u901a\u8baf\u5730\u5740", new Object[]{contactId, contactType, sendTypeCopy});
                    errorContactInfos.add(String.format("\u6807\u8bc6\u4e3a%s\uff0c\u7c7b\u578b\u4e3a%s\u7684\u8054\u7cfb\u4eba\uff0c%s\u53d1\u9001\uff0c\u65e0\u5bf9\u5e94\u6807\u7b7e\u4ee5\u53ca\u9ed8\u8ba4\u6807\u7b7e\u901a\u8baf\u5730\u5740", contactId, contactType, sendTypeCopy));
                    continue;
                }
                msgContactInfo = (MsgContactInfo)list.get(0);
            }
            receiveAddressAndName.put(msgContactInfo.getReceiveAddress(), msgContact.getContactName());
        }
        return receiveAddressAndName;
    }

    private Map<String, String> getDefaultReceiveAddress(AppSceneConfig appSceneConfig, String sendType, String tagName, String sceneCode, List<String> errorContactInfos) {
        Map defaultContactReceiveAddressAndName;
        block4: {
            defaultContactReceiveAddressAndName = this.msgSceneContactService.getContactReceiveAddressAndName(appSceneConfig.getId(), sendType, tagName, sceneCode, errorContactInfos);
            ConfigJsonData configData = this.appSceneConfigService.getConfigData(sceneCode, sendType);
            String defaultReceiveAddress = configData.getDefaultReceiveAddress();
            if (!HussarUtils.isNotEmpty((Object)defaultReceiveAddress)) break block4;
            String[] list = defaultReceiveAddress.split(",");
            if (HussarUtils.isNotEmpty((Object)defaultContactReceiveAddressAndName)) {
                for (String address : list) {
                    defaultContactReceiveAddressAndName.put(address, "\u65e0\u59d3\u540d");
                }
            } else {
                for (String address : list) {
                    defaultContactReceiveAddressAndName.put(address, null);
                }
            }
        }
        return defaultContactReceiveAddressAndName;
    }

    private void CompareDiffData(List<SysUsers> sysUsers, List<MsgContact> msgContactInfos, ManualSyncBaseDataVo manualSyncBaseDataVo) {
        List userIds = sysUsers.stream().map(user -> String.valueOf(user.getId())).collect(Collectors.toList());
        List contactIds = msgContactInfos.stream().filter(contact -> "user".equals(contact.getContactType())).map(MsgContact::getContactId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(userIds)) {
            userIds.removeAll(contactIds);
        }
        if (!userIds.isEmpty()) {
            manualSyncBaseDataVo.setNeedToAddCount(Long.valueOf(userIds.size()));
        }
    }
}

