/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.msg.app.model.MsgSceneContact;
import com.jxdinfo.hussar.msg.app.service.MsgSceneContactService;
import com.jxdinfo.hussar.msg.contact.dao.MsgContactServiceMapper;
import com.jxdinfo.hussar.msg.contact.dto.MsgContactDto;
import com.jxdinfo.hussar.msg.contact.dto.MsgContactIdAndTypeDto;
import com.jxdinfo.hussar.msg.contact.dto.MsgContactUpdateRestApiDto;
import com.jxdinfo.hussar.msg.contact.dto.RegistrationInfo;
import com.jxdinfo.hussar.msg.contact.model.MsgContact;
import com.jxdinfo.hussar.msg.contact.model.MsgContactInfo;
import com.jxdinfo.hussar.msg.contact.model.MsgTag;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.contact.service.MsgContactService;
import com.jxdinfo.hussar.msg.contact.service.MsgSupportedSendTypeService;
import com.jxdinfo.hussar.msg.contact.service.MsgTagService;
import com.jxdinfo.hussar.msg.contact.utils.MsgFormatCheckResult;
import com.jxdinfo.hussar.msg.contact.utils.MsgFormatCheckUtil;
import com.jxdinfo.hussar.msg.contact.vo.MsgContactRestApiVo;
import com.jxdinfo.hussar.msg.contact.vo.MsgContactVo;
import com.jxdinfo.hussar.msg.contact.vo.MsgRestApiDateVo;
import com.jxdinfo.hussar.msg.contact.vo.MsgSupportedSendTypeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgContactServiceImpl
extends HussarServiceImpl<MsgContactServiceMapper, MsgContact>
implements MsgContactService {
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private IHussarValidateService hussarValidateService;
    @Autowired
    private MsgContactServiceMapper msgContactServiceMapper;
    @Autowired
    private ISysDicRefService sysDicRefService;
    @Autowired
    private MsgSupportedSendTypeService msgSupportedSendTypeService;
    @Autowired
    private MsgTagService msgTagService;
    @Autowired
    private MsgSceneContactService msgSceneContactService;

    public ApiResponse<Page<MsgContactVo>> listMsgContact(PageInfo pageInfo, String contactId, String contactType, String contactName) {
        Page msgContactVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        List<MsgContactVo> msgContactVos = this.msgContactServiceMapper.listMsgContactPage((Page<MsgContactVo>)msgContactVoPage, SqlQueryUtil.transferSpecialChar((String)contactId), contactType, SqlQueryUtil.transferSpecialChar((String)contactName));
        return ApiResponse.success((Object)msgContactVoPage.setRecords(msgContactVos));
    }

    @HussarTransactional
    public ApiResponse<Boolean> addMsgContact(MsgContactDto msgContactDto) {
        String validateMsg = this.hussarValidateService.validate((Object)msgContactDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        long count = super.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgContact::getContactId, (Object)msgContactDto.getContactId())).eq(MsgContact::getContactType, (Object)msgContactDto.getContactType()));
        if (count > 0L) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.contactor.duplicated"));
        }
        MsgContact msgContact = (MsgContact)HussarUtils.copy((Object)msgContactDto, MsgContact.class);
        msgContact.assembleIdAndType();
        super.save((BaseEntity)msgContact);
        msgContactDto.setId(msgContact.getId());
        return ApiResponse.success((Object)this.msgContactInfoService.addMsgContactInfo(msgContactDto));
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateMsgContact(MsgContactDto msgContactDto) {
        long count;
        String validateMsg = this.hussarValidateService.validate((Object)msgContactDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        if (HussarUtils.isEmpty((Object)msgContactDto.getId())) {
            return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25");
        }
        MsgContact msgContact = (MsgContact)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgContact::getId, (Object)msgContactDto.getId()));
        if (!(HussarUtils.equals((Object)msgContact.getContactId(), (Object)msgContactDto.getContactId()) && HussarUtils.equals((Object)msgContact.getContactType(), (Object)msgContactDto.getContactType()) || (count = super.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgContact::getContactId, (Object)msgContactDto.getContactId())).eq(MsgContact::getContactType, (Object)msgContactDto.getContactType()))) <= 0L)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.contactor.duplicated"));
        }
        HussarUtils.copy((Object)msgContactDto, (Object)msgContact);
        msgContact.assembleIdAndType();
        super.updateById((BaseEntity)msgContact);
        this.msgSceneContactService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(MsgSceneContact::getMsgContactId, (Object)msgContact.getId())).set(MsgSceneContact::getContactName, (Object)msgContact.getContactName()));
        return ApiResponse.success((Object)this.msgContactInfoService.updateMsgContactInfo(msgContactDto));
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteMsgContact(Long id) {
        MsgContact contact = (MsgContact)this.getById(id);
        super.removeById((Serializable)id);
        this.msgSceneContactService.delByContactId(id);
        return ApiResponse.success((Object)this.msgContactInfoService.deleteMsgContactInfo(contact.getContactId(), contact.getContactType()));
    }

    @HussarTransactional
    public ApiResponse<MsgContactRestApiVo> addMsgContactRestApi(List<MsgContactDto> msgContactDtos) {
        if (HussarUtils.isEmpty(msgContactDtos)) {
            return ApiResponse.success();
        }
        MsgContactRestApiVo msgContactRestApiVo = new MsgContactRestApiVo();
        ArrayList<MsgRestApiDateVo> fail = new ArrayList<MsgRestApiDateVo>();
        ArrayList<MsgRestApiDateVo> success = new ArrayList<MsgRestApiDateVo>();
        HashSet<String> contactExist = new HashSet<String>();
        this.addContactRestApiVerifyParams(fail, success, contactExist, msgContactDtos);
        List msgContacts = HussarUtils.copy(msgContactDtos, MsgContact.class);
        msgContacts.forEach(MsgContact::assembleIdAndType);
        super.saveBatch((Collection)msgContacts);
        for (int i = 0; i < msgContacts.size(); ++i) {
            msgContactDtos.get(i).setId(((MsgContact)msgContacts.get(i)).getId());
        }
        this.msgContactInfoService.addMsgContactInfoRestApi(msgContactDtos);
        msgContactRestApiVo.setFail(fail);
        msgContactRestApiVo.setSuccess(success);
        return ApiResponse.success((Object)msgContactRestApiVo);
    }

    @HussarTransactional
    public ApiResponse<MsgContactRestApiVo> updateMsgContactRestApi(List<MsgContactUpdateRestApiDto> updateRestApiDtos) {
        if (HussarUtils.isEmpty(updateRestApiDtos)) {
            return ApiResponse.success();
        }
        MsgContactRestApiVo msgContactRestApiVo = new MsgContactRestApiVo();
        ArrayList<MsgRestApiDateVo> fail = new ArrayList<MsgRestApiDateVo>();
        ArrayList<MsgRestApiDateVo> success = new ArrayList<MsgRestApiDateVo>();
        this.updateContactRestApiVerifyParams(fail, success, updateRestApiDtos);
        msgContactRestApiVo.setSuccess(success);
        msgContactRestApiVo.setFail(fail);
        if (HussarUtils.isEmpty(updateRestApiDtos)) {
            return ApiResponse.success((Object)msgContactRestApiVo);
        }
        ArrayList<MsgContact> updateList = new ArrayList<MsgContact>();
        ArrayList<MsgContact> addList = new ArrayList<MsgContact>();
        Set contactIdAndTypeSet = updateRestApiDtos.stream().map(e -> MsgContactInfo.assembleIdAndType((String)e.getContactId(), (String)e.getContactType())).collect(Collectors.toSet());
        List exitContactList = this.list((Wrapper)new LambdaQueryWrapper().in(MsgContact::getContactIdAndType, contactIdAndTypeSet));
        Map<String, Long> exitContactMap = exitContactList.stream().collect(Collectors.toMap(e -> MsgContactInfo.assembleIdAndType((String)e.getContactId(), (String)e.getContactType()), MsgContact::getId));
        for (MsgContactUpdateRestApiDto updateRestApiDto : updateRestApiDtos) {
            String contactIdAndType = MsgContactInfo.assembleIdAndType((String)updateRestApiDto.getContactId(), (String)updateRestApiDto.getContactType());
            MsgContact msgContact = new MsgContact();
            msgContact.setContactName(updateRestApiDto.getContactName());
            if (exitContactMap.containsKey(contactIdAndType)) {
                msgContact.setId(exitContactMap.get(contactIdAndType));
                updateList.add(msgContact);
                continue;
            }
            msgContact.setContactId(updateRestApiDto.getContactId());
            msgContact.setContactType(updateRestApiDto.getContactType());
            msgContact.setContactName(updateRestApiDto.getContactName());
            msgContact.assembleIdAndType();
            addList.add(msgContact);
        }
        if (HussarUtils.isNotEmpty(updateList)) {
            super.updateBatchById(updateList);
        }
        if (HussarUtils.isNotEmpty(addList)) {
            super.saveBatch(addList);
        }
        this.msgContactInfoService.updateMsgContactInfoRestApi(updateRestApiDtos);
        return ApiResponse.success((Object)msgContactRestApiVo);
    }

    public ApiResponse<MsgContactRestApiVo> delMsgContactRestApi(List<MsgContactIdAndTypeDto> delRestApiDtos) {
        MsgContactRestApiVo msgContactRestApiVo = new MsgContactRestApiVo();
        ArrayList<MsgRestApiDateVo> fail = new ArrayList<MsgRestApiDateVo>();
        ArrayList<MsgRestApiDateVo> success = new ArrayList<MsgRestApiDateVo>();
        for (MsgContactIdAndTypeDto delRestApiDto : new ArrayList<MsgContactIdAndTypeDto>(delRestApiDtos)) {
            String contactId = delRestApiDto.getContactId();
            String contactType = delRestApiDto.getContactType();
            MsgRestApiDateVo msgRestApiDateVo = new MsgRestApiDateVo();
            msgRestApiDateVo.setContactId(contactId);
            msgRestApiDateVo.setContactType(contactType);
            if (HussarUtils.isEmpty((Object)contactId) || HussarUtils.isEmpty((Object)contactType)) {
                msgRestApiDateVo.setMsg(TranslateUtil.getTranslateName((String)"msg.api.empty.contactor.columns"));
                delRestApiDtos.remove(delRestApiDto);
                fail.add(msgRestApiDateVo);
                continue;
            }
            super.remove((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(MsgContact::getContactId, (Object)contactId)).eq(MsgContact::getContactType, (Object)contactType));
            success.add(msgRestApiDateVo);
        }
        this.msgContactInfoService.delMsgContactInfoRestApi(delRestApiDtos);
        msgContactRestApiVo.setFail(fail);
        msgContactRestApiVo.setSuccess(success);
        return ApiResponse.success((Object)msgContactRestApiVo);
    }

    private void addContactRestApiVerifyParams(List<MsgRestApiDateVo> fail, List<MsgRestApiDateVo> success, Set<String> contactExist, List<MsgContactDto> msgContactDtos) {
        List msgContactTypeList = this.sysDicRefService.getDicListByType("msg_contact_type");
        List<String> contactTypeList = msgContactTypeList.stream().map(DicVo::getValue).collect(Collectors.toList());
        List<String> sendTypeList = ((List)this.msgSupportedSendTypeService.getSendTypeStructure().getData()).stream().map(MsgSupportedSendTypeVo::getSendTypeCode).collect(Collectors.toList());
        List<String> tagList = this.msgTagService.list().stream().map(MsgTag::getTagName).collect(Collectors.toList());
        tagList.add("default");
        for (MsgContactDto msgContactDto : new ArrayList<MsgContactDto>(msgContactDtos)) {
            HashSet<String> contactTagExist = new HashSet<String>();
            String contactId = msgContactDto.getContactId();
            String contactType = msgContactDto.getContactType();
            Map registrationInfoMap = msgContactDto.getRegistrationInfoMap();
            MsgRestApiDateVo msgRestApiDateVo = new MsgRestApiDateVo();
            msgRestApiDateVo.setContactId(contactId);
            msgRestApiDateVo.setContactType(contactType);
            if (HussarUtils.isEmpty((Object)registrationInfoMap)) {
                msgRestApiDateVo.setMsg("registrationInfoMap\u6570\u636e\u91cc\u4e0d\u80fd\u4e3a\u7a7a\u6570\u636e");
                msgContactDtos.remove(msgContactDto);
                fail.add(msgRestApiDateVo);
                continue;
            }
            MsgFormatCheckResult checkContactId = MsgFormatCheckUtil.checkContactId(contactId);
            MsgFormatCheckResult checkContactType = MsgFormatCheckUtil.checkContactType(contactType, contactTypeList);
            MsgFormatCheckResult checkContactName = MsgFormatCheckUtil.checkContactName(msgContactDto.getContactName(), false);
            if (!checkContactId.isSuccess()) {
                msgRestApiDateVo.setMsg(checkContactId.getMsg());
            } else if (!checkContactType.isSuccess()) {
                msgRestApiDateVo.setMsg(checkContactType.getMsg());
            } else if (!checkContactName.isSuccess()) {
                msgRestApiDateVo.setMsg(checkContactName.getMsg());
            } else {
                boolean isContactExist = contactExist.add(contactId + contactType);
                long count = super.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgContact::getContactId, (Object)contactId)).eq(MsgContact::getContactType, (Object)contactType));
                if (count > 0L || !isContactExist) {
                    throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.contactor.duplicated"));
                }
                boolean allChecksPassed = this.validateContactRegistrationInfo(registrationInfoMap, sendTypeList, tagList, contactTagExist, msgRestApiDateVo);
                if (allChecksPassed) {
                    this.handleSuccessCase(msgRestApiDateVo, success);
                    continue;
                }
            }
            this.handleFailCase(msgRestApiDateVo, fail, msgContactDtos, msgContactDto, new ArrayList<MsgContactUpdateRestApiDto>(), new MsgContactUpdateRestApiDto(), true);
        }
    }

    private void updateContactRestApiVerifyParams(List<MsgRestApiDateVo> fail, List<MsgRestApiDateVo> success, List<MsgContactUpdateRestApiDto> updateRestApiDtos) {
        List msgContactTypeList = this.sysDicRefService.getDicListByType("msg_contact_type");
        List<String> contactTypeList = msgContactTypeList.stream().map(DicVo::getValue).collect(Collectors.toList());
        List<String> sendTypeList = ((List)this.msgSupportedSendTypeService.getSendTypeStructure().getData()).stream().map(MsgSupportedSendTypeVo::getSendTypeCode).collect(Collectors.toList());
        List<String> tagList = this.msgTagService.list().stream().map(MsgTag::getTagName).collect(Collectors.toList());
        tagList.add("default");
        for (MsgContactUpdateRestApiDto updateRestApiDto : new ArrayList<MsgContactUpdateRestApiDto>(updateRestApiDtos)) {
            HashSet<String> contactTagExist = new HashSet<String>();
            String contactId = updateRestApiDto.getContactId();
            String contactType = updateRestApiDto.getContactType();
            Map registrationInfoMap = updateRestApiDto.getModify();
            MsgRestApiDateVo msgRestApiDateVo = new MsgRestApiDateVo();
            msgRestApiDateVo.setContactId(contactId);
            msgRestApiDateVo.setContactType(contactType);
            MsgFormatCheckResult checkContactId = MsgFormatCheckUtil.checkContactId(contactId);
            MsgFormatCheckResult checkContactType = MsgFormatCheckUtil.checkContactType(contactType, contactTypeList);
            MsgFormatCheckResult checkContactName = MsgFormatCheckUtil.checkContactName(updateRestApiDto.getContactName(), updateRestApiDto.isUpgrade());
            if (!checkContactId.isSuccess()) {
                msgRestApiDateVo.setMsg(checkContactId.getMsg());
            } else if (!checkContactType.isSuccess()) {
                msgRestApiDateVo.setMsg(checkContactType.getMsg());
            } else if (!checkContactName.isSuccess()) {
                msgRestApiDateVo.setMsg(checkContactName.getMsg());
            } else if (HussarUtils.isNotEmpty((Object)registrationInfoMap)) {
                boolean allChecksPassed = this.validateContactRegistrationInfo(registrationInfoMap, sendTypeList, tagList, contactTagExist, msgRestApiDateVo);
                if (allChecksPassed) {
                    this.handleSuccessCase(msgRestApiDateVo, success);
                    continue;
                }
            } else {
                this.handleSuccessCase(msgRestApiDateVo, success);
                continue;
            }
            this.handleFailCase(msgRestApiDateVo, fail, new ArrayList<MsgContactDto>(), new MsgContactDto(), updateRestApiDtos, updateRestApiDto, false);
        }
    }

    private boolean validateContactRegistrationInfo(Map<String, List<RegistrationInfo>> registrationInfoMap, List<String> sendTypeList, List<String> tagList, Set<String> contactTagExist, MsgRestApiDateVo msgRestApiDateVo) {
        boolean allChecksPassed = true;
        for (Map.Entry<String, List<RegistrationInfo>> registrationInfos : registrationInfoMap.entrySet()) {
            String sendType = registrationInfos.getKey();
            MsgFormatCheckResult checkSendType = MsgFormatCheckUtil.checkSendType(sendType, sendTypeList);
            if (!checkSendType.isSuccess()) {
                msgRestApiDateVo.setMsg(checkSendType.getMsg());
                allChecksPassed = false;
                break;
            }
            List<RegistrationInfo> registrationInfoList = registrationInfos.getValue();
            for (RegistrationInfo registrationInfo : registrationInfoList) {
                String tagName = registrationInfo.getTagName();
                MsgFormatCheckResult checkTagName = MsgFormatCheckUtil.checkTagName(tagName, tagList);
                if (!checkTagName.isSuccess()) {
                    msgRestApiDateVo.setMsg(checkTagName.getMsg());
                    allChecksPassed = false;
                    break;
                }
                boolean isContactTagExist = contactTagExist.add(sendType + tagName);
                if (!isContactTagExist) {
                    msgRestApiDateVo.setMsg(TranslateUtil.getTranslateName((String)"msg.api.contactor.tags.duplicated"));
                    allChecksPassed = false;
                    break;
                }
                MsgFormatCheckResult checkReceiveAddress = MsgFormatCheckUtil.checkReceiveAddress(registrationInfo.getReceiveAddress(), sendType);
                if (checkReceiveAddress.isSuccess()) continue;
                msgRestApiDateVo.setMsg(checkReceiveAddress.getMsg());
                allChecksPassed = false;
                break;
            }
            if (allChecksPassed) continue;
            break;
        }
        return allChecksPassed;
    }

    private void handleFailCase(MsgRestApiDateVo msgRestApiDateVo, List<MsgRestApiDateVo> fail, List<MsgContactDto> msgContactDtos, MsgContactDto msgContactDto, List<MsgContactUpdateRestApiDto> updateRestApiDtos, MsgContactUpdateRestApiDto updateRestApiDto, boolean isAdd) {
        if (isAdd) {
            msgContactDtos.remove(msgContactDto);
        } else {
            updateRestApiDtos.remove(updateRestApiDto);
        }
        fail.add(msgRestApiDateVo);
    }

    private void handleSuccessCase(MsgRestApiDateVo msgRestApiDateVo, List<MsgRestApiDateVo> success) {
        success.add(msgRestApiDateVo);
    }
}

