/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.thrid.utils;

import com.jxdinfo.hussar.msg.sms.third.service.SmsThirdSendService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsThirdSendFactory {
    @Autowired
    private List<SmsThirdSendService> smsThirdSendServices;
    private static final Map<String, SmsThirdSendService> sendServiceMap = new HashMap<String, SmsThirdSendService>();

    @PostConstruct
    public void init() {
        if (HussarUtils.isNotEmpty(this.smsThirdSendServices)) {
            // empty if block
        }
        for (SmsThirdSendService smsThirdSendService : this.smsThirdSendServices) {
            sendServiceMap.put(smsThirdSendService.getChannelTypeCode(), smsThirdSendService);
        }
    }

    public static SmsThirdSendService getSmsThirdSendService(String channelTypeCode) {
        SmsThirdSendService smsThirdSendService = sendServiceMap.get(channelTypeCode);
        if (smsThirdSendService == null) {
            throw new HussarException(channelTypeCode + " : " + TranslateUtil.getTranslateName((String)"msg.api.sms.not.implement"));
        }
        return smsThirdSendService;
    }
}

