/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.send.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.factory.MsgSendExecutorFactory;
import com.jxdinfo.hussar.msg.send.dto.MsgSendRecordQueryDto;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgSendRecordService;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendAsyncService;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgUnitySendServiceImpl
implements MsgUnitySendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MsgUnitySendServiceImpl.class);
    @Autowired
    private MsgUnitySendAsyncService msgUnitySendAsyncService;
    @Autowired
    private IHussarValidateService validateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private MsgSendRecordService msgSendRecordService;

    public boolean unitySend(MsgUnitySendDto msgUnitySendDto) {
        LOGGER.info("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3\u7edf\u4e00\u53d1\u9001\u63a5\u53e3, \u53c2\u6570{}", (Object)JSON.toJSONString((Object)msgUnitySendDto));
        String validate = this.validateService.validate((Object)msgUnitySendDto);
        AssertUtil.isEmpty((String)validate, (String)validate);
        AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
        if (HussarUtils.isEmpty((Object)appSceneConfig)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.scene.nonexistent"));
        }
        if (this.appAccessService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AppAccess::getId, (Object)appSceneConfig.getAppPkId())).eq(AppAccess::getStatus, (Object)0)) == 1L) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.app.not.enabled"));
        }
        List sendTypes = msgUnitySendDto.getSendTypes();
        if (sendTypes.size() == 1 && ((String)sendTypes.get(0)).equals("all")) {
            sendTypes.remove(0);
            sendTypes.addAll(ServiceTypeEnum.getServiceMap().keySet());
            sendTypes.addAll(MsgSendExecutorFactory.getAllSendType());
        }
        this.validateSendType(sendTypes);
        TenantCodeUtils.fillTenantCode((MsgUnitySendDto)msgUnitySendDto);
        this.msgUnitySendAsyncService.sendUnityAsyncMsg(msgUnitySendDto);
        return true;
    }

    private void validateSendType(List<String> sendTypes) {
        HashSet<String> set = new HashSet<String>(sendTypes);
        set.removeAll(ServiceTypeEnum.getServiceMap().keySet());
        for (String s : set) {
            MsgSendExecutorFactory.getSendExecutor((String)s);
        }
    }

    public ApiResponse<Page<MsgSendRecord>> getList(Page<MsgSendRecord> page, MsgSendRecordQueryDto queryDto) {
        if (queryDto.getSendType() == null) {
            return ApiResponse.fail((String)"\u53d1\u9001\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page resultPage = this.msgSendRecordService.listPage(page, queryDto);
        return ApiResponse.success((Object)resultPage);
    }

    public ApiResponse sendStatistics(MsgSendRecordQueryDto queryDto) {
        if (queryDto.getSendType() == null) {
            return ApiResponse.fail((String)"\u53d1\u9001\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List result = this.msgSendRecordService.sendStatistics(queryDto);
        return ApiResponse.success((Object)result);
    }

    public ApiResponse<List<ChannelsVo>> getAllChannels(String sendType) {
        List allChannels = MsgSendExecutorFactory.getSendExecutor((String)sendType).getAllChannels();
        return ApiResponse.success((Object)allChannels);
    }
}

