/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.notice.dao.MsgNoticeTemplateMapper;
import com.jxdinfo.hussar.msg.notice.dto.MsgNoticeTemplateDto;
import com.jxdinfo.hussar.msg.notice.model.MsgNoticeTemplate;
import com.jxdinfo.hussar.msg.notice.service.MsgNoticeTemplateService;
import com.jxdinfo.hussar.msg.notice.vo.MsgNoticeTemplateVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgNoticeTemplateServiceImpl
extends HussarServiceImpl<MsgNoticeTemplateMapper, MsgNoticeTemplate>
implements MsgNoticeTemplateService {
    @Autowired
    private MsgNoticeTemplateMapper msgNoticeTemplateMapper;
    @Autowired
    private IHussarValidateService validateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public ApiResponse<Page<MsgNoticeTemplateVo>> getList(PageInfo pageInfo, String templateNo, String templateName, String content, String title, Integer openStatus) {
        Page msgNoticeTemplateVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        return ApiResponse.success(this.msgNoticeTemplateMapper.getListPage((Page<MsgNoticeTemplateVo>)msgNoticeTemplateVoPage, SqlQueryUtil.transferSpecialChar((String)templateNo), SqlQueryUtil.transferSpecialChar((String)templateName), SqlQueryUtil.transferSpecialChar((String)content), SqlQueryUtil.transferSpecialChar((String)title), openStatus));
    }

    public ApiResponse<MsgNoticeTemplateVo> listById(Long id) {
        return ApiResponse.success((Object)HussarUtils.copy((Object)super.getById((Serializable)id), MsgNoticeTemplateVo.class));
    }

    public ApiResponse<List<MsgNoticeTemplateVo>> getTemplateList() {
        List msgNoticeTemplateVos = HussarUtils.copy((Collection)super.list((Wrapper)new LambdaQueryWrapper().eq(MsgNoticeTemplate::getOpenStatus, (Object)OpenStatusEnum.ENABLE.getCode())), MsgNoticeTemplateVo.class);
        for (MsgNoticeTemplateVo msgNoticeTemplateVo : msgNoticeTemplateVos) {
            String templateParams = msgNoticeTemplateVo.getTemplateParams();
            if (!HussarUtils.isNotEmpty((Object)templateParams)) continue;
            msgNoticeTemplateVo.setTemplateParamsList(Arrays.asList(templateParams.split(",")));
        }
        return ApiResponse.success((Object)msgNoticeTemplateVos);
    }

    @HussarTransactional
    public ApiResponse<Boolean> addTemplate(MsgNoticeTemplateDto msgNoticeTemplateDto) {
        String validateMsg = this.validateService.validate((Object)msgNoticeTemplateDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String templateName = msgNoticeTemplateDto.getTemplateName();
        long count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgNoticeTemplate::getTemplateName, (Object)templateName));
        if (count > 0L) {
            throw new HussarException(templateName + " : " + TranslateUtil.getTranslateName((String)"msg.api.template.name.duplicated"));
        }
        MsgNoticeTemplate msgNoticeTemplate = (MsgNoticeTemplate)HussarUtils.copy((Object)msgNoticeTemplateDto, MsgNoticeTemplate.class);
        msgNoticeTemplate.setTemplateNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.NOTICE_TEMPLATE));
        msgNoticeTemplate.setTemplateParams(TemplateUtils.getTemplateParams((String)(msgNoticeTemplateDto.getContent() + msgNoticeTemplateDto.getTitle())));
        return ApiResponse.success((Object)super.save((BaseEntity)msgNoticeTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateTemplate(MsgNoticeTemplateDto msgNoticeTemplateDto) {
        long count;
        String validateMsg = this.validateService.validate((Object)msgNoticeTemplateDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String templateName = msgNoticeTemplateDto.getTemplateName();
        MsgNoticeTemplate msgNoticeTemplate = (MsgNoticeTemplate)super.getById((Serializable)msgNoticeTemplateDto.getId());
        if (!HussarUtils.equals((Object)msgNoticeTemplate.getTemplateName(), (Object)templateName) && (count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgNoticeTemplate::getTemplateName, (Object)templateName))) > 0L) {
            throw new HussarException(templateName + " : " + TranslateUtil.getTranslateName((String)"msg.api.template.name.duplicated"));
        }
        if (!HussarUtils.equals((Object)msgNoticeTemplate.getOpenStatus(), (Object)msgNoticeTemplateDto.getOpenStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(msgNoticeTemplate.getTemplateNo())))) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.del.corr.startup.fail"));
        }
        HussarUtils.copy((Object)msgNoticeTemplateDto, (Object)msgNoticeTemplate);
        msgNoticeTemplate.setTemplateParams(TemplateUtils.getTemplateParams((String)(msgNoticeTemplateDto.getContent() + msgNoticeTemplateDto.getTitle())));
        return ApiResponse.success((Object)super.updateById((BaseEntity)msgNoticeTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> delTemplate(List<Long> ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(ids).stream().map(MsgNoticeTemplate::getTemplateNo).collect(Collectors.toList()))) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.scene.del.corr"));
        }
        return ApiResponse.success((Object)super.removeByIds(ids));
    }
}

