/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.thrid.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendRecordService;
import com.jxdinfo.hussar.msg.mail.third.service.MailProtocolSendFactory;
import com.jxdinfo.hussar.msg.mail.third.service.MailProtocolSendService;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushThirdService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MailPushThirdServiceImpl
implements MailPushThirdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailPushThirdServiceImpl.class);
    @Resource
    private OssService ossService;
    @Autowired
    private MsgMailSendRecordService mailSendRecordService;
    @Autowired
    private MsgJobService msgJobService;

    public boolean send(MailSendRecordDto mailSendRecordDto) {
        mailSendRecordDto.setId(null);
        Date now = new Date();
        Date sendTime = new Date();
        if (mailSendRecordDto.getTim() != null && mailSendRecordDto.getTim().booleanValue()) {
            sendTime = mailSendRecordDto.getJobTime();
            this.msgJobService.saveMsgJob(mailSendRecordDto.getJobTime(), JSON.toJSONString((Object)mailSendRecordDto), MsgJobEnum.MSG_MAIL);
            mailSendRecordDto.setStatus(SendStatusEnum.SENDING.getCode());
        } else {
            this.sendMailThird(mailSendRecordDto);
        }
        mailSendRecordDto.setSendTime(sendTime);
        mailSendRecordDto.setCreateTime(now);
        mailSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        this.mailSendRecordService.saveRecord(mailSendRecordDto);
        return !SendStatusEnum.FAIL.getCode().equals(mailSendRecordDto.getStatus());
    }

    public void jobSend(MailSendRecordDto mailSendRecordDto) {
        MailSendRecordDto sendRecordDto = this.mailSendRecordService.findById(mailSendRecordDto.getId());
        if (ToolUtil.isNotEmpty((Object)sendRecordDto.getId())) {
            this.sendMailThird(sendRecordDto);
            sendRecordDto.setSendTime(new Date());
            this.mailSendRecordService.saveRecord(sendRecordDto);
        }
    }

    public boolean bathSend(MailSendRecordDto mailSendRecordDto) {
        mailSendRecordDto.setId(null);
        Date now = new Date();
        Date sendTime = new Date();
        if (mailSendRecordDto.getTim() != null && mailSendRecordDto.getTim().booleanValue()) {
            sendTime = mailSendRecordDto.getJobTime();
            this.msgJobService.saveMsgJob(mailSendRecordDto.getJobTime(), JSON.toJSONString((Object)mailSendRecordDto), MsgJobEnum.MSG_MAIL_BATH);
            mailSendRecordDto.setStatus(SendStatusEnum.SENDING.getCode());
        } else {
            this.sendMailThird(mailSendRecordDto);
        }
        mailSendRecordDto.setSendTime(sendTime);
        mailSendRecordDto.setCreateTime(now);
        mailSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        this.mailSendRecordService.saveRecord(mailSendRecordDto);
        return !SendStatusEnum.FAIL.getCode().equals(mailSendRecordDto.getStatus());
    }

    public void jobBathSend(MailSendRecordDto mailSendRecordDto) {
        MailSendRecordDto sendRecordDto = this.mailSendRecordService.findById(mailSendRecordDto.getId());
        if (HussarUtils.isNotEmpty((Object)sendRecordDto.getId())) {
            sendRecordDto.setSendTime(new Date());
            this.sendMailThird(sendRecordDto);
            this.mailSendRecordService.saveRecord(sendRecordDto);
        }
    }

    private void sendMailThird(MailSendRecordDto mailSendRecordDto) {
        try {
            List<AttachmentManagerModel> attachmentManagerModels = this.getAttachmentModels(mailSendRecordDto.getFileIds());
            MailProtocolSendService mailProtocolSendService = MailProtocolSendFactory.getMailProtocolSendService((int)mailSendRecordDto.getMailProtocol());
            mailProtocolSendService.send(mailSendRecordDto, attachmentManagerModels);
            mailSendRecordDto.setStatus(SendStatusEnum.SUCCESS.getCode());
            mailSendRecordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
        }
        catch (Exception e) {
            LOGGER.error("\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            mailSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
            mailSendRecordDto.setErrMsg(e.getMessage());
        }
    }

    private List<AttachmentManagerModel> getAttachmentModels(String ids) {
        ArrayList<AttachmentManagerModel> attachmentManagerModels = new ArrayList<AttachmentManagerModel>();
        if (ToolUtil.isEmpty((Object)ids)) {
            return attachmentManagerModels;
        }
        String[] fileIdList = ids.split(",");
        List vos = this.ossService.getByFileIds(fileIdList);
        return HussarUtils.copyProperties((Collection)vos, AttachmentManagerModel.class);
    }
}

