/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.AppEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.model.SendRecordTenant;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailSendDto;
import com.jxdinfo.hussar.msg.mail.model.MsgMailChannel;
import com.jxdinfo.hussar.msg.mail.model.MsgMailReciver;
import com.jxdinfo.hussar.msg.mail.model.MsgMailTemplate;
import com.jxdinfo.hussar.msg.mail.service.MsgMailChannelService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailReciverService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendAsyncService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailTemplateService;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushThirdService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HussarTokenDs
public class MsgMailSendServiceImpl
implements MsgMailSendService {
    @Autowired
    private MailPushThirdService mailPushThirdService;
    @Autowired
    private MsgMailChannelService mailChannelService;
    @Autowired
    private MsgMailTemplateService msgMailTemplateService;
    @Autowired
    private MsgMailReciverService msgMailReciverService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private MsgMailSendAsyncService msgMailSendAsyncService;

    public boolean send(MsgMailSendDto msgMailSendDto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(msgMailSendDto.getAppId(), msgMailSendDto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(msgMailSendDto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.MAIL.getCode());
        msgMailSendDto.setChannelNo(configJsonData.getChannelNo());
        msgMailSendDto.setTemplateNo(configJsonData.getTemplateNo());
        this.checkBeforSend(msgMailSendDto);
        this.replaceContent(msgMailSendDto);
        msgMailSendDto.setBath(Boolean.FALSE);
        MailSendRecordDto record = this.entity2MonDbRecordVo(msgMailSendDto);
        MsgMailChannel mailChannel = this.getMailChannel(msgMailSendDto.getChannelId(), msgMailSendDto.getChannelNo());
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            MsgMailTemplate mailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo());
            record.setMailTemplateId(mailTemplate.getId());
            record.setTemplateNo(mailTemplate.getTemplateNo());
            record.setTemplateName(mailTemplate.getTemplateName());
        }
        record.setChannelId(mailChannel.getId());
        record.setChannelNo(mailChannel.getChannelNo());
        record.setChannelName(mailChannel.getChannelName());
        record.setMailAddress(mailChannel.getMailAddress());
        record.setMailProtocol(mailChannel.getMailProtocol());
        record.setMailPassword(mailChannel.getMailPassword());
        record.setSenderName(mailChannel.getSenderName());
        record.setMailServerAddress(mailChannel.getMailServerAddress());
        record.setMailPort(mailChannel.getMailPort());
        record.setSafeType(mailChannel.getSafeType());
        record.setFileIds(msgMailSendDto.getFileIds());
        record.setTim(msgMailSendDto.getTim());
        record.setJobTime(msgMailSendDto.getJobTime());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(msgMailSendDto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(msgMailSendDto.getAppSecret());
        record.setSceneCode(msgMailSendDto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        TenantCodeUtils.fillTenantCode((SendRecordTenant)record);
        return this.msgMailSendAsyncService.sendMailAsyncMsg(record);
    }

    public boolean sendTest(MsgMailSendDto msgMailSendDto) {
        this.checkBeforSend(msgMailSendDto);
        this.replaceContent(msgMailSendDto);
        msgMailSendDto.setBath(Boolean.FALSE);
        MailSendRecordDto record = this.entity2MonDbRecordVo(msgMailSendDto);
        MsgMailChannel mailChannel = this.getMailChannel(msgMailSendDto.getChannelId(), msgMailSendDto.getChannelNo());
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            MsgMailTemplate mailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo());
            record.setMailTemplateId(mailTemplate.getId());
            record.setTemplateNo(mailTemplate.getTemplateNo());
            record.setTemplateName(mailTemplate.getTemplateName());
        }
        record.setChannelId(mailChannel.getId());
        record.setChannelNo(mailChannel.getChannelNo());
        record.setChannelName(mailChannel.getChannelName());
        record.setMailAddress(mailChannel.getMailAddress());
        record.setMailProtocol(mailChannel.getMailProtocol());
        record.setMailPassword(mailChannel.getMailPassword());
        record.setSenderName(mailChannel.getSenderName());
        record.setMailServerAddress(mailChannel.getMailServerAddress());
        record.setMailPort(mailChannel.getMailPort());
        record.setSafeType(mailChannel.getSafeType());
        record.setFileIds(msgMailSendDto.getFileIds());
        record.setTim(msgMailSendDto.getTim());
        record.setJobTime(msgMailSendDto.getJobTime());
        record.setAppId(AppEnum.TEST.getAppId());
        record.setAppName(AppEnum.TEST.getAppName());
        record.setAppSecret(AppEnum.TEST.getAppSecret());
        record.setSceneName(AppEnum.TEST.getSceneName());
        record.setSceneCode(AppEnum.TEST.getSceneCode());
        record.setTenantCode(msgMailSendDto.getTenantCode());
        return this.mailPushThirdService.send(record);
    }

    public boolean batchSend(MsgMailSendDto msgMailSendDto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(msgMailSendDto.getAppId(), msgMailSendDto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(msgMailSendDto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.MAIL.getCode());
        msgMailSendDto.setChannelNo(configJsonData.getChannelNo());
        msgMailSendDto.setTemplateNo(configJsonData.getTemplateNo());
        this.checkBeforSend(msgMailSendDto);
        this.replaceContent(msgMailSendDto);
        msgMailSendDto.setBath(Boolean.TRUE);
        MailSendRecordDto record = this.entity2MonDbRecordVo(msgMailSendDto);
        MsgMailChannel mailChannel = this.getMailChannel(msgMailSendDto.getChannelId(), msgMailSendDto.getChannelNo());
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            MsgMailTemplate mailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo());
            record.setMailTemplateId(mailTemplate.getId());
            record.setTemplateNo(mailTemplate.getTemplateNo());
            record.setTemplateName(mailTemplate.getTemplateName());
        }
        record.setChannelId(mailChannel.getId());
        record.setChannelNo(mailChannel.getChannelNo());
        record.setChannelName(mailChannel.getChannelName());
        record.setMailAddress(mailChannel.getMailAddress());
        record.setMailProtocol(mailChannel.getMailProtocol());
        record.setMailPassword(mailChannel.getMailPassword());
        record.setSenderName(mailChannel.getSenderName());
        record.setMailServerAddress(mailChannel.getMailServerAddress());
        record.setMailPort(mailChannel.getMailPort());
        record.setSafeType(mailChannel.getSafeType());
        record.setFileIds(msgMailSendDto.getFileIds());
        record.setGropuIds(msgMailSendDto.getGropuIds());
        record.setTim(msgMailSendDto.getTim());
        record.setJobTime(msgMailSendDto.getJobTime());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(msgMailSendDto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(msgMailSendDto.getAppSecret());
        record.setSceneCode(msgMailSendDto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        TenantCodeUtils.fillTenantCode((SendRecordTenant)record);
        this.setRecivers(record);
        return this.msgMailSendAsyncService.sendMailAsyncMsg(record);
    }

    public boolean bathSendTest(MsgMailSendDto msgMailSendDto) {
        this.checkBeforSend(msgMailSendDto);
        this.replaceContent(msgMailSendDto);
        msgMailSendDto.setBath(Boolean.TRUE);
        MailSendRecordDto record = this.entity2MonDbRecordVo(msgMailSendDto);
        MsgMailChannel mailChannel = this.getMailChannel(msgMailSendDto.getChannelId(), msgMailSendDto.getChannelNo());
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            MsgMailTemplate mailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo());
            record.setMailTemplateId(mailTemplate.getId());
            record.setTemplateNo(mailTemplate.getTemplateNo());
            record.setTemplateName(mailTemplate.getTemplateName());
        }
        record.setChannelId(mailChannel.getId());
        record.setChannelNo(mailChannel.getChannelNo());
        record.setChannelName(mailChannel.getChannelName());
        record.setMailAddress(mailChannel.getMailAddress());
        record.setMailProtocol(mailChannel.getMailProtocol());
        record.setMailPassword(mailChannel.getMailPassword());
        record.setSenderName(mailChannel.getSenderName());
        record.setMailServerAddress(mailChannel.getMailServerAddress());
        record.setMailPort(mailChannel.getMailPort());
        record.setSafeType(mailChannel.getSafeType());
        record.setFileIds(msgMailSendDto.getFileIds());
        record.setGropuIds(msgMailSendDto.getGropuIds());
        record.setTim(msgMailSendDto.getTim());
        record.setJobTime(msgMailSendDto.getJobTime());
        record.setTenantCode(msgMailSendDto.getTenantCode());
        this.setRecivers(record);
        record.setAppId(AppEnum.TEST.getAppId());
        record.setAppName(AppEnum.TEST.getAppName());
        record.setAppSecret(AppEnum.TEST.getAppSecret());
        record.setSceneName(AppEnum.TEST.getSceneName());
        record.setSceneCode(AppEnum.TEST.getSceneCode());
        return this.mailPushThirdService.bathSend(record);
    }

    private void checkBeforSend(MsgMailSendDto msgMailSendDto) {
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            String mailSubject = msgMailSendDto.getMailSubject();
            MsgMailTemplate msgMailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo());
            String mailContent = msgMailTemplate.getTemplateContent();
            LinkedHashSet params = new LinkedHashSet();
            params.addAll(TemplateUtils.getTemplateParmas((String)mailSubject));
            params.addAll(TemplateUtils.getTemplateParmas((String)mailContent));
            Map mailParms = msgMailSendDto.getMailParams();
            for (String str : params) {
                if (mailParms.containsKey(str)) continue;
                throw new HussarException(str + " : " + TranslateUtil.getTranslateName((String)"msg.api.template.params.nonnull"));
            }
        }
    }

    private void replaceContent(MsgMailSendDto msgMailSendDto) {
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            MsgMailTemplate msgMailTemplate;
            String mailContent;
            String mailSubject = msgMailSendDto.getMailSubject();
            if (ToolUtil.isNotEmpty((Object)mailSubject) && ToolUtil.isNotEmpty((Object)msgMailSendDto.getMailParams())) {
                for (String key : msgMailSendDto.getMailParams().keySet()) {
                    mailSubject = mailSubject.replaceAll("\\#\\{" + key + "}*\\}", (String)msgMailSendDto.getMailParams().get(key));
                }
                msgMailSendDto.setMailSubject(mailSubject);
            }
            if (ToolUtil.isNotEmpty((Object)(mailContent = (msgMailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo())).getTemplateContent())) && ToolUtil.isNotEmpty((Object)msgMailSendDto.getMailParams())) {
                for (String key : msgMailSendDto.getMailParams().keySet()) {
                    mailContent = mailContent.replaceAll("\\#\\{" + key + "}*\\}", (String)msgMailSendDto.getMailParams().get(key));
                }
                msgMailSendDto.setMailContent(mailContent);
            }
        }
    }

    private MailSendRecordDto entity2MonDbRecordVo(MsgMailSendDto entity) {
        MailSendRecordDto dto = new MailSendRecordDto();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)dto);
        }
        return dto;
    }

    private void setRecivers(MailSendRecordDto record) {
        if (!ToolUtil.isEmpty((Object)record.getReciverMail())) {
            return;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"group_id", (Object)record.getGropuIds());
        List recivers = this.msgMailReciverService.list((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)recivers)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.recipient.corr.unfound"));
        }
        StringBuilder recivernames = new StringBuilder();
        StringBuilder recivernameEmails = new StringBuilder();
        for (MsgMailReciver reciver : recivers) {
            String reciverName = reciver.getReciverName();
            if (ToolUtil.isEmpty((Object)reciverName)) {
                reciverName = "";
            }
            recivernames.append(reciverName).append(";");
            String reciverMail = reciver.getReciverMail();
            if (ToolUtil.isEmpty((Object)reciverMail)) {
                reciverMail = "";
            }
            recivernameEmails.append(reciverMail).append(";");
        }
        record.setReciverMail(recivernameEmails.substring(0, recivernameEmails.length() - 1));
        record.setReciverName(recivernames.substring(0, recivernames.length() - 1));
    }

    private MsgMailChannel getMailChannel(Long channelId, String channelNo) {
        MsgMailChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(MsgMailChannel::getId, (Object)channelId);
        }
        if (ToolUtil.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(MsgMailChannel::getChannelNo, (Object)channelNo);
        }
        if (ToolUtil.isEmpty((Object)(channel = (MsgMailChannel)this.mailChannelService.getOne((Wrapper)qw)))) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.nonexistent.channel.corr"));
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.not.enabled.channel"));
        }
        return channel;
    }

    private MsgMailTemplate getMailTemplate(Long templateId, String templateNo) {
        MsgMailTemplate template;
        QueryWrapper qw = new QueryWrapper();
        if (templateId != null) {
            qw.lambda().eq(MsgMailTemplate::getId, (Object)templateId);
        }
        if (ToolUtil.isNotEmpty((Object)templateNo)) {
            qw.lambda().eq(MsgMailTemplate::getTemplateNo, (Object)templateNo);
        }
        if (ToolUtil.isEmpty((Object)(template = (MsgMailTemplate)this.msgMailTemplateService.getOne((Wrapper)qw)))) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.nonexistent.template.corr"));
        }
        if (template.getStatus() == null || !template.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.not.enabled.template"));
        }
        return template;
    }
}

