/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.utils.PrintPushLogsUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.factory.MsgUnitySendFactory;
import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.msg.mail.model.MsgMailChannel;
import com.jxdinfo.hussar.msg.mail.model.MsgMailTemplate;
import com.jxdinfo.hussar.msg.mail.service.MsgMailChannelService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendAsyncService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendRecordService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailTemplateService;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgBasicSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MailUnitySendServiceImpl
implements MsgUnitySendFrameService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailUnitySendServiceImpl.class);
    @Autowired
    private MsgMailSendAsyncService msgMailSendAsyncService;
    @Autowired
    private MsgMailTemplateService msgMailTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private MsgMailChannelService msgMailChannelService;
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private MailPushThirdService mailPushThirdService;
    @Autowired
    private MsgMailSendRecordService mailSendRecordService;
    @Resource
    private IHussarBaseUserBoService iHussarBaseUserBoService;

    public MsgBasicSendRecord msgUnitySendBefore(MsgUnitySendDto msgUnitySendDto) {
        MailSendRecordDto mailSendRecordDto = new MailSendRecordDto();
        try {
            AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
            String sceneCode = appSceneConfig.getSceneCode();
            Long appAccessId = appSceneConfig.getAppPkId();
            mailSendRecordDto.setSceneName(appSceneConfig.getSceneName());
            mailSendRecordDto.setSceneCode(sceneCode);
            AppAccess appAccess = (AppAccess)this.appAccessService.getById((Serializable)appAccessId);
            mailSendRecordDto.setAppId(appAccess.getAppId());
            mailSendRecordDto.setAppName(appAccess.getAppName());
            ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(sceneCode, appAccessId.toString(), ServiceTypeEnum.MAIL.getCode());
            String templateNo = configJsonData.getTemplateNo();
            MsgMailTemplate mailTemplate = (MsgMailTemplate)this.msgMailTemplateService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgMailTemplate::getTemplateNo, (Object)templateNo));
            MsgMailChannel msgMailChannel = (MsgMailChannel)this.msgMailChannelService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgMailChannel::getChannelNo, (Object)configJsonData.getChannelNo()));
            HussarUtils.copy((Object)msgMailChannel, (Object)mailSendRecordDto);
            HussarUtils.copy((Object)mailTemplate, (Object)mailSendRecordDto);
            mailSendRecordDto.setMailParams(TemplateUtils.getCurrentTemplateParams((Map)msgUnitySendDto.getTemplateParams(), (String)mailTemplate.getTemplateParams()));
            mailSendRecordDto.setMailContent(mailTemplate.getTemplateContent());
            this.replaceContent(mailSendRecordDto);
            Map extendParams = (Map)msgUnitySendDto.getExtendParams("mail");
            if (HussarUtils.isNotEmpty((Object)extendParams)) {
                mailSendRecordDto.setCc(Optional.ofNullable(extendParams.get("cc")).orElse("").toString());
            }
            mailSendRecordDto.setStatus(Integer.valueOf(1));
            mailSendRecordDto.setBath(Boolean.valueOf(true));
            mailSendRecordDto.setTenantCode(msgUnitySendDto.getTenantCode());
            if (HussarUtils.isNotEmpty(extendParams.get("userIds"))) {
                String userIds = (String)extendParams.get("userIds");
                List userIdList = Arrays.stream(userIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
                List receivers = this.iHussarBaseUserBoService.listByIds(userIdList);
                for (SysUsers receiver : receivers) {
                    String userName = receiver.getUserName();
                    String email = receiver.geteMail();
                    if (HussarUtils.isEmpty((Object)email)) continue;
                    msgUnitySendDto.getTemplateParams().put("receiver", userName);
                    mailSendRecordDto.setMailParams(TemplateUtils.getCurrentTemplateParams((Map)msgUnitySendDto.getTemplateParams(), (String)mailTemplate.getTemplateParams()));
                    mailSendRecordDto.setMailContent(mailTemplate.getTemplateContent());
                    this.replaceContent(mailSendRecordDto);
                    mailSendRecordDto.setReciverMail(email);
                    PrintPushLogsUtils.printPushReceiveLogs(Collections.singletonList(email), (String)ServiceTypeEnum.MAIL.getCode(), (Logger)LOGGER);
                    this.mailPushThirdService.bathSend(mailSendRecordDto);
                }
                return null;
            }
            ArrayList errorContactInfos = new ArrayList();
            Map receiveAddressAndName = this.msgContactInfoService.getReceiveAddressAndName(msgUnitySendDto, ServiceTypeEnum.MAIL.getCode(), appSceneConfig, errorContactInfos);
            if (HussarUtils.isEmpty((Object)receiveAddressAndName)) {
                RuntimeException runtimeEx = HussarUtils.isNotEmpty(errorContactInfos) ? new RuntimeException(TranslateUtil.getTranslateName((String)"msg.api.contact.addr.unavailable.p2") + String.join((CharSequence)"\uff1b", errorContactInfos)) : new RuntimeException(TranslateUtil.getTranslateName((String)"msg.api.contact.addr.unavailable"));
                this.saveFailRecord(mailSendRecordDto, new RuntimeException(runtimeEx));
                return null;
            }
            ArrayList mails = new ArrayList();
            ArrayList names = new ArrayList();
            receiveAddressAndName.forEach((k, v) -> {
                mails.add(k);
                if (HussarUtils.isNotEmpty((Object)v)) {
                    names.add(v);
                }
            });
            mailSendRecordDto.setReciverMail(String.join((CharSequence)";", mails));
            mailSendRecordDto.setReciverName(String.join((CharSequence)";", names));
            PrintPushLogsUtils.printPushReceiveLogs(new ArrayList(receiveAddressAndName.keySet()), (String)ServiceTypeEnum.MAIL.getCode(), (Logger)LOGGER);
            mailSendRecordDto.setErrorContactInfos(errorContactInfos);
        }
        catch (Exception e) {
            this.saveFailRecord(mailSendRecordDto, e);
            throw e;
        }
        this.mailPushThirdService.bathSend(mailSendRecordDto);
        return null;
    }

    public String getMsgSendType() {
        return null;
    }

    public boolean msgUnityThirdSend(MsgBasicSendRecord msgBasicSendRecord) {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        MsgUnitySendFactory.setSendBeansToMap((String)"mail", (MsgUnitySendFrameService)this);
    }

    private void replaceContent(MailSendRecordDto mailSendRecordDto) {
        String mailSubject = mailSendRecordDto.getMailSubject();
        String content = mailSendRecordDto.getMailContent();
        Map mailParams = mailSendRecordDto.getMailParams();
        if (HussarUtils.isNotEmpty((Object)mailParams)) {
            mailSendRecordDto.setMailSubject(TemplateUtils.replaceParams((String)mailSubject, (Map)mailParams));
            mailSendRecordDto.setMailContent(TemplateUtils.replaceParams((String)content, (Map)mailParams));
        }
    }

    private void saveFailRecord(MailSendRecordDto mailSendRecordDto, Exception e) {
        Date now = new Date();
        if (HussarUtils.isEmpty((Object)mailSendRecordDto.getChannelNo())) {
            mailSendRecordDto.setChannelNo("null");
            mailSendRecordDto.setChannelName("\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        }
        mailSendRecordDto.setId(null);
        mailSendRecordDto.setSendTime(now);
        mailSendRecordDto.setCreateTime(now);
        mailSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        mailSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
        mailSendRecordDto.setErrMsg("\u7ec4\u88c5\u53d1\u9001\u53c2\u6570\u53d1\u751f\u5f02\u5e38\uff1a" + (HussarUtils.isNotEmpty((Object)e.getMessage()) ? e.getMessage() : e.getClass().getName()));
        this.mailSendRecordService.saveRecord(mailSendRecordDto);
    }
}

