/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.utils.PrintPushLogsUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.model.DingTalkChannel;
import com.jxdinfo.hussar.msg.dingtalk.model.MsgDingTalkTemplate;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkChannelService;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkSendRecordService;
import com.jxdinfo.hussar.msg.dingtalk.service.MsgDingTalkSendAsyncService;
import com.jxdinfo.hussar.msg.dingtalk.service.MsgDingTalkTemplateService;
import com.jxdinfo.hussar.msg.dingtalk.third.service.DingTalkThirdService;
import com.jxdinfo.hussar.msg.factory.MsgUnitySendFactory;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgBasicSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class DingTalkUnitySendServiceImpl
implements MsgUnitySendFrameService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DingTalkUnitySendServiceImpl.class);
    @Autowired
    private MsgDingTalkSendAsyncService msgDingTalkSendAsyncService;
    @Autowired
    private MsgDingTalkTemplateService msgDingTalkTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private DingTalkChannelService dingTalkChannelService;
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired(required=false)
    private DingTalkThirdService dingTalkThirdService;
    @Autowired
    private DingTalkSendRecordService dingTalkSendRecordService;

    public MsgBasicSendRecord msgUnitySendBefore(MsgUnitySendDto msgUnitySendDto) {
        DingTalkSendRecordDto dingTalkSendRecordDto = new DingTalkSendRecordDto();
        try {
            AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
            String sceneCode = appSceneConfig.getSceneCode();
            Long appAccessId = appSceneConfig.getAppPkId();
            dingTalkSendRecordDto.setSceneName(appSceneConfig.getSceneName());
            dingTalkSendRecordDto.setSceneCode(sceneCode);
            AppAccess appAccess = (AppAccess)this.appAccessService.getById((Serializable)appAccessId);
            dingTalkSendRecordDto.setAppId(appAccess.getAppId());
            dingTalkSendRecordDto.setAppName(appAccess.getAppName());
            ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(sceneCode, appAccessId.toString(), ServiceTypeEnum.DINGTALK.getCode());
            String templateNo = configJsonData.getTemplateNo();
            MsgDingTalkTemplate dingTalkTemplate = (MsgDingTalkTemplate)this.msgDingTalkTemplateService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgDingTalkTemplate::getTemplateNo, (Object)templateNo));
            DingTalkChannel dingTalkChannel = (DingTalkChannel)this.dingTalkChannelService.getOne((Wrapper)new LambdaQueryWrapper().eq(DingTalkChannel::getChannelNo, (Object)configJsonData.getChannelNo()));
            this.extracteChannel(dingTalkChannel, dingTalkSendRecordDto);
            HussarUtils.copy((Object)dingTalkTemplate, (Object)dingTalkSendRecordDto);
            dingTalkSendRecordDto.setDingTalkParams(TemplateUtils.getCurrentTemplateParams((Map)msgUnitySendDto.getTemplateParams(), (String)dingTalkTemplate.getTemplateParams()));
            this.replaceContent(dingTalkSendRecordDto);
            dingTalkSendRecordDto.setStatus(Integer.valueOf(1));
            dingTalkSendRecordDto.setTenantCode(msgUnitySendDto.getTenantCode());
            ArrayList errorContactInfos = new ArrayList();
            List receiveAddress = this.msgContactInfoService.getReceiveAddress(msgUnitySendDto, ServiceTypeEnum.DINGTALK.getCode(), appSceneConfig, errorContactInfos);
            if (HussarUtils.isEmpty((Object)receiveAddress)) {
                RuntimeException runtimeEx = HussarUtils.isNotEmpty(errorContactInfos) ? new RuntimeException(TranslateUtil.getTranslateName((String)"msg.api.contact.addr.unavailable.p2") + String.join((CharSequence)"\uff1b", errorContactInfos)) : new RuntimeException(TranslateUtil.getTranslateName((String)"msg.api.contact.addr.unavailable"));
                this.saveFailRecord(dingTalkSendRecordDto, new RuntimeException(runtimeEx));
                return null;
            }
            dingTalkSendRecordDto.setToUser(String.join((CharSequence)",", receiveAddress));
            PrintPushLogsUtils.printPushReceiveLogs((List)receiveAddress, (String)ServiceTypeEnum.DINGTALK.getCode(), (Logger)LOGGER);
            dingTalkSendRecordDto.setErrorContactInfos(errorContactInfos);
        }
        catch (Exception e) {
            this.saveFailRecord(dingTalkSendRecordDto, e);
            throw e;
        }
        this.dingTalkThirdService.sendDingTalkTimMsg(dingTalkSendRecordDto);
        return null;
    }

    private void extracteChannel(DingTalkChannel dingTalkChannel, DingTalkSendRecordDto dingTalkSendRecordDto) {
        dingTalkSendRecordDto.setChannelId(dingTalkChannel.getId().toString());
        dingTalkSendRecordDto.setChannelNo(dingTalkChannel.getChannelNo());
        dingTalkSendRecordDto.setChannelName(dingTalkChannel.getChannelName());
        dingTalkSendRecordDto.setAppKey(dingTalkChannel.getAppKey());
        dingTalkSendRecordDto.setDingAppSecret(dingTalkChannel.getAppSecret());
        dingTalkSendRecordDto.setDingAppName(dingTalkChannel.getAppName());
        dingTalkSendRecordDto.setAgentId(dingTalkChannel.getAgentId());
        dingTalkSendRecordDto.setCorpName(dingTalkChannel.getCorpName());
    }

    public String getMsgSendType() {
        return null;
    }

    public boolean msgUnityThirdSend(MsgBasicSendRecord msgBasicSendRecord) {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        MsgUnitySendFactory.setSendBeansToMap((String)"dingTalk", (MsgUnitySendFrameService)this);
    }

    private void replaceContent(DingTalkSendRecordDto dingTalkSendRecordDto) {
        String title = dingTalkSendRecordDto.getTitle();
        String content = dingTalkSendRecordDto.getContent();
        String btnJsonList = dingTalkSendRecordDto.getBtnJsonList();
        String singleTitle = dingTalkSendRecordDto.getSingleTitle();
        String singleUrl = dingTalkSendRecordDto.getSingleUrl();
        Map dingTalkParams = dingTalkSendRecordDto.getDingTalkParams();
        if (HussarUtils.isNotEmpty((Object)dingTalkParams)) {
            dingTalkSendRecordDto.setTitle(TemplateUtils.replaceParams((String)title, (Map)dingTalkParams));
            dingTalkSendRecordDto.setBtnJsonList(TemplateUtils.replaceParams((String)btnJsonList, (Map)dingTalkParams));
            dingTalkSendRecordDto.setContent(TemplateUtils.replaceParams((String)content, (Map)dingTalkParams));
            dingTalkSendRecordDto.setSingleTitle(TemplateUtils.replaceParams((String)singleTitle, (Map)dingTalkParams));
            dingTalkSendRecordDto.setSingleUrl(TemplateUtils.replaceParams((String)singleUrl, (Map)dingTalkParams));
        }
    }

    private void saveFailRecord(DingTalkSendRecordDto dingTalkSendRecordDto, Exception e) {
        Date now = new Date();
        if (HussarUtils.isEmpty((Object)dingTalkSendRecordDto.getChannelNo())) {
            dingTalkSendRecordDto.setChannelNo("null");
            dingTalkSendRecordDto.setChannelName("\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        }
        dingTalkSendRecordDto.setId(null);
        dingTalkSendRecordDto.setSendTime(now);
        dingTalkSendRecordDto.setCreateTime(now);
        dingTalkSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        dingTalkSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
        dingTalkSendRecordDto.setErrMsg("\u7ec4\u88c5\u53d1\u9001\u53c2\u6570\u53d1\u751f\u5f02\u5e38\uff1a" + (HussarUtils.isNotEmpty((Object)e.getMessage()) ? e.getMessage() : e.getClass().getName()));
        this.dingTalkSendRecordService.saveRecord(dingTalkSendRecordDto);
    }
}

