/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.third.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.IdUtil;
import com.jxdinfo.hussar.msg.cp.config.MsgWxCpConfig;
import com.jxdinfo.hussar.msg.cp.dto.CpSendMsgConfigDto;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordDto;
import com.jxdinfo.hussar.msg.cp.service.CpSendRecordService;
import com.jxdinfo.hussar.msg.cp.third.service.MsgCpSendThirdService;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.bean.message.WxCpMessage;
import me.chanjar.weixin.cp.bean.message.WxCpMessageSendResult;
import me.chanjar.weixin.cp.bean.messagebuilder.MarkdownMsgBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextCardBuilder;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HussarTokenDs
public class MsgCpSendThirdServiceImpl
implements MsgCpSendThirdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MsgCpSendThirdServiceImpl.class);
    @Autowired
    private MsgJobService msgJobService;
    @Autowired
    private CpSendRecordService cpSendRecordService;
    @Autowired
    private MsgWxCpConfig msgWxCpConfig;

    public boolean sendCpTimMsg(CpSendRecordDto cpSendRecordDto) {
        cpSendRecordDto.setId(null);
        if (null != cpSendRecordDto.getTim() && cpSendRecordDto.getTim().booleanValue()) {
            String msgId = IdUtil.fastSimpleUuid();
            cpSendRecordDto.setMsgId(msgId);
            this.msgJobService.saveMsgJob(cpSendRecordDto.getJobTime(), JSONObject.toJSONString((Object)cpSendRecordDto), MsgJobEnum.MSG_CP);
            Date now = new Date();
            cpSendRecordDto.setCreateTime(now);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            cpSendRecordDto.setCreateDate(dateFormat.format(now));
            cpSendRecordDto.setSendTime(cpSendRecordDto.getJobTime());
            this.cpSendRecordService.saveRecord(cpSendRecordDto);
            return true;
        }
        return this.sendCpMsg(cpSendRecordDto);
    }

    public boolean jobMsg(CpSendRecordDto cpSendRecordDto) {
        this.sendCpMsg(cpSendRecordDto);
        CpSendRecordDto entityDto = this.cpSendRecordService.findById(cpSendRecordDto.getMsgId());
        if (HussarUtils.isNotEmpty((Object)entityDto.getId())) {
            entityDto.setStatus(cpSendRecordDto.getStatus());
            entityDto.setErrMsg(cpSendRecordDto.getErrMsg());
            this.cpSendRecordService.saveRecord(entityDto);
        }
        return true;
    }

    private boolean sendCpMsg(CpSendRecordDto cpSendRecordDto) {
        boolean flag = true;
        Integer status = SendStatusEnum.SUCCESS.getCode();
        cpSendRecordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
        CpSendMsgConfigDto cpConfig = new CpSendMsgConfigDto();
        HussarUtils.copy((Object)cpSendRecordDto, (Object)cpConfig);
        cpConfig.setToUser(cpSendRecordDto.getToUser().replace(",", "|"));
        cpConfig.setAgentId(Integer.valueOf(Integer.parseInt(cpSendRecordDto.getAgentId())));
        try {
            WxCpMessageSendResult wxCpMessageSendResult = this.sendCpThirdMsg(cpConfig);
            if (wxCpMessageSendResult.getErrCode() != 0) {
                status = SendStatusEnum.FAIL.getCode();
                cpSendRecordDto.setErrMsg(wxCpMessageSendResult.getErrMsg());
                flag = false;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            status = SendStatusEnum.FAIL.getCode();
            cpSendRecordDto.setErrMsg(e.getMessage());
            flag = false;
        }
        cpSendRecordDto.setStatus(status);
        if (HussarUtils.isEmpty((Object)cpSendRecordDto.getMsgId())) {
            String msgId = IdUtil.fastSimpleUuid();
            Date now = new Date();
            cpSendRecordDto.setMsgId(msgId);
            cpSendRecordDto.setCreateTime(now);
            Date sendTime = new Date();
            cpSendRecordDto.setSendTime(sendTime);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            cpSendRecordDto.setCreateDate(dateFormat.format(now));
            this.cpSendRecordService.saveRecord(cpSendRecordDto);
        }
        return flag;
    }

    private WxCpMessageSendResult sendCpThirdMsg(CpSendMsgConfigDto configDto) throws Exception {
        int agentId = configDto.getAgentId();
        String corpId = configDto.getCorpId();
        String corpSecret = configDto.getAgentSecret();
        WxCpDefaultConfigImpl config = new WxCpDefaultConfigImpl();
        config.setCorpId(corpId);
        config.setCorpSecret(corpSecret);
        config.setAgentId(Integer.valueOf(agentId));
        if (HussarUtils.isNotEmpty((Object)this.msgWxCpConfig.getHttpProxyHost())) {
            config.setHttpProxyHost(this.msgWxCpConfig.getHttpProxyHost());
        }
        if (HussarUtils.isNotEmpty((Object)this.msgWxCpConfig.getHttpProxyPort())) {
            config.setHttpProxyPort(this.msgWxCpConfig.getHttpProxyPort().intValue());
        }
        if (HussarUtils.isNotEmpty((Object)this.msgWxCpConfig.getHttpProxyUsername())) {
            config.setHttpProxyUsername(this.msgWxCpConfig.getHttpProxyUsername());
        }
        if (HussarUtils.isNotEmpty((Object)this.msgWxCpConfig.getHttpProxyPassword())) {
            config.setHttpProxyPassword(this.msgWxCpConfig.getHttpProxyPassword());
        }
        if (HussarUtils.isNotEmpty((Object)this.msgWxCpConfig.getBaseApiUrl())) {
            config.setBaseApiUrl(this.msgWxCpConfig.getBaseApiUrl());
        }
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
        WxCpMessage wxCpMessage = this.buildMessage(configDto);
        if (Boolean.TRUE.equals(configDto.getEnableDuplicateCheck())) {
            wxCpMessage.setEnableDuplicateCheck(Boolean.valueOf(true));
            wxCpMessage.setDuplicateCheckInterval(configDto.getDuplicateCheckInterval());
        }
        WxCpMessageSendResult result = wxCpService.getMessageService().send(wxCpMessage);
        return result;
    }

    private WxCpMessage buildMessage(CpSendMsgConfigDto configDto) {
        if (HussarUtils.isEmpty((Object)configDto.getMessageType()) || "text".equals(configDto.getMessageType())) {
            return ((TextBuilder)((TextBuilder)WxCpMessage.TEXT().agentId(configDto.getAgentId())).toUser(configDto.getToUser())).content(configDto.getContent()).build();
        }
        if ("markdown".equals(configDto.getMessageType())) {
            return ((MarkdownMsgBuilder)((MarkdownMsgBuilder)WxCpMessage.MARKDOWN().agentId(configDto.getAgentId())).toUser(configDto.getToUser())).content(configDto.getContent()).build();
        }
        if ("textcard".equals(configDto.getMessageType())) {
            return ((TextCardBuilder)((TextCardBuilder)WxCpMessage.TEXTCARD().agentId(configDto.getAgentId())).toUser(configDto.getToUser())).title(configDto.getTitle()).description(configDto.getContent()).url(configDto.getUrl()).build();
        }
        throw new RuntimeException(TranslateUtil.getTranslateName((String)"msg.api.incorrect.msg.type"));
    }
}

