/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.utils;

import com.jxdinfo.hussar.msg.common.enums.TipConstantsEnum;
import com.jxdinfo.hussar.msg.contact.utils.MsgFormatCheckResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.List;

public class MsgFormatCheckUtil {
    public static MsgFormatCheckResult checkContactId(String contactId) {
        int supportLength = 85;
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (HussarUtils.isEmpty((Object)contactId)) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_ID_EMPTY.getMessage()));
            return msgFormatCheckResult;
        }
        if (contactId.length() > supportLength) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_ID_LENGTH_EXCEEDS_LIMIT.getMessage()) + supportLength);
            return msgFormatCheckResult;
        }
        if (!contactId.matches("^[a-zA-Z0-9]*$")) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_ID_ONLY_ALLOW_ENGLISH_NUMBER.getMessage()));
            return msgFormatCheckResult;
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }

    public static MsgFormatCheckResult checkContactName(String contactName, boolean isEmptyName) {
        int supportLength = 128;
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (!isEmptyName) {
            if (HussarUtils.isEmpty((Object)contactName)) {
                msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_NAME_EMPTY.getMessage()));
                return msgFormatCheckResult;
            }
            if (contactName.length() > supportLength) {
                msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_NAME_LENGTH_EXCEEDS_LIMIT.getMessage()) + supportLength);
                return msgFormatCheckResult;
            }
            if (!contactName.matches("^[\u4e00-\u9fa5a-zA-Z0-9]*$")) {
                msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_NAME_ONLY_ALLOW_CHINESE_ENGLISH_NUMBER.getMessage()));
                return msgFormatCheckResult;
            }
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }

    public static MsgFormatCheckResult checkContactType(String contactType, List<String> contactTypes) {
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (HussarUtils.isEmpty((Object)contactType)) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_TYPE_EMPTY.getMessage()));
            return msgFormatCheckResult;
        }
        if (!contactTypes.contains(contactType)) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_TYPE_NOT_SUPPORTED.getMessage()));
            return msgFormatCheckResult;
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }

    public static MsgFormatCheckResult checkTagName(String tagName, List<String> tagNames) {
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (HussarUtils.isEmpty((Object)tagName)) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_TAG_EMPTY.getMessage()));
            return msgFormatCheckResult;
        }
        if (!tagNames.contains(tagName)) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_TAG_NOT_SUPPORTED.getMessage()));
            return msgFormatCheckResult;
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }

    public static MsgFormatCheckResult checkSendType(String sendType, List<String> sendTypes) {
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (HussarUtils.isEmpty((Object)sendType)) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_SEND_TYPE_EMPTY.getMessage()));
            return msgFormatCheckResult;
        }
        if (!sendTypes.contains(sendType)) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_SEND_TYPE_NOT_SUPPORTED.getMessage()));
            return msgFormatCheckResult;
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }

    public static MsgFormatCheckResult checkReceiveAddress(String receiveAddress, String sendType) {
        int supportLength = 128;
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (HussarUtils.isEmpty((Object)receiveAddress)) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_MAILING_ADDRESS_EMPTY.getMessage()));
            return msgFormatCheckResult;
        }
        if (receiveAddress.length() > supportLength) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_MAILING_ADDRESS_LENGTH_EXCEEDS_LIMIT.getMessage()) + supportLength);
            return msgFormatCheckResult;
        }
        if ("sms".equals(sendType) && !receiveAddress.matches("^1[3-9]\\d{9}$")) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_INVALID_PHONE_NUMBER_FORMAT.getMessage()));
            return msgFormatCheckResult;
        }
        if ("mail".equals(sendType) && !receiveAddress.matches("^[^\\s@]+@[^\\s@]+\\.[^\\s@]+$")) {
            msgFormatCheckResult.setMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_INVALID_EMAIL_ADDRESS_FORMAT.getMessage()));
            return msgFormatCheckResult;
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }
}

