/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.controller;

import com.jxdinfo.hussar.msg.mail.dto.MsgMailSendDto;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailTemplateService;
import com.jxdinfo.hussar.msg.mail.vo.MsgMailTemplateQueryVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u90ae\u4ef6\u53d1\u9001"})
@RequestMapping(value={"msg/msgMail"})
public class MailSenderController {
    @Autowired
    private MsgMailSendService mailSendService;
    @Autowired
    private MsgMailTemplateService mailTemplateService;

    @GetMapping(value={"/getTemplateList"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u5217\u8868", notes="\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @AuditLog(moduleName="\u90ae\u4ef6\u53d1\u9001", eventDesc="\u83b7\u53d6\u6a21\u677f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<MsgMailTemplateQueryVo>> getTemplateList() {
        return ApiResponse.success((Object)this.mailTemplateService.getTemplateList());
    }

    @PostMapping(value={"/send"})
    @ApiOperation(value="\u5355\u6b21\u53d1\u9001\u90ae\u4ef6", notes="\u5355\u6b21\u53d1\u9001\u90ae\u4ef6")
    @AuditLog(moduleName="\u90ae\u4ef6\u53d1\u9001", eventDesc="\u5355\u6b21\u53d1\u9001\u90ae\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> send(@Validated @RequestBody MsgMailSendDto msgMailSendDto) {
        return ApiResponse.status((boolean)this.mailSendService.send(msgMailSendDto));
    }

    @PostMapping(value={"/bathsend"})
    @ApiOperation(value="\u6279\u91cf\u53d1\u9001\u90ae\u4ef6", notes="\u6279\u91cf\u53d1\u9001\u90ae\u4ef6")
    @AuditLog(moduleName="\u90ae\u4ef6\u53d1\u9001", eventDesc="\u6279\u91cf\u53d1\u9001\u90ae\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> bathSend(@Validated @RequestBody MsgMailSendDto msgMailSendDto) {
        return ApiResponse.status((boolean)this.mailSendService.batchSend(msgMailSendDto));
    }
}

