/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.msg.contact.model.MsgContact;
import com.jxdinfo.hussar.msg.contact.model.MsgContactInfo;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.contact.service.MsgContactService;
import com.jxdinfo.hussar.msg.contact.service.MsgImportBaseUsersService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgImportBaseUsersServiceImpl
implements MsgImportBaseUsersService {
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private MsgContactService msgContactService;

    @HussarTransactional
    public void importBaseUsers(List<SysUsers> users, Long loginId) {
        LambdaQueryWrapper selectWrapper = ((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgContact::getContactType, (Object)"user")).select(new SFunction[]{MsgContact::getId, MsgContact::getContactId});
        Map<String, Long> exitContactIdMap = this.msgContactService.list((Wrapper)selectWrapper).stream().collect(Collectors.toMap(MsgContact::getContactId, MsgContact::getId));
        ArrayList<MsgContact> updateMsgContacts = new ArrayList<MsgContact>();
        ArrayList<MsgContactInfo> msgContactInfos = new ArrayList<MsgContactInfo>();
        ArrayList<MsgContact> addMsgContacts = new ArrayList<MsgContact>();
        ArrayList<String> delContactIdAndTypes = new ArrayList<String>();
        for (SysUsers sysUser : users) {
            String userName = sysUser.getUserName();
            MsgContactInfo ContactSms = this.transformSysUserToMsgContactInfo(userName, "sms", sysUser.getMobile(), String.valueOf(sysUser.getId()), loginId);
            MsgContactInfo ContactMail = this.transformSysUserToMsgContactInfo(userName, "mail", sysUser.geteMail(), String.valueOf(sysUser.getId()), loginId);
            if (ContactSms != null) {
                msgContactInfos.add(ContactSms);
            }
            if (ContactMail != null) {
                msgContactInfos.add(ContactMail);
            }
            if (exitContactIdMap.containsKey(String.valueOf(sysUser.getId()))) {
                MsgContact updateContact = new MsgContact();
                updateContact.setId(exitContactIdMap.get(String.valueOf(sysUser.getId())));
                updateContact.setContactName(userName);
                updateMsgContacts.add(updateContact);
                delContactIdAndTypes.add(MsgContact.assembleIdAndType((String)String.valueOf(sysUser.getId()), (String)"user"));
                continue;
            }
            MsgContact msgContact = new MsgContact();
            msgContact.setContactName(userName);
            msgContact.setContactId(String.valueOf(sysUser.getId()));
            msgContact.setContactType("user");
            msgContact.assembleIdAndType();
            msgContact.setCreator(loginId);
            addMsgContacts.add(msgContact);
        }
        int batchSize = 500;
        for (int i = 0; i < delContactIdAndTypes.size(); i += batchSize) {
            List subList = delContactIdAndTypes.subList(i, Math.min(i + batchSize, delContactIdAndTypes.size()));
            this.msgContactInfoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgContactInfo::getSendType, (Object)"sms")).in(MsgContactInfo::getContactIdAndType, subList));
            this.msgContactInfoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgContactInfo::getSendType, (Object)"mail")).in(MsgContactInfo::getContactIdAndType, subList));
        }
        this.msgContactService.saveBatch(addMsgContacts);
        this.msgContactInfoService.saveBatch(msgContactInfos);
        this.msgContactService.updateBatchById(updateMsgContacts);
    }

    private MsgContactInfo transformSysUserToMsgContactInfo(String userName, String sendType, String receiveAddress, String contactId, long loginId) {
        if (HussarUtils.isEmpty((Object)receiveAddress)) {
            return null;
        }
        MsgContactInfo msgContactInfo = new MsgContactInfo();
        msgContactInfo.setCreator(Long.valueOf(loginId));
        msgContactInfo.setContactName(userName);
        msgContactInfo.setReceiveAddress(receiveAddress);
        msgContactInfo.setSendType(sendType);
        msgContactInfo.setContactId(contactId);
        msgContactInfo.setTagName("default");
        msgContactInfo.setContactType("user");
        msgContactInfo.assembleIdAndType();
        return msgContactInfo;
    }
}

