/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.thrid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordDto;
import com.jxdinfo.hussar.msg.apppush.service.AppPushSendRecordService;
import com.jxdinfo.hussar.msg.apppush.third.service.AppPushThirdService;
import com.jxdinfo.hussar.msg.apppush.vo.AppPushSendRecordQueryVo;
import com.jxdinfo.hussar.msg.common.enums.ActionTypeEnum;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.push.model.Response;
import com.jxdinfo.push.model.message.Action;
import com.jxdinfo.push.model.message.ApnsMessage;
import com.jxdinfo.push.model.message.HwMessage;
import com.jxdinfo.push.model.message.Message;
import com.jxdinfo.push.service.PushService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HussarTokenDs
public class AppPushThirdServiceImpl
implements AppPushThirdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppPushThirdServiceImpl.class);
    @Autowired
    private MsgJobService msgJobService;
    @Autowired
    private AppPushSendRecordService appPushSendRecordService;

    public boolean sendPushTimMsg(AppPushSendRecordDto appPushSendRecordDto) {
        boolean flag = true;
        appPushSendRecordDto.setId(null);
        if (appPushSendRecordDto.getTim() != null && appPushSendRecordDto.getTim().booleanValue()) {
            this.msgJobService.saveMsgJob(appPushSendRecordDto.getJobTime(), JSONObject.toJSONString((Object)appPushSendRecordDto), MsgJobEnum.MSG_APPPUSH);
            appPushSendRecordDto.setStatus(SendStatusEnum.SENDING.getCode());
            Date now = new Date();
            appPushSendRecordDto.setSendTime(appPushSendRecordDto.getJobTime());
            appPushSendRecordDto.setCreateTime(now);
            appPushSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appPushSendRecordService.saveRecord(appPushSendRecordDto);
        } else {
            try {
                Response<Boolean> response = this.appSendThirdMsg(appPushSendRecordDto);
                if (response.getSuccess().booleanValue()) {
                    appPushSendRecordDto.setStatus(SendStatusEnum.SUCCESS.getCode());
                    appPushSendRecordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
                } else {
                    flag = false;
                    appPushSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
                    appPushSendRecordDto.setErrMsg(String.format("code:%s,mag:%s", response.getRespCode(), response.getMsg()));
                }
            }
            catch (Exception e) {
                LOGGER.error("app\u63a8\u9001\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                appPushSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
                flag = false;
                appPushSendRecordDto.setErrMsg(e.getMessage());
            }
            Date now = new Date();
            appPushSendRecordDto.setSendTime(now);
            appPushSendRecordDto.setCreateTime(now);
            appPushSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appPushSendRecordService.saveRecord(appPushSendRecordDto);
        }
        return flag;
    }

    public boolean jobMsg(AppPushSendRecordDto appPushSendRecordDto) {
        AppPushSendRecordQueryVo appPushSendRecordQueryVo = this.appPushSendRecordService.findById(appPushSendRecordDto.getId());
        AppPushSendRecordDto entityDto = new AppPushSendRecordDto();
        BeanUtils.copyProperties((Object)appPushSendRecordQueryVo, (Object)entityDto);
        if (HussarUtils.isNotEmpty((Object)entityDto.getId())) {
            try {
                Response<Boolean> response = this.appSendThirdMsg(entityDto);
                if (response.getSuccess().booleanValue()) {
                    entityDto.setStatus(SendStatusEnum.SUCCESS.getCode());
                    appPushSendRecordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
                } else {
                    entityDto.setErrMsg(String.format("code:%s,mag:%s", response.getRespCode(), response.getMsg()));
                    entityDto.setStatus(SendStatusEnum.FAIL.getCode());
                }
            }
            catch (Exception e) {
                LOGGER.error("app\u63a8\u9001\u53d1\u9001\u5b9a\u65f6\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                entityDto.setErrMsg(e.getMessage());
                entityDto.setStatus(SendStatusEnum.FAIL.getCode());
            }
            entityDto.setSendTime(new Date());
            this.appPushSendRecordService.saveRecord(entityDto);
        }
        return true;
    }

    private Response<Boolean> appSendThirdMsg(AppPushSendRecordDto appPushSendRecordDto) {
        PushService push = PushService.builder().audienceType(appPushSendRecordDto.getAudienceType()).platform(appPushSendRecordDto.getPlatform()).environment(Integer.valueOf(1)).messageType(Integer.valueOf(0)).build();
        push.setAppId(appPushSendRecordDto.getAppId());
        push.setAccessId(appPushSendRecordDto.getAssessId());
        push.setSecretKey(appPushSendRecordDto.getSecretKey());
        push.setTimeout(15000);
        push.setTokenList(appPushSendRecordDto.getTokenList());
        Message message = this.createMessage(appPushSendRecordDto);
        Response response = push.sendMessage(message);
        return response;
    }

    private Message createMessage(AppPushSendRecordDto appPushSendRecordDto) {
        if (appPushSendRecordDto.getActionType() == null) {
            appPushSendRecordDto.setActionType(Integer.valueOf(0));
        }
        Action action = new Action();
        action.setType(appPushSendRecordDto.getActionType());
        if (appPushSendRecordDto.getActionType().equals(ActionTypeEnum.OPEN_ACTIVITY.getCode())) {
            action.setActivity(appPushSendRecordDto.getActionAddress());
        } else if (appPushSendRecordDto.getActionType().equals(ActionTypeEnum.OPEN_BROWSER.getCode())) {
            action.setUrl(appPushSendRecordDto.getActionAddress());
        } else if (appPushSendRecordDto.getActionType().equals(ActionTypeEnum.OPEN_INTENT.getCode())) {
            action.setIntent(appPushSendRecordDto.getActionAddress());
        }
        HwMessage hwMessage = new HwMessage();
        hwMessage.setAutoCancel(Boolean.valueOf(true));
        ApnsMessage apnsMessage = new ApnsMessage();
        apnsMessage.setContentAvailable(1);
        Message message = Message.builder().title(appPushSendRecordDto.getTitle()).content(appPushSendRecordDto.getContent()).badge(appPushSendRecordDto.getAngleMark()).vibrate(Integer.valueOf(1)).expireTime(Integer.valueOf(1000)).lights(Integer.valueOf(1)).ring(Integer.valueOf(1)).action(action).hwMessage(hwMessage).apnsMessage(apnsMessage).build();
        return message;
    }
}

