/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.send.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendAsyncService;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgUnitySendServiceImpl
implements MsgUnitySendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MsgUnitySendServiceImpl.class);
    @Autowired
    private MsgUnitySendAsyncService msgUnitySendAsyncService;
    @Autowired
    private IHussarValidateService validateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;

    public boolean unitySend(MsgUnitySendDto msgUnitySendDto) {
        LOGGER.info("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3\u7edf\u4e00\u53d1\u9001\u63a5\u53e3, \u53c2\u6570{}", (Object)JSON.toJSONString((Object)msgUnitySendDto));
        String validate = this.validateService.validate((Object)msgUnitySendDto);
        AssertUtil.isEmpty((String)validate, (String)validate);
        AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
        if (HussarUtils.isEmpty((Object)appSceneConfig)) {
            throw new HussarException("\u4e0d\u5b58\u5728\u5f53\u524d\u573a\u666f");
        }
        if (this.appAccessService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AppAccess::getId, (Object)appSceneConfig.getAppPkId())).eq(AppAccess::getStatus, (Object)0)) == 1L) {
            throw new HussarException("\u5e94\u7528\u672a\u542f\u7528");
        }
        List sendTypes = msgUnitySendDto.getSendTypes();
        if (sendTypes.size() == 1 && ((String)sendTypes.get(0)).equals("all")) {
            sendTypes.remove(0);
            sendTypes.addAll(ServiceTypeEnum.getServiceMap().keySet());
        }
        TenantCodeUtils.fillTenantCode((MsgUnitySendDto)msgUnitySendDto);
        this.msgUnitySendAsyncService.sendUnityAsyncMsg(msgUnitySendDto);
        return true;
    }
}

