/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.job.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordDto;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushThirdService;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordDto;
import com.jxdinfo.hussar.msg.apppush.third.service.AppPushThirdService;
import com.jxdinfo.hussar.msg.common.properties.MsgJobExecutionProperties;
import com.jxdinfo.hussar.msg.common.properties.UnifiedMessageProperties;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordDto;
import com.jxdinfo.hussar.msg.cp.third.service.MsgCpSendThirdService;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.third.service.DingTalkThirdService;
import com.jxdinfo.hussar.msg.job.dto.JobParamsVo;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushThirdService;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordDto;
import com.jxdinfo.hussar.msg.mp.third.service.MpSendMsgThirdService;
import com.jxdinfo.hussar.msg.notice.model.Notice;
import com.jxdinfo.hussar.msg.notice.third.service.NoticeSendThirdService;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordDto;
import com.jxdinfo.hussar.msg.sms.third.service.SmsPushService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.job.core.enums.ExecuteType;
import com.jxdinfo.hussar.support.job.core.enums.ProcessorType;
import com.jxdinfo.hussar.support.job.core.enums.TimeExpressionType;
import com.jxdinfo.hussar.support.job.core.request.http.SaveJobInfoRequest;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MsgJobServiceImpl
implements MsgJobService {
    private static final Logger logger = LoggerFactory.getLogger(MsgJobServiceImpl.class);
    @Autowired(required=false)
    private JobServiceService jobServiceService;
    @Autowired
    private SmsPushService smsPushService;
    @Autowired(required=false)
    private MpSendMsgThirdService mpSendMsgThirdService;
    @Autowired(required=false)
    private AppImPushThirdService appImPushThirdService;
    @Autowired
    private MailPushThirdService mailPushThirdService;
    @Autowired(required=false)
    private AppPushThirdService appPushThirdService;
    @Autowired
    private NoticeSendThirdService noticeSendThirdService;
    @Autowired
    private UnifiedMessageProperties unifiedMessageProperties;
    @Autowired
    private MsgJobExecutionProperties msgJobExecutionProperties;
    @Autowired(required=false)
    private MsgCpSendThirdService cpSendThirdService;
    @Autowired(required=false)
    private DingTalkThirdService dingTalkThirdService;

    public ApiResponse saveMsgJob(Date triggerTime, String params, MsgJobEnum msgJobEnum) {
        System.out.println("\u6253\u5305\u6d4b\u8bd5");
        if (this.msgJobExecutionProperties.isEnableSingleModel()) {
            if (!this.msgJobExecutionProperties.isEnableExecutor() || !this.msgJobExecutionProperties.isEnableServer()) {
                throw new HussarException("\u4efb\u52a1\u8c03\u5ea6\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u53d1\u9001\u5b9a\u65f6\u6d88\u606f\uff01");
            }
        } else if (!this.msgJobExecutionProperties.isEnableExecutor()) {
            throw new HussarException("\u6267\u884c\u5668\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u53d1\u9001\u5b9a\u65f6\u6d88\u606f\uff01");
        }
        if (HussarUtils.isEmpty((Object)triggerTime)) {
            throw new HussarException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u4e3a\u7a7a\uff01");
        }
        if (triggerTime.getTime() < System.currentTimeMillis() + 120000L) {
            throw new HussarException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f42\u5206\u949f\u4ee5\u4e0a\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)this.jobServiceService)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("ss mm HH dd MM ? yyyy");
            String jobTime = dateFormat.format(triggerTime);
            JobParamsVo jobParamsVo = new JobParamsVo();
            jobParamsVo.setType(msgJobEnum.getCode());
            jobParamsVo.setJobParams(params);
            SaveJobInfoRequest saveJobInfoRequest = new SaveJobInfoRequest();
            saveJobInfoRequest.setJobName(msgJobEnum.getName());
            saveJobInfoRequest.setJobDescription(msgJobEnum.getName());
            saveJobInfoRequest.setTimeExpression(jobTime);
            saveJobInfoRequest.setJobParams(JSONObject.toJSONString((Object)jobParamsVo));
            saveJobInfoRequest.setAppId(this.unifiedMessageProperties.getJobAppId());
            saveJobInfoRequest.setTimeExpressionType(TimeExpressionType.CRON);
            saveJobInfoRequest.setExecuteType(ExecuteType.STANDALONE);
            saveJobInfoRequest.setProcessorType(ProcessorType.BUILT_IN);
            saveJobInfoRequest.setProcessorInfo("com.jxdinfo.hussar.msg.config.MsgJobProcessors");
            try {
                ApiResponse response = this.jobServiceService.saveJobApi(saveJobInfoRequest);
                if (response.getCode() != ResultCode.SUCCESS.getCode()) {
                    throw new HussarException(response.getMsg());
                }
                return response;
            }
            catch (ParseException e) {
                throw new HussarException(e.getMessage());
            }
        }
        return ApiResponse.fail((String)"\u65e0\u6cd5\u6ce8\u5165Bean jobServiceService");
    }

    public void deleteMsgJob(Long jobId) {
        this.jobServiceService.physicalDeleteJob(jobId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendMsg(JobParamsVo jobParamsVo, Long jobId) {
        MsgJobEnum msgJobEnum = MsgJobEnum.getByCode((String)jobParamsVo.getType());
        if (msgJobEnum == null) {
            return;
        }
        try {
            switch (msgJobEnum) {
                case MSG_SMS: {
                    this.smsPushService.jobSendMsg((SmsSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), SmsSendRecordDto.class));
                    return;
                }
                case MSG_MP: {
                    this.mpSendMsgThirdService.jobMsg((MpSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), MpSendRecordDto.class));
                    return;
                }
                case MSG_APPIM_TEXT: {
                    this.appImPushThirdService.jobSendTextMsg((AppImSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), AppImSendRecordDto.class));
                    return;
                }
                case MSG_APPIM_ARTICLE: {
                    this.appImPushThirdService.jobSendArticleMsg((AppImSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), AppImSendRecordDto.class));
                    return;
                }
                case MSG_APPIM_IMG: {
                    this.appImPushThirdService.jobSendImgMsg((AppImSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), AppImSendRecordDto.class));
                    return;
                }
                case MSG_APPIM_FILE: {
                    this.appImPushThirdService.jobSendFileMsg((AppImSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), AppImSendRecordDto.class));
                    return;
                }
                case MSG_MAIL: {
                    this.mailPushThirdService.jobSend((MailSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), MailSendRecordDto.class));
                    return;
                }
                case MSG_MAIL_BATH: {
                    this.mailPushThirdService.jobBathSend((MailSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), MailSendRecordDto.class));
                    return;
                }
                case MSG_APPPUSH: {
                    this.appPushThirdService.jobMsg((AppPushSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), AppPushSendRecordDto.class));
                    return;
                }
                case MSG_NOTICE: {
                    this.noticeSendThirdService.jonSendNotice((Notice)JSONObject.parseObject((String)jobParamsVo.getJobParams(), Notice.class));
                    return;
                }
                case MSG_CP: {
                    this.cpSendThirdService.jobMsg((CpSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), CpSendRecordDto.class));
                    return;
                }
                case MSG_DINGTALK: {
                    this.dingTalkThirdService.jobSendMsg((DingTalkSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), DingTalkSendRecordDto.class));
                    return;
                }
                default: {
                    logger.error("\u9519\u8bef\u7684\u6d88\u606f\u7c7b\u578b");
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error(JSON.toJSONString((Object)jobParamsVo), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.deleteMsgJob(jobId);
        }
    }
}

