/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.dingtalk.dao.DingTalkChannelMapper;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkChCreateDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkChUpdateDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkChannelDto;
import com.jxdinfo.hussar.msg.dingtalk.model.DingTalkChannel;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkChannelService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class DingTalkChannelServiceImpl
extends HussarServiceImpl<DingTalkChannelMapper, DingTalkChannel>
implements DingTalkChannelService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private IHussarValidateService validateService;

    public IPage<DingTalkChannel> listPage(Page page, DingTalkChannelDto dto) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getChannelName()})) {
            dto.setChannelName("%" + dto.getChannelName().trim() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getChannelNo()})) {
            dto.setChannelNo("%" + dto.getChannelNo().trim() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getCorpName()})) {
            dto.setCorpName("%" + dto.getCorpName().trim() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getAppName()})) {
            dto.setAppName("%" + dto.getAppName().trim() + "%");
        }
        IPage<DingTalkChannel> pageList = ((DingTalkChannelMapper)this.baseMapper).queryPage(page, dto);
        return pageList;
    }

    @HussarTransactional
    public boolean save(DingTalkChCreateDto createDto) {
        String regex = "\\d+";
        if (!createDto.getAgentId().matches(regex)) {
            throw new HussarException("\u5e94\u7528ID\u53ea\u80fd\u662f\u6570\u5b57");
        }
        String validateMsg = this.validateService.validate((Object)createDto);
        if (validateMsg != null && !"".equals(validateMsg)) {
            throw new HussarException(validateMsg);
        }
        DingTalkChannel dingTalkChannel = new DingTalkChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)dingTalkChannel);
        long id = IdWorker.getId((Object)dingTalkChannel);
        dingTalkChannel.setId(Long.valueOf(id));
        dingTalkChannel.setChannelNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.DINGTALK_CHANNEL));
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(dingTalkChannel))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + dingTalkChannel.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        super.save((BaseEntity)dingTalkChannel);
        return true;
    }

    @HussarTransactional
    public boolean update(DingTalkChUpdateDto updateDto) {
        if (null == updateDto) {
            updateDto = new DingTalkChUpdateDto();
        }
        String regex = "\\d+";
        if (!updateDto.getAgentId().matches(regex)) {
            throw new HussarException("\u5e94\u7528ID\u53ea\u80fd\u662f\u6570\u5b57");
        }
        String validateMsg = this.validateService.validate((Object)updateDto);
        if (validateMsg != null && !"".equals(validateMsg)) {
            throw new HussarException(validateMsg);
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(DingTalkChannel::getId, (Object)updateDto.getId());
        DingTalkChannel info = (DingTalkChannel)((DingTalkChannelMapper)this.baseMapper).selectOne((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)info)) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff01");
        }
        DingTalkChannel dingTalkChannel = new DingTalkChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)dingTalkChannel);
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(dingTalkChannel))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + dingTalkChannel.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        if (!HussarUtils.equals((Object)info.getStatus(), (Object)updateDto.getStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(info.getChannelNo())))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u52a8\u72b6\u6001\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        super.updateById((BaseEntity)dingTalkChannel);
        return true;
    }

    @HussarTransactional
    public boolean delete(Long id) {
        DingTalkChannel dingTalkChannel = (DingTalkChannel)((DingTalkChannelMapper)this.baseMapper).selectById(id);
        if (HussarUtils.isEmpty((Object)dingTalkChannel)) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0d\u5b58\u5728,\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\uff01");
        }
        if (this.appSceneConfigService.isExistScene(dingTalkChannel.getChannelNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        super.removeById((Serializable)id);
        return true;
    }

    @HussarTransactional
    public boolean deleteByIds(Long[] ids) {
        List channelNos = super.listByIds(Arrays.asList(ids)).stream().map(DingTalkChannel::getChannelNo).collect(Collectors.toList());
        if (this.appSceneConfigService.isExistSceneInBatch(channelNos)) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        super.removeByIds(Arrays.asList(ids));
        return true;
    }

    public List<DingTalkChannelDto> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(DingTalkChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((DingTalkChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::transferDto).collect(Collectors.toList());
    }

    public DingTalkChannel selectbyChannelNo(String channelNo) {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(DingTalkChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().eq(DingTalkChannel::getChannelNo, (Object)channelNo);
        DingTalkChannel dingTalkChannel = (DingTalkChannel)((DingTalkChannelMapper)this.baseMapper).selectOne((Wrapper)qw);
        return dingTalkChannel;
    }

    public Map<String, String> getChannelNoAndName(List<String> channelNos) {
        if (HussarUtils.isEmpty(channelNos)) {
            return new HashMap<String, String>();
        }
        Map<String, String> channelNoAndName = super.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{DingTalkChannel::getChannelNo, DingTalkChannel::getChannelName}).in(DingTalkChannel::getChannelNo, channelNos)).stream().collect(Collectors.toMap(DingTalkChannel::getChannelNo, DingTalkChannel::getChannelName));
        channelNoAndName.put("null", "\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        return channelNoAndName;
    }

    private DingTalkChannelDto transferDto(DingTalkChannel dingTalkChannel) {
        DingTalkChannelDto dto = new DingTalkChannelDto();
        BeanUtils.copyProperties((Object)dingTalkChannel, (Object)dto);
        return dto;
    }

    private String checkChannelUnique(DingTalkChannel dingTalkChannel) {
        Long id = dingTalkChannel.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(DingTalkChannel::getChannelName, (Object)dingTalkChannel.getChannelName());
        DingTalkChannel channel = (DingTalkChannel)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)channel) && !HussarUtils.equals((Object)channel.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

